//
//  UIImage+CreditWallet.h
//  CreditWallet
//
//  Created by 逍遥子 on 2016/11/17.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import <UIKit/UIKit.h>

@interface UIImage (CreditWallet)

/**
 *  把图片等比例缩放到指定尺寸  不失真
 *
 *  @param targetSize 目标尺寸
 *
 *  @return 获得图片
 */
- (UIImage * )imageByScalingAndCroppingForTargetSize:(CGSize)targetSize;

/**
 *  把图片等比例缩放到不低于指定尺寸
 *
 *  @param minSize 目标最低尺寸
 *
 *  @return 获得图片
 */
- (UIImage *)imageByScalingAndCroppingForMinSize:(CGSize)minSize;


/**
 图片转成Base64字符串,并压缩到指定内存大小
 
 @param maxLength 目标大小
 @param minSize 最小尺寸
 @return 字符串
 */
-(NSString *)imageToBase64StrMaxLength:(NSInteger)maxLength minSize:(CGSize)minSize;

/**
 颜色转图片

 @param color 颜色
 @param size 尺寸
 @return 目标图片
 */
+(UIImage *)imageWithColor:(UIColor *)color size:(CGSize)size;

/**
 颜色转图片 带圆角

 @param color 颜色
 @param size 尺寸
 @param radius 圆角
 @return 目标图片
 */
+(UIImage *)imageWithColor:(UIColor *)color size:(CGSize)size cornerRadius:(CGFloat)radius;

/**
 截屏window
 
 @param view 提供上下文大小、透明开关
 @return 返回截屏图片
 */
+ (UIImage *)snapshotWithView:(UIView *)view;

@end
