//
//  QGUserCenterRequestApi.h
//  VirtualPayment
//
//  Created by 邢超 on 2019/7/3.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface QGUserCenterRequestApi : NSObject
///个人中心模块请求方法枚举
typedef NS_ENUM(NSInteger, QGUserCenterRequestServerMethod) {
    ///2.获取未读消息数
    QGUserCenterRequestServerMethodUnread,
    ///站内信列表
    QGUserCenterRequestServerMethodStationLetterList,
    ///标记通知消息已读
    QGUserCenterRequestServerMethodMarkReadOrDel,
    ///4.帮助中心热门问题
    QGUserCenterRequestServerMethodHelpCenterHot,
    ///5.上传图片获取token
    QGUserCenterRequestServerMethodPersonalUpload,
    ///6.保存头像
    QGUserCenterRequestServerMethodPersonalSave,
    ///7.意见反馈的问题类型
    QGUserCenterRequestServerMethodFeedbackType,
    ///8.提交意见反馈
    QGUserCenterRequestServerMethodFeedbackSubmit,
    ///9.修改密码
    QGUserCenterRequestServerMethodResetPaddword,
    ///10.获取银行卡列表页的URL
    QGUserCenterRequestServerMethodBankCardUrl,
    ///11.获取重置密码URL
    QGUserCenterRequestServerMethodRestPwdUrl,
    ///个人中心配置项
    QGUserCenterRequestServerMethodConfigMine,
    ///推广-上传idfa
    QGUserCenterRequestServerMethodIdfaSave,
    ///个人资料配置信息
    QGUserCenterRequestServerMethodPersonalMenu,
};

/*!
 根据接口名返回URL
 */
+(NSString*)urlWithUserCenterRequestServerMethod:(QGUserCenterRequestServerMethod)method;
@end
