//
//  QGNotificationCell.m
//  CreditWallet
//
//  Created by harry on 29/12/2017.
//  Copyright © 2017 QuantGroup. All rights reserved.
//

#import "QGNotificationCell.h"
#import "UIFont+QGFont.h"
#import "UIColor+QGColor.h"
#import "ZHAttributedLabelTool.h"
#import "QGAppMacro.h"
#import "Masonry.h"


@interface QGNotificationCell (){
    UILabel *_titleLabel;
    UILabel *_timeLabel;
    UILabel *_contentLabel;
    UIView  *_bottomLine;
}


@end

@implementation QGNotificationCell


- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        //底部分割线
        UIView *bottomLine = [[UIView alloc] init];
        _bottomLine = bottomLine;
        bottomLine.backgroundColor = [UIColor colorWithHexString:@"DCDCDC"];
        [self.contentView addSubview:bottomLine];
        [bottomLine mas_updateConstraints:^(MASConstraintMaker *make) {
            make.bottom.equalTo(self.contentView.mas_bottom);
            make.left.equalTo(self.contentView.mas_left).offset(20.f);
            make.size.mas_equalTo(CGSizeMake(MAINSCREEN_WIDTH - 40, .5f));
        }];
    }
    return self;
}

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}


- (void)updateModel:(QGMessageListModel *)model{
    if (model) {
        UIFont *font = [UIFont qg_regularFontOfSize:14];
        UIColor *textColor = [UIColor textColor3333];
        if (!_titleLabel){
            _titleLabel = [[UILabel alloc] init];
        }
        if (!_titleLabel.superview) {
            [self.contentView addSubview:_titleLabel];
        }
        if (!model.title) {
            model.title = @"";
        }
        NSMutableString *muStr = [NSMutableString string];
        if (model.is_ack && ![model.is_ack integerValue]) {
            [muStr appendString:@"● "];
        }
        [muStr appendString:model.title];
        if (model.is_ack && [model.is_ack integerValue]) {
            textColor = [UIColor textColor9999];
        }
        NSMutableAttributedString *attStr = [[NSMutableAttributedString alloc] initWithString:muStr attributes:@{NSFontAttributeName:font,NSForegroundColorAttributeName:textColor}];
        if (model.is_ack && ![model.is_ack integerValue]) {
            UIColor *dotColor = [UIColor mainThemeColor];
            [attStr addAttributes:@{NSFontAttributeName:font,NSForegroundColorAttributeName:dotColor} range:NSMakeRange(0, 2)];
        }
        _titleLabel.numberOfLines = 1;
        _titleLabel.attributedText = attStr;
        
        
        font = [UIFont qg_lightFontOfSize:11];
        UIColor *timeColor = [UIColor textColor9999];
        NSString *showTimeStr = model.msgTime;
        CGSize timeSize = [ZHAttributedLabelTool getSizeWithFont:font maxWidth:230.f contentStr:showTimeStr];
        
        CGFloat titleWidth = MAINSCREEN_WIDTH-20-timeSize.width-20.f-34.f;
        _titleLabel.frame = CGRectMake(20.f, 20.f, titleWidth, ceilf([font lineHeight]));
        
        if (!_timeLabel){
            _timeLabel = [[UILabel alloc] init];
            _timeLabel.font = font;
            _timeLabel.textColor = timeColor;
            _timeLabel.numberOfLines = 1;
        }
        _timeLabel.text = model.msgTime;
        if (!_timeLabel.superview) {
            [self.contentView addSubview:_timeLabel];
        }
        _timeLabel.frame = CGRectMake(MAINSCREEN_WIDTH-timeSize.width-20.f, 22.f, timeSize.width, ceilf([font lineHeight]));
        
        font = [UIFont qg_lightFontOfSize:13];
        textColor = [UIColor textColor6666];
        if (model.is_ack && [model.is_ack integerValue]) {
            textColor = [UIColor textColor9999];
        }
        if (!_contentLabel){
            _contentLabel = [[UILabel alloc] init];
            _contentLabel.font = font;
            _contentLabel.textAlignment = NSTextAlignmentLeft;
            _contentLabel.backgroundColor = [UIColor clearColor];
            _contentLabel.numberOfLines = 2;
        }
        _contentLabel.textColor = textColor;
        if (!model.content){
            model.content = @"";
        }
        ZHAttributedLabelTool *attTool = [[ZHAttributedLabelTool alloc] initWithText:model.content font:font color:textColor];
        [attTool setLineSpacing:1];
        [attTool setLineBreakMode:NSLineBreakByTruncatingTail];
        [attTool setLabelPropertyWithLabel:_contentLabel];
        if (!_contentLabel.superview) {
            [self.contentView addSubview:_contentLabel];
        }
        CGFloat width = MAINSCREEN_WIDTH-40.f;
        _contentLabel.frame = CGRectMake(20, CGRectGetMaxY(_titleLabel.frame)+10, width, 40);
        [_contentLabel sizeToFit];
    }
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];
    _bottomLine.backgroundColor = [UIColor colorWithHexString:@"DCDCDC"];
}

- (void)setHighlighted:(BOOL)highlighted animated:(BOOL)animated {
    [super setHighlighted:highlighted animated:animated];
    _bottomLine.backgroundColor = [UIColor colorWithHexString:@"DCDCDC"];
}

- (void)setEditing:(BOOL)editing animated:(BOOL)animated {
    [super setEditing:editing animated:animated];
}



@end
