//
//  QGNoMessageDataView.m
//  CreditWallet
//
//  Created by harry on 29/12/2017.
//  Copyright © 2017 QuantGroup. All rights reserved.
//

#import "QGNoMessageDataView.h"
#import "QGAppMacro.h"
#import "QGBasicUITool.h"


@interface QGNoMessageDataView (){
    UILabel *_textLabel;
}

@end

@implementation QGNoMessageDataView

- (instancetype)initWithFrame:(CGRect)frame{
    self = [super initWithFrame:frame];
    if (self) {
        self.backgroundColor = [UIColor whiteColor];
        UIImage *image = [UIImage imageNamed:@"messageNoDataIcon"];
        UIImageView *imageView = [[UIImageView alloc] init];
        imageView.image = image;
        [self addSubview:imageView];
        [imageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.equalTo(self.mas_centerX);
            make.top.equalTo(self.mas_top).mas_equalTo(@(92*Screen_Scaling));
            make.size.mas_equalTo(image.size);
        }];
        
        UIFont *font = [UIFont qg_lightFontOfSize:13];
        UILabel *textLabel = [[UILabel alloc] init];
        textLabel.font = font;
        textLabel.textColor = [UIColor textColor9999];
        textLabel.text= @"您没有收到任何消息哦";
        textLabel.backgroundColor = [UIColor whiteColor];
        textLabel.textAlignment = NSTextAlignmentCenter;
        [self addSubview:textLabel];
        [textLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.equalTo(self.mas_centerX);
            make.top.equalTo(imageView.mas_bottom).mas_equalTo(@(30));
            make.size.mas_equalTo(CGSizeMake(MAINSCREEN_WIDTH, ceilf([font lineHeight])));
        }];
        _textLabel = textLabel;
        
    }
    return self;
}

- (void)setText:(NSString *)text{
    if (_text != text) {
        _text = text;
        _textLabel.text = text;
    }
}

- (void)setThemeBgColor:(UIColor *)themeBgColor{
    if (_themeBgColor != themeBgColor) {
        _themeBgColor = themeBgColor;
        if (_themeBgColor) {
            self.backgroundColor = _themeBgColor;
            _textLabel.backgroundColor = _themeBgColor;
        }
    }
}



@end
