//
//  ConfirmDeleteView.m
//  CreditWallet
//
//  Created by 金修博 on 17/3/6.
//  Copyright © 2017年 QuantGroup. All rights reserved.
//

#import "ConfirmDeleteView.h"
#import "QGBasicUITool.h"
#import "SystemManager.h"
@interface ConfirmDeleteView ()

@property (strong, nonatomic) UIView *menuView;
@property (strong, nonatomic) UIView *btnView;
@property (strong, nonatomic) UIButton *deleteBtn;

@end

@implementation ConfirmDeleteView

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    
    if (self) {
        //初始化UI
        [self setupUI];
    }
    
    return self;
}


- (void)setupUI {
    //负责动画的view
    UIView *menuView = [[UIView alloc] initWithFrame:CGRectMake(0, MAINSCREEN_HEIGHT, MAINSCREEN_WIDTH, (99+[DeviceAdaptation getBottomSafeAreaHeight]))];
    self.menuView = menuView;
    menuView.backgroundColor = [UIColor whiteColor];
    [self addSubview:menuView];
    
    //管理button的view
    UIView *btnView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, 99)];
    self.btnView = btnView;
    //btnView.alpha = 0.0;
    [menuView addSubview:btnView];
    
    //创建menuView上的子控件
    //删除按钮
    UIButton *deleteBtn = [[UIButton alloc] initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, 49)];
    self.deleteBtn = deleteBtn;
    [deleteBtn setTitle:@"确定删除" forState:UIControlStateNormal];
    [deleteBtn setTitleColor:[UIColor mainThemeColor] forState:UIControlStateNormal];
    deleteBtn.titleLabel.font = [UIFont systemFontOfSize:17.0];
    deleteBtn.backgroundColor = [UIColor whiteColor];
    [deleteBtn addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
    [deleteBtn addTarget:self action:@selector(btnClickHigh:) forControlEvents:UIControlEventTouchDown];
    [deleteBtn addTarget:self action:@selector(btnClickOutSide:) forControlEvents:UIControlEventTouchUpOutside];
    deleteBtn.tag = 1001;
    [btnView addSubview:deleteBtn];
    
    
    //[deleteBtn setBackgroundImage:[UIImage createImageWithColor:[UIColor redColor]] forState:UIControlStateHighlighted];
    
    //分割线
    UIView *sepratorLine = [[UIView alloc] initWithFrame:CGRectMake(0, CGRectGetMaxY(deleteBtn.frame), MAINSCREEN_WIDTH, 0.5)];
    sepratorLine.backgroundColor = [UIColor lineSeparatorColorDCDC];
    [btnView addSubview:sepratorLine];
    
    //取消按钮
    UIButton *cancelBtn = [[UIButton alloc] initWithFrame:CGRectMake(0, CGRectGetMaxY(sepratorLine.frame), MAINSCREEN_WIDTH, 49)];
    [cancelBtn setTitle:@"取消" forState:UIControlStateNormal];
    [cancelBtn setTitleColor:[UIColor textColor6666] forState:UIControlStateNormal];
    cancelBtn.titleLabel.font = [UIFont systemFontOfSize:17.0];
    cancelBtn.backgroundColor = [UIColor whiteColor];
    [cancelBtn addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
    [cancelBtn addTarget:self action:@selector(btnClickHigh:) forControlEvents:UIControlEventTouchDown];
    [cancelBtn addTarget:self action:@selector(btnClickOutSide:) forControlEvents:UIControlEventTouchUpOutside];
    cancelBtn.tag = 1002;
    [btnView addSubview:cancelBtn];
    
    //[cancelBtn setBackgroundImage:[UIImage createImageWithColor:[UIColor redColor]] forState:UIControlStateHighlighted];
    
}

//menuView上的按钮的点击事件
- (void)btnClick:(UIButton *)sender {
    sender.backgroundColor = [UIColor whiteColor];
    
    NSInteger btnTag = sender.tag - 1000;
    
    if (btnTag == 1) {
        //确认删除
        if (self.deleteBlock) {
            self.deleteBlock();
        }
    }else if (btnTag == 2) {
        //取消
        [self hide];
    }
    
}

- (void)btnClickHigh:(UIButton *)sender {
    sender.backgroundColor = [UIColor lineSeparatorColorDCDC];
}

- (void)btnClickOutSide:(UIButton *)sender {
    sender.backgroundColor = [UIColor whiteColor];
}

//阴影view的单击事件
- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event {
    
    UITouch *touch = [touches anyObject];
    
    CGPoint point = [touch locationInView:self];
    
    if ([self.menuView.layer hitTest:point]) {
        return;
    }else if ([self.layer hitTest:point]) {
        [self hide];
    }
}

//显示
- (void)showWithCount:(NSInteger)count {
    
    //[self.deleteBtn setTitle:[NSString stringWithFormat:@"确定删除这%ld件宝贝",count] forState:UIControlStateNormal];
    
    //UIWindow *keyWindow = [UIApplication sharedApplication].keyWindow;
    UIWindow *keyWindow = [SystemManager getKeyWindow];
    [keyWindow addSubview:self];
    
    self.isShow = YES;
    
    [UIView animateWithDuration:0.25 animations:^{
        self.menuView.y -= (99+[DeviceAdaptation getBottomSafeAreaHeight]);
        self.backgroundColor = [[UIColor blackColor] colorWithAlphaComponent:0.2f];
    } completion:^(BOOL finished) {
        //self.btnView.alpha = 1.0;
    }];
}

//隐藏
- (void)hide {
    self.isShow = NO;
    //self.btnView.alpha = 0.0;
    
    [UIView animateWithDuration:0.25 animations:^{
        self.menuView.y += (99+[DeviceAdaptation getBottomSafeAreaHeight]);
        self.backgroundColor = [UIColor clearColor];
    } completion:^(BOOL finished) {
        [self removeFromSuperview];
    }];
}

@end
