//
//  QGNotificationVC.m
//  CreditWallet
//
//  Created by harry on 28/12/2017.
//  Copyright © 2017 QuantGroup. All rights reserved.
//

#import "QGNotificationVC.h"
#import "QGNotificationCell.h"
#import "QGRefreshNomalHeader.h"
#import "QGNoMessageDataView.h"
#import "QGMessageListModel.h"


static NSString * const kQGNotifactionCellIdentify = @"kQGNotificationCell";

@interface QGNotificationVC ()

@end

@implementation QGNotificationVC

- (void)dealloc{
    
}



- (void)viewDidLoad {
    [super viewDidLoad];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


- (void)addTableViewCellStyle{
    self.tableView.rowHeight = 90.f;
    [self.tableView registerClass:[QGNotificationCell class] forCellReuseIdentifier:kQGNotifactionCellIdentify];
}

- (MessageCenterListType)myType{
    return MessageCenterListTypeNotifyMsg;
}


- (void)loadData:(BOOL)needNew{
    
    //上一条消息id，只有上拉刷新时需要
    NSString * lastMsgId = nil;
    //下拉刷新
    if (needNew) {
        
    }
    //上拉刷新
    else
    {
        lastMsgId = [self.dataSource.lastObject infoId];
    }
    
    NSString * urlString = [QGUserCenterRequestApi urlWithUserCenterRequestServerMethod:QGUserCenterRequestServerMethodStationLetterList];
    NSMutableDictionary * infoDic = [NSMutableDictionary dictionaryWithCapacity:0];
    //站内信类型 0：通知  1：活动
    [infoDic setObject:@"0" forKey:@"msgType"];
    [infoDic setObject:@(10) forKey:@"pageSize"];
    
    //lastMsgId只有上拉加载时传
    if (![NSString isEmpty:lastMsgId]) {
        [infoDic setObject:lastMsgId forKey:@"lastMsgId"];
    }
    
    [[QGTalosNetwork shareManager] POST:urlString parameters:infoDic success:^(id  _Nonnull responseObject) {
        //业务请求成功
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            
            NSDictionary * dataDic = responseObject[@"data"];
            NSDictionary * pageInfoDic = dataDic[@"pageInfo"];
            
            //后台返回是否有更多页
            BOOL hasMore = [pageInfoDic[@"hasNext"] boolValue];
            
            NSArray *notifyMsgList = dataDic[@"notifyMsgList"];
            NSMutableArray *marr = [NSMutableArray arrayWithCapacity:0];
            for (NSDictionary *tempDict in notifyMsgList) {
                QGMessageListModel *model = [[QGMessageListModel alloc] initWithDic:tempDict];
                [marr addObject:model];
            } 
            
             [self updateList:marr needNew:needNew hasMore:hasMore failure:NO failureResponse:nil];
        }
        //业务请求失败
        else
        {
            [self updateList:nil needNew:needNew hasMore:NO failure:YES failureResponse:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [self updateList:nil needNew:needNew hasMore:NO failure:YES failureResponse:error];
    }];
    
    

}



#pragma mark- Prviate



#pragma mark- UITableViewDelegate

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    //cell
    QGNotificationCell *cell = [tableView dequeueReusableCellWithIdentifier:kQGNotifactionCellIdentify forIndexPath:indexPath];
    cell.selectedBackgroundView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, 90.f)];
    if (self.dataSource && self.dataSource.count > indexPath.row) {
        QGMessageListModel *model = self.dataSource[indexPath.row];
        cell.delegate = self;
        [cell updateModel:model];
    }
    return cell;
}




@end
