//
//  UserBaseCell.m
//  CreditWallet
//
//  Created by 逍遥子 on 16/11/2.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import "UserBaseCell.h"
#import "UIImageView+WebCache.h"
#import "QGBasicUITool.h"

@interface UserBaseCell ()
@property (strong,nonatomic) UIImageView *disclosureIndicator;
@end
@implementation UserBaseCell

- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier {
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        _lineView =[[UIView alloc]initWithFrame:CGRectMake(20, 59.5, MAINSCREEN_WIDTH-40, 0.5)];
        _lineView.backgroundColor =[UIColor lineSeparatorColorDCDC];
        [self addSubview:_lineView];
        
        _disclosureIndicator =[[UIImageView alloc]initWithFrame:CGRectMake(MAINSCREEN_WIDTH-30, (60-18)/2.0, 10, 18)];
        _disclosureIndicator.image =[UIImage imageNamed:@"last_right_arrow"];
        _disclosureIndicator.hidden =YES;
        [self addSubview:_disclosureIndicator];
        
    }
    
    return self;
}

- (void)setUserBaseModel:(UserBaseCellModel *)userBaseModel
{
    if (_userBaseModel != userBaseModel) {
        _userBaseModel = userBaseModel;
    }
    // 左侧标题
//    CGFloat width =[NSString getWidthWithContent:_userBaseModel.title height:self.frame.size.height font:[UIFont qg_regularFontOfSize:15.f]];
    
    CGFloat width = [NSString getWidthWithContent:_userBaseModel.title height:self.frame.size.height UIFont:[UIFont qg_lightFontOfSize:15.f]];
    self.titleLab.frame =CGRectMake(20, 0, width, self.frame.size.height);
    
    self.titleLab.text =_userBaseModel.title;
    self.contentLab.frame =CGRectMake(width +20, 0, MAINSCREEN_WIDTH -(width + 60), self.frame.size.height);
    // 显示提示文字
    self.contentLab.text =_userBaseModel.value;
    if (userBaseModel.valueTextColorHexString.length>0) {
        self.contentLab.textColor =[UIColor colorWithHexString:_userBaseModel.valueTextColorHexString];
    }
    // 左侧箭头
    if ([_userBaseModel.arrowIsHidden boolValue] != YES) {
        _disclosureIndicator.hidden =NO;
    }else{
        _disclosureIndicator.hidden =YES;
        self.contentLab.frame =CGRectMake(width +30, 0, MAINSCREEN_WIDTH -(width + 50), self.frame.size.height);

    }
    
   
    
    // 图片
    if (_userBaseModel.iconImageUrl.length>0) {
        [self.iconImageView sd_setImageWithURL:[NSURL URLWithString:_userBaseModel.iconImageUrl] completed:^(UIImage *image, NSError *error, SDImageCacheType cacheType, NSURL *imageURL) {
            if (image) {
                self.iconImageView .image =image;
            }
        }];
    }else
    {
        self.iconImageView .image =[UIImage imageNamed:@"avatar"];

    }
    
    // 默认为文字类型
    NSString *type =_userBaseModel.cellGraphicType;
     if ([type intValue]  == UserBaseCellTypeImage)
    {
        self.iconImageView.hidden =NO;
    }else {
        self.contentLab.hidden =NO;
    }
    
    if ([_userBaseModel.lineIsHidden boolValue] ==YES) {
        _lineView.hidden =YES;
    }else{
        _lineView.hidden =NO;

    }
    
}



// 懒加载 UI
- (UILabel *)titleLab
{
    if (!_titleLab) {
        _titleLab = [[UILabel alloc] initWithFrame:CGRectMake(20, 0, 100, self.frame.size.height)];
        _titleLab.autoresizingMask = UIViewAutoresizingFlexibleHeight;
        _titleLab.textColor = [UIColor textColor3333];
        _titleLab.textAlignment = NSTextAlignmentLeft;
        [_titleLab setFont:[UIFont qg_lightFontOfSize:15]];
        [self addSubview: _titleLab];
    }
    return _titleLab;
}
- (UILabel *)contentLab
{
    if (!_contentLab) {
        _contentLab = [[UILabel alloc] initWithFrame:CGRectMake(MAINSCREEN_WIDTH-140,  0, 150, self.frame.size.height)];
        _contentLab.autoresizingMask = UIViewAutoresizingFlexibleHeight;
        _contentLab.textColor = [UIColor textColor3333];
        _contentLab.textAlignment = NSTextAlignmentRight;
        
        [_contentLab setFont:[UIFont qg_lightFontOfSize:15.0]];
        _contentLab.hidden =YES;
        [self addSubview: _contentLab];
    }
    return  _contentLab;
}
- (UIImageView *)iconImageView
{
    if (!_iconImageView) {
        
        _iconImageView =[[UIImageView alloc]initWithFrame:CGRectMake(MAINSCREEN_WIDTH-64, (60-24)/2.0, 24, 24)];
        _iconImageView.layer.cornerRadius =12;
        _iconImageView.layer.masksToBounds =YES;
        _iconImageView.image =[UIImage imageNamed:@"avatar"];
        _iconImageView.hidden =YES;
        [self addSubview:_iconImageView];
        
    }
    return  _iconImageView;
}
- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];
    // Configure the view for the selected state
}


@end
