//
//  CWAboutUsViewController.m
//  CreditWallet
//
//  Created by SongWentong on 15/4/10.
//  Copyright (c) 2015年 QuantGroup. All rights reserved.
//

#import "CWAboutUsViewController.h"
#import "CWWebViewController.h"
#import "QGWindowManager.h"
#import "UserBaseCell.h"
#import "UserBaseCellModel.h"
@interface CWAboutUsViewController () <UITableViewDataSource, UITableViewDelegate> {
}
@property (strong, nonatomic) NSMutableArray *leftRowTitleArray; //左侧行标题

@end
@implementation CWAboutUsViewController

-(BOOL)checkParameters:(NSDictionary *)param
{
    return YES;
}

- (instancetype)initWithCoder:(NSCoder *)coder {
    self = [super initWithCoder:coder];
    if (self) {
        self.hidesBottomBarWhenPushed = YES;
    }
    return self;
}

- (void)dealloc {
    //安全处理
    if (_tableView) {
        self.tableView.delegate = nil;
        self.tableView.dataSource = nil;
    }
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.title = @"关于我们";
    [self custemLeftDefaultBarButtonItem];
    CGFloat navStatusHeight = [DeviceAdaptation getNavBarAndStatusBarHeight];
    _tableView = [[UITableView alloc] initWithFrame:CGRectMake(0, navStatusHeight, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT - navStatusHeight) style:UITableViewStyleGrouped];
    _tableView.backgroundColor = [UIColor clearColor];
    _tableView.delegate = self;
    _tableView.dataSource = self;
    [self.view addSubview:_tableView];

    self.view.backgroundColor = [UIColor whiteColor];

    UIView *headerView = [[NSBundle mainBundle] loadNibNamed:@"AboutIconView"
                                                       owner:self
                                                     options:nil]
                             .lastObject;
    headerView.backgroundColor = [UIColor whiteColor];
    headerView.frame = CGRectMake(0, 0, MAINSCREEN_WIDTH, 200);
    //xib创建的headerView容易出现问题，所以用一个中间view接过来
    UIView *myHeaderView = [[UIView alloc] initWithFrame:headerView.frame];
    [myHeaderView addSubview:headerView];

    self.tableView.tableHeaderView = myHeaderView;

    UIView *footerView = [[NSBundle mainBundle] loadNibNamed:@"CWAboutFooterView"
                                                       owner:self
                                                     options:nil]
                             .lastObject;
    footerView.backgroundColor = [UIColor whiteColor];
    //    CGFloat height = 150;
    footerView.frame = CGRectMake(0, 0, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT);
    //    UIView * myFooterView = [[UIView alloc]initWithFrame:footerView.frame];
    [self.view addSubview:footerView];
    [self.view sendSubviewToBack:footerView];

    UIButton *button = (UIButton *) [footerView viewWithTag:10];
    [button setTitleColor:[UIColor mainThemeColor] forState:UIControlStateNormal];
    self.tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    [self setupData];
}
- (void)setupData {
//    UserBaseCellModel *model1 = [[UserBaseCellModel alloc] initWithDic:@{@"title" : @"关注微信", @"value" : @"xinyongqianbao", @"arrowIsHidden" : @"1"}];
//    UserBaseCellModel *model2 = [[UserBaseCellModel alloc] initWithDic:@{@"title" : @"关注微博", @"value" : @"weibo.com/xinyongqianbao", @"arrowIsHidden" : @"1"}];
    UserBaseCellModel *model3 = [[UserBaseCellModel alloc] initWithDic:@{@"title" : @"欢迎页"}];
    UserBaseCellModel *model4 = [[UserBaseCellModel alloc] initWithDic:@{@"title" : @"法律协议"}];

//    self.leftRowTitleArray = [NSMutableArray arrayWithArray:@[ model1, model2, model3, model4 ]];
    self.leftRowTitleArray = [NSMutableArray arrayWithArray:@[model3, model4 ]];

}
- (void)userProtocol {

//    [self navigationToWeb:@"http://pages.xyqb.com/fa-lv-xie-yi/"];
    [self navigationToWeb:@"http://pages.xyqb.com/zhen-xiang-sheng-huo-fa-lu-xie-yi/"];
}

#pragma mark - UITableViewDataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.leftRowTitleArray.count;
}

// Row display. Implementers should *always* try to reuse cells by setting each cell's reuseIdentifier and querying for available reusable cells with dequeueReusableCellWithIdentifier:
// Cell gets various attributes set automatically based on table (separators) and data source (accessory views, editing controls)

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {

    UserBaseCell *cell = (UserBaseCell *) [self getCellFromClassName:@"UserBaseCell" dequeueTableView:self.tableView];
    UserBaseCellModel *model = self.leftRowTitleArray[indexPath.row];
    cell.userBaseModel = model;

    return cell;
}

#pragma mark - UITableViewDelegate
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    CGFloat height = 60;

    return height;
}

//- (void)tableView:(UITableView *)tableView willDisplayCell:(UITableViewCell *)cell forRowAtIndexPath:(NSIndexPath *)indexPath
//{
//    cell.textLabel.textColor = [UIColor colorWithHexString:@"3"];
//    cell.textLabel.font = [UIFont systemFontOfSize:15];
//}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    switch (indexPath.row) {

//        case 0: {
//            //关注微信
//            [QGAlertViewSystem initWithTitle:@"提示"
//                                     message:@"已复制公众号，打开微信－右上角“+”－添加朋友－公众号－粘贴“信用钱包”公众号－关注"
//                           cancleButtonTitle:@"取消"
//                           OtherButtonsArray:@[ @"去关注" ]
//                                clickAtIndex:^(NSInteger buttonIndex) {
//                                    if (buttonIndex == 1) {
//                                        UIPasteboard *pasteboard = [UIPasteboard generalPasteboard];
//                                        pasteboard.string = @"xinyongqianbao";
//
//                                        NSURL *wechat_url = [NSURL URLWithString:@"weixin://qr/QeD64j-EGGJnrXuB97VT"];
//                                        if ([[UIApplication sharedApplication] canOpenURL:wechat_url]) {
//                                            [[UIApplication sharedApplication] openURL:wechat_url];
//                                        } else {
//                                            [QGHUDManager showHud:@"复制成功"];
//                                        }
//                                    }
//                                }
//                                  parentObjc:self];
//        } break;
//
//        case 1: {
//            NSURL *url = [[NSURL alloc] initWithString:@"http://weibo.com/xinyongqianbao"];
//            if ([[UIApplication sharedApplication] canOpenURL:url]) {
//                [[UIApplication sharedApplication] openURL:url];
//            }
//        } break;
        case 0: {

            [[QGWindowManager shareInstance] showLaunchGuide];

        } break;

        case 1: {
            [self userProtocol];
        } break;
        default:
            break;
    }
}

@end
