//
//  QGNewUserCenterViewController.m
//  VirtualPayment
//
//  Created by 张博 on 2019/12/11.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGNewUserCenterViewController.h"

//View
#import "QGUserCenterHeaderCell.h"
#import "QGUserCenterMenuCell.h"

//Tool
#import "QGUserCenterRequestApi.h"
#import "QGActivityPopManager.h"

//Model
#import "QGUserCenterDataModel.h"
@interface QGNewUserCenterViewController ()

///消息
@property (nonatomic, strong) UIButton * messageButton;

/// 数据源
@property (nonatomic, strong) QGUserCenterDataModel * dataModel;
@end

@implementation QGNewUserCenterViewController


- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self initNormalUI];
    
//    [QGActivityPopManager.shareInstance showActivitiesAtPosition:QGActivityPositionMine inController:self];
}

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    [QGActivityPopManager.shareInstance viewDidAppearAtPosition:QGActivityPositionMine inController:self];
    //每次进入需要重新请求
    [self requestData];
}


- (void)initNormalUI
{
    self.title = @"我的";
    [self setNavBarBottomLineHidden:YES];
    self.isBelowNavBar = NO;
    self.isAboveTabBar = YES;
    @weakify(self);

    self.messageButton = [self custemRightBarButtonItemWithTitle:nil imageName:@"message_right_barbutton" action:^(UIButton * _Nonnull button) {
        @strongify(self);
        [self messageButtonClick];
    }];
}

#pragma mark - Request
///网络请求
- (void)requestData
{
    QGBatchOperationManager * manager = [[QGBatchOperationManager alloc]initWithSerial:NO];
    @weakify(self);
    //首页接口请求
    NSString *url = [QGUserCenterRequestApi urlWithUserCenterRequestServerMethod:QGUserCenterRequestServerMethodConfigMine];
    [manager GET:url networkClassName:NSStringFromClass([QGTalosNetwork class]) parameters:nil success:^(id  _Nonnull responseObject) {
        @strongify(self);
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            self.dataModel = [QGUserCenterDataModel yy_modelWithJSON:responseObject[@"data"]];
            [QGUserInfo sharedUserInfo].realName = self.dataModel.userInfo.name;
            [QGUserInfo sharedUserInfo].avatar = self.dataModel.userInfo.headImage;
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }

    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
    }];
    
    
    if ([QGUserInfo sharedUserInfo].isLogin) {
        //请求未读消息数
        NSString *unreadUrl = [QGUserCenterRequestApi urlWithUserCenterRequestServerMethod:QGUserCenterRequestServerMethodUnread];
        NSMutableDictionary *noticesParame = [[NSMutableDictionary alloc] initWithCapacity:1];
        [noticesParame setObject:@"all" forKey:@"msgType"];
        [manager GET:unreadUrl networkClassName:NSStringFromClass([QGTalosNetwork class]) parameters:noticesParame success:^(id  _Nonnull responseObject) {
            @strongify(self);
            if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
                [QGUserInfo sharedUserInfo].unreadNumber = [responseObject valueForKeyPath:@"data.notifyMsgCount"];
                if ([QGUserInfo sharedUserInfo].unreadNumber.integerValue > 0) {
                    [self.messageButton setImage:[UIImage imageNamed:@"message_right_barbutton_hint"] forState:UIControlStateNormal];
                }else{
                    [self.messageButton setImage:[UIImage imageNamed:@"message_right_barbutton"] forState:UIControlStateNormal];
                }
            }
        } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
            
        }];
    }
    //未登录去掉提示信息
    else
    {
        [self.messageButton setImage:[UIImage imageNamed:@"message_right_barbutton"] forState:UIControlStateNormal];
    }
    
    
    
    manager.allOperationCompleteBlock = ^(BOOL allSuccess) {
        @strongify(self);
        [self.tableView reloadData];
    };
}

#pragma mark - UITableVeiwDataSource
-(NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    //头像区域 + 菜单项
    return self.dataModel ? 2 : 0;
}

-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    switch (section) {
            //头像区域
        case 0:
            return 1;
            break;
            //菜单项
        case 1:
            return self.dataModel.menus.count;
            break;
            
        default:
            break;
    }
    return 0;
}

-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    @weakify(self);
    switch (indexPath.section) {
            //头像区域
        case 0:
        {
            QGUserCenterHeaderCell * headerCell = (QGUserCenterHeaderCell *)[self getCellFromClassName:NSStringFromClass([QGUserCenterHeaderCell class]) dequeueTableView:tableView];
            headerCell.userCenterModel = self.dataModel;
            //登录按钮
            [headerCell.longinBtn touchUpInsideBlock:^(UIButton * _Nonnull button) {
                @strongify(self);
                [self showLoginViewController];
            }];
            return headerCell;
        }
            break;
            //菜单项
        case 1:
        {
            QGUserCenterMenuCell * menuCell = (QGUserCenterMenuCell *)[self getCellFromClassName:NSStringFromClass([QGUserCenterMenuCell class]) dequeueTableView:tableView];
            menuCell.menuModel = self.dataModel.menus[indexPath.row];
            return menuCell;
        }
            break;
            
        default:
            break;
    }
    return [UITableViewCell new];
}

#pragma mark - UITableViewDelegate
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    //菜单项
    if (indexPath.section == 1) {
        if (![QGUserInfo isLogin]) {
            @weakify(self);
            [self showLoginViewControllerCompletion:^{
                @strongify(self);
                [self tableView:tableView didSelectRowAtIndexPath:indexPath];
            }];
            return;
        }
        QGUserCenterMenuModel * menuModel = self.dataModel.menus[indexPath.row];
        [self navigationToAllSupportUrl:menuModel.jumpUrl];
    }
}

-(CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
     //头像区域
    if (indexPath.section == 0) {
        return 89;
    }
    //菜单项
    else{
        return 61;
    }
}

-(CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    if (section == 0) {
        return 10;
    }
    return CGFLOAT_MIN;
}

-(UIView *)tableView:(UITableView *)tableView viewForFooterInSection:(NSInteger)section
{
    UIView *footer = [[UIView alloc] init];
    footer.backgroundColor = [UIColor moduleSeparatorColorF7F7];
    return footer;
}



#pragma mark - Action
/// 消息按钮点击事件
- (void)messageButtonClick
{
    if ([QGUserInfo sharedUserInfo].login) {//去到消息中心
        [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGMessageCenterVC] parameters:nil handlerBlock:nil];
    }else{
        [self showLoginViewControllerCompletion:nil];
    }
}


#pragma mark - Notification

@end
