//
//  QGUserCenterMenuCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/12/12.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGUserCenterMenuCell.h"
#import "QGBasicUITool.h"
#import "UIImageView+QGWebCache.h"

@interface QGUserCenterMenuCell ()

/// icon图片
@property (nonatomic, strong)UIImageView *iconImageView;

/// 标题
@property (nonatomic, strong)UILabel *titleLabel;
@end


@implementation QGUserCenterMenuCell

-(instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        //箭头
        [self.arrowImage setImage:[UIImage imageNamed:@"cell_right_arrow"]];
        
        
        //图片
        self.iconImageView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:nil];
        [self.iconImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.leftMargin.mas_equalTo(20);
            make.centerY.mas_equalTo(self.contentView.mas_centerY);
            make.width.height.mas_equalTo(25);
        }];
        
        //标题
        self.titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_lightFontOfSize:16] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.iconImageView.mas_right).offset(10);
            make.height.mas_equalTo(22);
            make.right.equalTo(self.contentView).offset(100);
            make.centerY.mas_equalTo(self.contentView.mas_centerY);

        }];
        
        self.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    
    return self;
}

- (void)setMenuModel:(QGUserCenterMenuModel *)menuModel
{
    if (_menuModel != menuModel) {
        _menuModel = menuModel;
        [self.iconImageView setImageWithPlaceholder:@"usercenter_menu_placeholder" URLString:_menuModel.icon];
        self.titleLabel.text = _menuModel.desc;
    }
}

@end
