//
//  QGMineModel.h
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/25.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGBaseModel.h"
@class QGMineModel;

typedef void (^ItemClickBlock)(QGMineModel*model);

@interface QGMineModel : QGBaseModel
///显示的图标name
@property NSString *imageName;
///显示的标题
@property NSString *title;
///显示的右侧副标题
@property NSString *subtitle;
///是否显示分隔线 首页默认Yes隐藏 (二级页面默认No不隐藏)
@property BOOL hideSeparateLine;

@property (nonatomic,strong)ItemClickBlock itemClickBlock;
///我的首页模型初始化方法
-(instancetype)initImageName:(NSString*)imageName title:(NSString *)title clickAction:(ItemClickBlock) clickBlock;

///我的二级页面模型初始化方法
-(instancetype)initWithTitle:(NSString *)title subtitle:(NSString *)subtitle clickAction:(ItemClickBlock) clickBlock;


@end
