//
//  QGPrivacySetViewController.m
//  VirtualPayment
//
//  Created by 张博 on 2020/1/19.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGPrivacySetViewController.h"
#import "QGMineModel.h"
#import "QGMineCommonTitleTableViewCell.h"

@interface QGPrivacySetViewController ()

/// 数据源
@property (nonatomic, strong) NSMutableArray * dataArray;

@end

@implementation QGPrivacySetViewController

- (BOOL)checkParameters:(NSDictionary *)param
{
    return YES;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    [self initNormalUI];
}


- (void)initNormalUI
{
    self.title = @"隐私设置";
    [self custemLeftDefaultBarButtonItem];
    
    //数据源
    self.dataArray = [NSMutableArray arrayWithCapacity:0];
    
    //隐私政策
    @weakify(self);
    QGMineModel * privacyAgreement = [[QGMineModel alloc]initWithTitle:@"真享生活隐私政策" subtitle:nil clickAction:^(QGMineModel *model) {
        @strongify(self);
        [self navigationToWeb:VCCPrivacyAgreement];
    }];
    [self.dataArray addObject:privacyAgreement];
    
    //授权管理
    QGMineModel * authManager = [[QGMineModel alloc]initWithTitle:@"授权管理" subtitle:nil clickAction:^(QGMineModel *model) {
        [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGPermissionViewController) parameters:nil handlerBlock:nil];
    }];
    [self.dataArray addObject:authManager];
    
    //用户更正删除信息
    QGMineModel * userDeleteInfo = [[QGMineModel alloc]initWithTitle:@"用户更正删除信息" subtitle:nil clickAction:^(QGMineModel *model) {
        @strongify(self);
        [self navigationToWeb:ModifyDeleteMessage];
    }];
    [self.dataArray addObject:userDeleteInfo];
}

#pragma mark - UITableViewDataSource
-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.dataArray.count;
}

-(CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 61;
}

-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    
    QGMineCommonTitleTableViewCell *cell = (QGMineCommonTitleTableViewCell *)[self getCellFromClassName:NSStringFromClass([QGMineCommonTitleTableViewCell class]) dequeueTableView:tableView];
    cell.model = self.dataArray[indexPath.row];
    return cell;
}

-(void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    QGMineModel *model = self.dataArray[indexPath.row];
    if (model.itemClickBlock) {
        model.itemClickBlock(model);
    }
}


/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
