//
//  QGMineSetCenterViewController.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/26.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGMineSetCenterViewController.h"
#import "QGMineCommonTitleTableViewCell.h"
#import "QGBasicUITool.h"
#import "QGMineModel.h"
#import "SDImageCache.h"
#import "QGAlertView.h"


@interface QGMineSetCenterViewController ()
@property (nonatomic, strong)NSMutableArray *dataArray;

///卡列表
//@property (nonatomic, copy)NSString *cardUrl;

@end

@implementation QGMineSetCenterViewController
-(BOOL)checkParameters:(NSDictionary *)param
{
    return YES;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"设置";
    [self setIsBelowNavBar:NO];
    [self setNavBarBottomLineHidden:YES];
    [self custemLeftDefaultBarButtonItem];
    
    [self.tableView registerClass:[QGMineCommonTitleTableViewCell class] forCellReuseIdentifier:NSStringFromClass([QGMineCommonTitleTableViewCell class])];
    [self createDataArray];
    
    self.tableView.backgroundColor = [UIColor moduleSeparatorColorF7F7];
}

-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.dataArray.count;
}

-(CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 61;
}

-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    
    QGMineCommonTitleTableViewCell *cell = (QGMineCommonTitleTableViewCell *)[self getCellFromClassName:NSStringFromClass([QGMineCommonTitleTableViewCell class]) dequeueTableView:tableView];
    cell.model = self.dataArray[indexPath.row];
    if (indexPath.row == self.dataArray.count-1) {
        cell.arrowHide = YES;
        cell.titleLabel.textColor = [UIColor textColorF41C1C];
    }
    return cell;
}

-(void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    QGMineModel *model = self.dataArray[indexPath.row];
    if (model.itemClickBlock) {
        model.itemClickBlock(model);
    }
}

//创建模型数组准备数据
-(void)createDataArray
{
    
    //安全中心
    QGMineModel *safeCenter = [[QGMineModel alloc]initWithTitle:@"安全中心" subtitle:nil clickAction:^(QGMineModel *model) {

        [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGSafeCenterViewController] parameters:nil handlerBlock:nil];
        
    }];
    [self.dataArray addObject:safeCenter];
    
    
    //隐私设置
    QGMineModel * privacySet = [[QGMineModel alloc]initWithTitle:@"隐私设置" subtitle:nil clickAction:^(QGMineModel *model) {
        [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGPrivacySetViewController) parameters:nil handlerBlock:nil];
    }];
    [self.dataArray addObject:privacySet];
    
    //清除缓存
    QGMineModel *chuckCache = [[QGMineModel alloc] initWithTitle:@"清除缓存" subtitle:@"" clickAction:^(QGMineModel *model) {
        [QGHUDManager showHud:nil];
        [[SDImageCache sharedImageCache] clearDiskOnCompletion:^{
            [QGHUDManager hideHud];
            model.subtitle = @"0M";
            [self.tableView reloadData];
        }];
    }];
    
    NSOperationQueue *queue = [[NSOperationQueue alloc] init];
    [queue addOperationWithBlock:^{
        SDImageCache *cache = [SDImageCache sharedImageCache];
        //获取缓存大小
        NSUInteger cacheSize = [cache totalDiskSize];
        [[NSOperationQueue mainQueue] addOperationWithBlock:^{
            chuckCache.subtitle = [NSString stringWithFormat:@"%.2fM",cacheSize/1000.0/1000];
            
            [self.tableView reloadData];
        }];
    }];
    
    [self.dataArray addObject:chuckCache];

    //关于我们
    QGMineModel *aboutOur = [[QGMineModel alloc] initWithTitle:@"关于我们" subtitle:nil clickAction:^(QGMineModel *model) {
        
        [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeCWAboutUsViewController] parameters:nil handlerBlock:nil];
        
    }];
    [self.dataArray addObject:aboutOur];

    //退出当前账号
    QGMineModel *tempModel = [[QGMineModel alloc] initWithTitle:@"退出当前账号" subtitle:nil clickAction:^(QGMineModel *model) {
        
        //密码设置成功
        QGAlertView *alert = [[QGAlertView alloc] initWithTitle:@"离开" message:@"是否确认退出真享生活" cancelButtonTitle:@"取消" sureButtonTitle:@"确定" clickBlock:^(NSInteger index) {
            if (index == 1) {
                [QGUserInfo logOut];
                [self.navigationController popViewControllerAnimated:YES];            }
        }];
        [alert showInView:self.view];
        

    }];
    tempModel.hideSeparateLine = YES;
    [self.dataArray addObject:tempModel];
}


-(NSMutableArray *)dataArray
{
    if (!_dataArray) {
        _dataArray = [[NSMutableArray alloc]init];
    }
    return _dataArray;
}



@end
