//
//  QGMinePersonalDataViewController.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/27.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGMinePersonalDataViewController.h"
#import "QGMineCommonTitleTableViewCell.h"
#import "UIImageView+WebCache.h"
#import <AVFoundation/AVFoundation.h>
#import "QGActionSheetView.h"
#import "QiniuService.h"
#import "QGUserCenterRequestApi.h"
#import "QGPersonalMenuModel.h"

@interface QGMinePersonalDataViewController ()<UIImagePickerControllerDelegate,UINavigationControllerDelegate>

@property (nonatomic, strong)UIImage *iconImage;
/// 菜单项数组
@property (nonatomic, strong) NSArray * menuArray;
@end

@implementation QGMinePersonalDataViewController
-(BOOL)checkParameters:(NSDictionary *)param
{
    return YES;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.title = @"我的资料";
    [self custemLeftDefaultBarButtonItem];
    [self setNavBarBottomLineHidden:YES];
    self.tableView.backgroundColor = [UIColor moduleSeparatorColorF7F7];
    [self requestMenuData];
}


/// 请求个人资料相关配置菜单信息
- (void)requestMenuData
{
    NSString * urlString = [QGUserCenterRequestApi urlWithUserCenterRequestServerMethod:QGUserCenterRequestServerMethodPersonalMenu];
    [QGHUDManager showHud:nil];
    [[QGTalosNetwork shareManager] GET:urlString parameters:nil success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            self.menuArray = [NSArray yy_modelArrayWithClass:[QGPersonalMenuModel class] json:responseObject[@"data"][@"subMenuList"]];
            [self.tableView reloadData];
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
    }];
}



//- (void)jumpBankCardUrlPage
//{
//    if (![NSString isEmpty:self.cardUrl]) {
//        //银行卡管理
//        if ([self.cardUrl isEqualToString:@"about:blank"]) {
//            [QGHUDManager showHud:@"请您先激活享花卡"];
//        } else {
//            [self navigationToWeb:self.cardUrl];
//        }
//        return;
//    }
//
//    NSString * urlString = [QGUserCenterRequestApi urlWithUserCenterRequestServerMethod:QGUserCenterRequestServerMethodBankCardUrl];
//    @weakify(self);
//    [QGHUDManager showHud:nil];
//    [[QGTalosNetwork shareManager] GET:urlString parameters:nil success:^(id  _Nonnull responseObject) {
//        [QGHUDManager hideHud];
//        @strongify(self);
//        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
//            NSString * cardUrl = responseObject[@"data"][@"bankCardListUrl"];
//            if (![NSString isEmpty:cardUrl]) {
//                self.cardUrl = cardUrl;
//                [self jumpBankCardUrlPage];
//            }
//        }
//        else
//        {
//            [QGHUDManager showHudWithError:responseObject];
//        }
//    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
//        NSString * errorMsg = [QGBaseNetwork getMessageWithFailureError:error];
//        [QGHUDManager showHud:errorMsg];
//    }];
//}



-(NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 2;
}

-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    NSInteger numberOfRows = 0;
    switch (section) {
            //头像
        case 0:
            numberOfRows = 1;
            break;
            //后台返回菜单项
        case 1:
            numberOfRows = self.menuArray.count;
        break;
            
        default:
            break;
    }
    return numberOfRows;
}

-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    //头像
    if (indexPath.section == 0) {
        
        QGMineCommonTitleTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"cell1"];
        if (!cell) {
            cell = [[QGMineCommonTitleTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"cell1"];
        }
        
        //个人资料cell与其他页面共用，所以需单独设置属性
        cell.separateLineHide = YES;
        cell.arrowImage.clipsToBounds = YES;
        cell.arrowImage.layer.cornerRadius = 14.f;
        [cell.arrowImage mas_updateConstraints:^(MASConstraintMaker *make) {
            make.width.height.mas_equalTo(28);
        }];
        cell.arrowImage.contentMode = UIViewContentModeScaleAspectFill;
        cell.titleLabel.text = @"头像";
        if (self.iconImage) {
            cell.arrowImage.image = self.iconImage;
        }else{
            
            [cell.arrowImage sd_setImageWithURL:[NSURL URLWithString:[QGUserInfo sharedUserInfo].avatar] placeholderImage:[UIImage imageNamed:@"headsculpture_image_28"] options:SDWebImageRetryFailed];
        }
        
        return cell;
    }
    //菜单项
    else{
        QGMineCommonTitleTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"cell2"];
        if (!cell) {
            cell = [[QGMineCommonTitleTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"cell2"];
        }
        QGPersonalMenuModel * menuModel = self.menuArray[indexPath.row];
        //个人资料cell与其他页面共用，所以需单独设置属性
        cell.separateLineHide = self.menuArray.lastObject == menuModel ? YES : NO;
        cell.titleLabel.text = menuModel.name;
        return cell;
    }

}

-(CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 65;
}

-(CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 0.1;
}
-(CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return 10;
}
-(UIView *)tableView:(UITableView *)tableView viewForFooterInSection:(NSInteger)section
{
    UIView *view = [UIView creatViewWithSuperView:nil backgroundColor:[UIColor moduleSeparatorColorF7F7]];
    
    return view;
}

-(void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.section == 0) {
        QGActionSheetView *actionSheet = [[QGActionSheetView alloc] initWithTitle:nil options:@[@[@"拍照",@"相册"],@[@"取消"]] clickBlock:^(NSInteger index) {
            if (1 == index) {
                // 开始拍照
                [self takePhoto];
            } else if (2 == index) {
                //打开本地相册
                [self localPhoto];
            }
        }];

        [actionSheet showInView:self.view];
    }else{
        QGPersonalMenuModel * menuModel = self.menuArray[indexPath.row];
        [self navigationToWeb:menuModel.jumperUrl];
    }
}

#pragma mark --imagePicker
// 开始拍照
- (void)takePhoto {
    if ([UIImagePickerController isSourceTypeAvailable:UIImagePickerControllerSourceTypeCamera]) {
        UIImagePickerController *picker = [[UIImagePickerController alloc] init];
        picker.sourceType = UIImagePickerControllerSourceTypeCamera;
        picker.delegate = self;
        //设置拍照后的图片可被编辑
        picker.allowsEditing = YES;
        picker.sourceType = UIImagePickerControllerSourceTypeCamera;
        //先检查相机可用是否
        BOOL cameraIsAvailable = [self checkCamera];
        if (YES == cameraIsAvailable) {
            [self presentViewController:picker animated:YES completion:nil];
        } else {
            UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"请在iPhone的“设置-隐私-相机”选项中，允许本应用程序访问你的相机。" delegate:self cancelButtonTitle:@"好，我知道了" otherButtonTitles:nil];
            [alert show];
        }
    }
}

// 打开本地相册
- (void)localPhoto {
    //本地相册不需要检查，因为UIImagePickerController会自动检查并提醒
    UIImagePickerController *picker = [[UIImagePickerController alloc] init];
    picker.sourceType = UIImagePickerControllerSourceTypePhotoLibrary;
    picker.delegate = self;
    //设置选择后的图片可被编辑
    picker.allowsEditing = YES;
    [self presentViewController:picker animated:YES completion:nil];
}

//检查相机是否可用
- (BOOL)checkCamera {
    NSString *mediaType = AVMediaTypeVideo;
    AVAuthorizationStatus authStatus = [AVCaptureDevice authorizationStatusForMediaType:mediaType];
    if (AVAuthorizationStatusRestricted == authStatus ||
        AVAuthorizationStatusDenied == authStatus) {
        //相机不可用
        return NO;
    }
    //相机可用
    return YES;
}
//压缩图片质量
- (UIImage *)reduceImage:(UIImage *)image percent:(float)percent {
    NSData *imageData = UIImageJPEGRepresentation(image, percent);
    UIImage *newImage = [UIImage imageWithData:imageData];
    return newImage;
}
//压缩图片尺寸
- (UIImage *)imageWithImageSimple:(UIImage *)image scaledToSize:(CGSize)newSize {
    UIGraphicsBeginImageContext(newSize);
    [image drawInRect:CGRectMake(0, 0, newSize.width, newSize.height)];
    UIImage *newImage = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    return newImage;
}

//开始上传图片第一步获取七牛上传的token和key
- (void)avatarUploadImage:(UIImage *)image {
    
    NSString *url = [QGUserCenterRequestApi urlWithUserCenterRequestServerMethod:QGUserCenterRequestServerMethodPersonalUpload];
    
    [QGHUDManager showHud:nil];
    NSMutableDictionary *params = [[NSMutableDictionary alloc] init];
    [params setValue:@"avatar" forKey:@"businessFlag"];
    
    
    [[QGTalosNetwork shareManager] GET:url parameters:params success:^(id  _Nonnull responseObject) {
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary *dic = (NSDictionary *) responseObject;
            self.iconImage = image;
            NSData *imageData = UIImageJPEGRepresentation(image, 0.2);
            [self qiniuServicePutData:dic[@"data"] imageData:imageData];
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
    }];
    
}

///上传图片到云存储
-(void)qiniuServicePutData:(NSDictionary *)data imageData:(NSData *)imageData{
    [[QiniuService shareInstance] putData:imageData
                                    token:[data valueForKey:@"uploadToken"]
                                      key:[data valueForKey:@"key"]
                                   params:nil
                                 complete:^(QNResponseInfo *info, NSString *key, NSDictionary *resp) {
                                     if (resp) {
                                         
                                         NSLog(@"resp______%@",resp);
                                         
                                         
                                         [self saveAvatarImageUrl: [data valueForKey:@"fileUrl"]];
                                     }
                                 }
                          progressHandler:^(NSString *key, float percent){
                              
                          }];
    
    
}
//将上传图片的URL发送给服务器保存
- (void)saveAvatarImageUrl:(NSString *)url {

    NSString *saveUrl = [QGUserCenterRequestApi urlWithUserCenterRequestServerMethod:QGUserCenterRequestServerMethodPersonalSave];
    NSMutableDictionary *params = [[NSMutableDictionary alloc] init];
    [params setValue:url forKey:@"avatarUrl"];
    [params setValue:[QGUserInfo sharedUserInfo].userName forKey:@"phoneNo"];
    [[QGTalosNetwork shareManager] POST:saveUrl parameters:params success:^(id  _Nonnull responseObject) {
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            [QGHUDManager showHud:@"头像上传成功"];
            [QGUserInfo sharedUserInfo].avatar = url;
            [self.tableView reloadData];
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
        
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
    }];
}

#pragma mark UIImagePickerControllerDelegate Call Back Implementation

- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary *)info {
    NSString *type = [info objectForKey:UIImagePickerControllerMediaType];
    
    //当选择的类型是图片
    if ([type isEqualToString:@"public.image"]) {
        NSString *key = nil;
        
        if (picker.allowsEditing) {
            key = UIImagePickerControllerEditedImage;
        } else {
            key = UIImagePickerControllerOriginalImage;
        }
        //获取图片
        UIImage *image = [info objectForKey:key];
        
        if (picker.sourceType == UIImagePickerControllerSourceTypeCamera) {
            //压缩图片质量
            image = [self reduceImage:image percent:0.1];
            CGSize imageSize = image.size;
            imageSize.height = 320;
            imageSize.width = 320;
            //压缩图片尺寸
            image = [self imageWithImageSimple:image scaledToSize:imageSize];
        }

        //关闭相册界面
        [picker dismissViewControllerAnimated:YES
                                   completion:^{
                                       [self avatarUploadImage:image];
                                       
                                   }];
    }
}


-(void)dealloc
{
    //返回时刷新上一级页面
    if (self.callBackBlock) {
        self.callBackBlock(nil, nil);
    }
}


@end
