//
//  QGHelpCenterViewController.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/27.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGHelpCenterViewController.h"
#import "QGHelpCenterNoticesCell.h"
#import "QGMineCommonTitleTableViewCell.h"
#import "QGHelpCenterSelfServiceCell.h"

#import "QGHelpCenterModel.h"
#import "QGHelpCenterNoticeModel.h"
#import "QGUserCenterRequestApi.h"
#import "SystemManager.h"
@interface QGHelpCenterViewController ()
//跑马灯消息数组
@property (nonatomic, strong)NSArray *noticesArray;
///帮助中心全局模型
@property (nonatomic, strong)QGHelpCenterModel *helpCenterModel;

///提额URL（可为空）
@property (nonatomic, copy)NSString *increaseUrl;
@end

@implementation QGHelpCenterViewController
-(BOOL)checkParameters:(NSDictionary *)param
{
    return YES;
}
-(void)transferParameters:(NSDictionary *)param
{
    self.increaseUrl = [param objectForKey:@"increaseUrl"];
}
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.title = @"帮助中心";
    [self setNavBarBottomLineHidden:YES];
    [self custemLeftDefaultBarButtonItem];
    
    self.tableView.backgroundColor = [UIColor moduleSeparatorColorF7F7];
    //让出底部按钮的高度
    self.tableView.contentInset = UIEdgeInsetsMake(0, 0, 70, 0);
    //请求 通知消息 和 热门问题（客服网址，客服电话）
    [self requestData];
    //创建底部的按钮
    [self createBottomView];
}


#pragma mark request
///网络请求
- (void)requestData
{
    QGBatchOperationManager * manager = [[QGBatchOperationManager alloc]initWithSerial:NO];
    //通知消息URL
    NSString *noticeUrl = [QGUserCenterRequestApi urlWithUserCenterRequestServerMethod:QGUserCenterRequestServerMethodStationLetterList];
    NSMutableDictionary * infoDic = [NSMutableDictionary dictionaryWithCapacity:0];
    //站内信类型 0：通知  1：活动
    [infoDic setObject:@"0" forKey:@"msgType"];
    [infoDic setObject:@(10) forKey:@"pageSize"];
    [infoDic setObject:@(1) forKey:@"pageNo"];
    @weakify(self);
    [manager POST:noticeUrl networkClassName:NSStringFromClass([QGTalosNetwork class]) parameters:infoDic success:^(id  _Nonnull responseObject)
    {
        @strongify(self);
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary * dataDic = responseObject[@"data"];
            NSArray *notifyMsgList = dataDic[@"notifyMsgList"];
            self.noticesArray = [NSArray yy_modelArrayWithClass:[QGHelpCenterNoticeModel class] json:notifyMsgList];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {

    }];
    
    //热门问题
    [QGHUDManager showHud:nil];
    //热门问题URL
    NSString *hotUrl = [QGUserCenterRequestApi urlWithUserCenterRequestServerMethod:QGUserCenterRequestServerMethodHelpCenterHot];
    [manager GET:hotUrl networkClassName:NSStringFromClass([QGTalosNetwork class]) parameters:nil success:^(id  _Nonnull responseObject) {
        @strongify(self);
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            self.helpCenterModel = [QGHelpCenterModel yy_modelWithDictionary:responseObject[@"data"]];
            self.helpCenterModel.customerService = VCCServiceUrl;
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {

    }];
    
    manager.allOperationCompleteBlock = ^(BOOL allSuccess) {
        @strongify(self);
        
        if (allSuccess) {
            [QGHUDManager hideHud];
            [self.tableView reloadData];
        }else{
            [QGHUDManager hideHud];
        }
    };
    
}

#pragma mark customMethod

-(void)createBottomView
{
    
    //底层view
    UIView *bottomView = [UIView creatViewWithSuperView:self.view backgroundColor:[UIColor whiteColor]];
    [bottomView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.left.equalTo(self.view);
        make.bottom.equalTo(self.view);
        make.height.mas_equalTo(70);
    }];
    
    
    //带边框的中心view
    UIView *centerView = [UIView creatViewWithSuperView:bottomView backgroundColor:[UIColor whiteColor]];
    centerView.layer.cornerRadius = 20;
    centerView.layer.borderColor = [UIColor mainThemeColor].CGColor;
    centerView.layer.borderWidth = 0.5;
    
    [centerView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.equalTo(bottomView).inset(20);
        make.height.mas_equalTo(40);
        make.centerY.equalTo(bottomView);
    }];
    
    //在线客服
    UIButton  *online = [UIButton creatButtonWithSuperView:centerView title:@"在线客服" titleFont:[UIFont qg_regularFontOfSize:16] textColor:[UIColor mainThemeColor]];
    [online addTarget:self action:@selector(bottonBtnClick:) forControlEvents:UIControlEventTouchUpInside];
//    //来电咨询
//    UIButton  *consult = [UIButton creatButtonWithSuperView:centerView title:@"来电咨询" titleFont:[UIFont qg_regularFontOfSize:16] textColor:[UIColor mainThemeColor]];
//    [consult addTarget:self action:@selector(bottonBtnClick:) forControlEvents:UIControlEventTouchUpInside];

    //意见反馈
    UIButton  *feedback = [UIButton creatButtonWithSuperView:centerView title:@"意见反馈" titleFont:[UIFont qg_regularFontOfSize:16] textColor:[UIColor mainThemeColor]];
    [feedback addTarget:self action:@selector(bottonBtnClick:) forControlEvents:UIControlEventTouchUpInside];

    //按钮的宽度
//    CGFloat btnWidth = (MAINSCREEN_WIDTH - 40 - 50-32)/3.0;
    CGFloat btnWidth = (MAINSCREEN_WIDTH - 40 )/2.0;

    [online mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(centerView);
        make.height.mas_equalTo(22);
        make.width.mas_equalTo(btnWidth);
        make.left.equalTo(centerView);
    }];
    
    [feedback mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(centerView);
        make.height.mas_equalTo(22);
        make.width.mas_equalTo(btnWidth);
        make.right.equalTo(centerView);
    }];
    //左侧竖线
    UIView *leftLine = [UIView creatViewWithSuperView:centerView backgroundColor:[UIColor mainThemeColor]];
    [leftLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.mas_equalTo(0.5);
        make.center.equalTo(centerView);
        make.height.mas_equalTo(23);
    }];
}

#pragma mark --event
///在线客服跳转
-(void)bottonBtnClick:(UIButton *)btn
{
    if ([btn.titleLabel.text isEqualToString:@"在线客服"]) {
        //在线客服跳转网页
        [self navigationToWeb:self.helpCenterModel.customerService];
        
        NSMutableDictionary *info = [[NSMutableDictionary alloc] init];
        [info setObject:@"个人中心" forKey:@"abse_page_name"];
        [info setObject:@"点击在线客服" forKey:@"abse_action_name"];
        [QGAnalyticsService analyticsTrack:@"AppCoreModelClick" withProperties: info];
        
    }else if ([btn.titleLabel.text isEqualToString:@"来电咨询"]){
        //拨打电话调起系统
        NSMutableString *str = [[NSMutableString alloc] initWithFormat:@"telprompt://%@", self.helpCenterModel.phone];
        [[UIApplication sharedApplication] openURL:[NSURL URLWithString:str]];
    }else{
        //跳转至意见反馈
        [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGFeedbackViewController] parameters:nil handlerBlock:nil];
    }
}

#pragma mark tableview

-(NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 3;
}

-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    if (section == 0) {
        return 1;
    }
    //屏蔽自助服务
    else if (section == 1)
    {
        return 0;
    }
    else{
        return self.helpCenterModel.hotQuestionsList.count;
    }
}

-(CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.section == 0) {
        return 48;
    }else if(indexPath.section == 1){
        return 185;
    }else{
        return 61;
    }
}

-(CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    if (section == 0 || section == 1){
        return 0.01;
    }else{
        return 65.f;
    }
}
-(CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return 0.01;
}

-(UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    if (section == 0 || section == 1){

        return [UIView new];
    }else{
        //白色view
        UIView *whiteView = [UIView creatViewWithSuperView:nil backgroundColor:[UIColor whiteColor]];
        UILabel *titleLabel = [UILabel creatLabelWithSuperView:whiteView title:@"热门问题" titleFontSize:[UIFont qg_mediumFontOfSize:18] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(whiteView).inset(20);
            make.centerY.equalTo(whiteView);
            make.height.mas_equalTo(25);
        }];
        return whiteView;
    }
}

-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.section == 0) {
        //跑马灯消息
        QGHelpCenterNoticesCell *cell = (QGHelpCenterNoticesCell *)[self getCellFromClassName:NSStringFromClass([QGHelpCenterNoticesCell class]) dequeueTableView:tableView];
        cell.cellBlock = ^{
            [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGMessageCenterVC] parameters:nil handlerBlock:nil];
        };
        
        cell.noticesArray = self.noticesArray;
        
        return cell;
    }else if (indexPath.section == 1){
        //自助服务
        QGHelpCenterSelfServiceCell *cell = (QGHelpCenterSelfServiceCell *)[self getCellFromClassName:NSStringFromClass([QGHelpCenterSelfServiceCell class]) dequeueTableView:tableView];
        return cell;

    }else{
        //热门问题
        QGMineCommonTitleTableViewCell *cell = (QGMineCommonTitleTableViewCell *)[self getCellFromClassName:NSStringFromClass([QGMineCommonTitleTableViewCell class]) dequeueTableView:tableView];
        cell.separateLineHide = NO;

        QGHotProblemModel *model = self.helpCenterModel.hotQuestionsList[indexPath.row];
        QGMineModel *mineModel = [[QGMineModel alloc] initWithTitle:model.question subtitle:nil clickAction:nil];
        
        cell.model = mineModel;
        
        if (indexPath.row == self.helpCenterModel.hotQuestionsList.count-1) {
            cell.separateLineHide = YES;
        }
        return cell;
    }
}

-(void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
     if (indexPath.section == 2){
        
        QGHotProblemModel *model = self.helpCenterModel.hotQuestionsList[indexPath.row];
        
        [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGHelpCenterDetailsViewController] parameters:@{@"title":model.question,@"content":model.answer} handlerBlock:nil];
        
    }
}

@end
