//
//  QGHelpCenterDetailsViewController.m
//  VirtualPayment
//
//  Created by 胡红磊 on 2019/7/3.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGHelpCenterDetailsViewController.h"
#import "UIView+Extend.h"

@interface QGHelpCenterDetailsViewController ()


@property (nonatomic, strong)UIScrollView *scrollView;
///问题标题
@property (nonatomic, copy)NSString *questiontitle;
///问题答案
@property (nonatomic, copy)NSString *content;


@end

@implementation QGHelpCenterDetailsViewController

-(BOOL)checkParameters:(NSDictionary *)param
{
    return YES;
}
-(void)transferParameters:(NSDictionary *)param
{
    self.questiontitle = [param objectForKey:@"title"];
    self.content = [param objectForKey:@"content"];
}
- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self custemLeftDefaultBarButtonItem];
    self.title = @"帮助详情";
    
    [self setUpUI];
    
}
- (void)setUpUI{
    
    CGFloat navStatusHeight = [DeviceAdaptation getNavBarAndStatusBarHeight];
    
    self.scrollView = [[UIScrollView alloc] init];
    self.scrollView.frame = CGRectMake(0, navStatusHeight, [UIScreen mainScreen].bounds.size.width, [UIScreen mainScreen].bounds.size.height - navStatusHeight);
    [self.view addSubview:_scrollView];
    
    //标题
    UILabel *titleLa = [[UILabel alloc] init];
    titleLa.text = self.questiontitle;
    titleLa.font =[UIFont qg_mediumFontOfSize:18];
    titleLa.textColor = [UIColor textColor3333];
    titleLa.numberOfLines = 0;
    CGFloat titleHeight = [self getHeightByWidth:([UIScreen mainScreen].bounds.size.width - 40) title:titleLa.text font:titleLa.font];
    titleLa.frame = CGRectMake(20, 20, [UIScreen mainScreen].bounds.size.width - 40, titleHeight);
    [self.scrollView addSubview:titleLa];
    
    //分割线
    UIView *spLine = [UIView creatViewWithSuperView:self.scrollView backgroundColor:[UIColor lineSeparatorColorDCDC]];
    spLine.frame = CGRectMake(20, titleLa.bottom + 20 , [UIScreen mainScreen].bounds.size.width - 40, 1);
    
    //详情
    UILabel *detailLa = [[UILabel alloc] init];
    detailLa.text = self.content;
    detailLa.font =[UIFont qg_lightFontOfSize:14];
    detailLa.textColor = [UIColor textColor3333];
    detailLa.numberOfLines = 0;
    
    CGFloat detailHeight = [self getHeightByWidth:([UIScreen mainScreen].bounds.size.width - 40) title:detailLa.text font:detailLa.font];
    detailLa.frame = CGRectMake(20, spLine.bottom + 20, [UIScreen mainScreen].bounds.size.width - 40, detailHeight);
    [self.scrollView addSubview:detailLa];
    
    self.scrollView.contentSize = CGSizeMake([UIScreen mainScreen].bounds.size.width, detailLa.bottom + 20);
}

- (CGFloat )getHeightByWidth:(CGFloat)width title:(NSString *)title font:(UIFont *)font
{
    UILabel *label = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, width, 0)];
    label.text = title;
    label.font = font;
    label.numberOfLines = 0;
    [label sizeToFit];
    CGFloat height = label.frame.size.height;
    return height;
}


/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
