//
//  QGHelpCenterNoticesCell.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/27.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGHelpCenterNoticesCell.h"
#import "QGMarqueeView.h"
#import "QGBasicUITool.h"
#import "QGHelpCenterNoticeModel.h"
@interface QGHelpCenterNoticesCell ()
@property (nonatomic, strong)QGMarqueeView *noticeView;

@end


@implementation QGHelpCenterNoticesCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.noticeView = [[QGMarqueeView alloc] init];
        @weakify(self);
        self.noticeView.clickEventBlock = ^(NSInteger index) {
            @strongify(self);
           if (self.cellBlock) {
               self.cellBlock();
           }
        };

        [self.contentView addSubview:self.noticeView];
        [self.noticeView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.bottom.offset(0);
            make.left.right.inset(20);
        }];
        self.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    return self;
}

-(void)setNoticesArray:(NSArray *)noticesArray
{
    _noticesArray = noticesArray;
    
    
    NSMutableArray *textArray = [[NSMutableArray alloc] initWithCapacity:1];
    
    for (QGHelpCenterNoticeModel *model in _noticesArray) {
        [textArray addObject:model.msgContent];
    }
    
    
    self.noticeView.textArray = textArray.count>0?textArray:@[@"暂无消息"];
}

@end
