//
//  QGFeedbackTextViewCell.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/28.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGFeedbackTextViewCell.h"
#import "QGBasicUITool.h"
#import "QGTextView.h"
@interface QGFeedbackTextViewCell ()<UITextViewDelegate>
///标题
@property (nonatomic, strong)UILabel *titleLabel;
///输入框
@property (nonatomic, strong)QGTextView *textView;
///字数统计
@property (nonatomic, strong)UILabel *textCountLabel;

@end

@implementation QGFeedbackTextViewCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        self.titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"请补充详细问题和意见" titleFontSize:[UIFont qg_lightFontOfSize:18] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        self.textCountLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"0/200" titleFontSize:[UIFont qg_lightFontOfSize:10] textColor:[UIColor textColor9999] alignment:NSTextAlignmentRight];
        [self.contentView addSubview:self.textView];
        
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(self.contentView).inset(20);
            make.top.equalTo(self.contentView).inset(0);
            make.height.mas_equalTo(25);
        }];
        
        [self.textView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(self.contentView).inset(20);
            make.top.equalTo(self.titleLabel.mas_bottom).offset(10);
            make.bottom.equalTo(self.contentView).offset(-35);
        }];
        
        [self.textCountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(self.contentView).inset(20);
            make.top.equalTo(self.textView.mas_bottom).offset(5);
            make.height.mas_equalTo(14);
        }];
    }
    return self;
}



-(BOOL)textView:(UITextView *)textView shouldChangeTextInRange:(NSRange)range replacementText:(NSString *)text
{
        if((textView.text.length-range.length+text.length)>200){
            NSMutableString *contact = [[NSMutableString alloc]initWithString:textView.text];
            [contact appendString:text];
            NSString *subString=[contact substringToIndex:200];
    
            textView.text = subString;
    
            [QGHUDManager showHud:@"最多可以输入200字"];
            return NO;
        }else{
            
            return YES;
        }
    
}

- (void)textViewDidChange:(UITextView *)textView
{
    
    self.textCountLabel.text = [NSString stringWithFormat:@"%lu/200",(unsigned long)textView.text.length];
    if (self.cellBlock) {
        self.cellBlock(textView.text);
    }
}



-(QGTextView *)textView
{
    if (!_textView) {
        _textView = [[QGTextView alloc]initWithFrame:CGRectMake(0, 0, 335, 110)];
        _textView.placeholder = @"输入不少于十个字的描述";
        _textView.delegate = self;
        _textView.font = [UIFont qg_regularFontOfSize:14];
        _textView.textColor = [UIColor textColor3333];
        _textView.backgroundColor = [UIColor moduleSeparatorColorF7F7];
        _textView.textContainer.lineFragmentPadding = 0;
        _textView.textContainerInset = UIEdgeInsetsMake(9, 13, 9, 13);
        _textView.isShowBorder = YES;
    }
    return _textView;
}


@end
