//
//  QGSelectImageView.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/30.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGSelectImageView.h"
#import "QGImageCollectionViewCell.h"
#import "QGBasicUITool.h"
#import "QGImageModel.h"
#import "QGActionSheetView.h"
#import "QiniuService.h"
#import <AVFoundation/AVFoundation.h>
#import "QGTalosNetwork.h"
#import "SystemManager.h"
#import "QGUserCenterRequestApi.h"
@interface QGSelectImageView ()<UICollectionViewDataSource,UICollectionViewDelegateFlowLayout,UINavigationControllerDelegate,UIImagePickerControllerDelegate>

@property (nonatomic, strong)UICollectionView *imageCollectionView;
@property (nonatomic, strong)NSMutableArray *imageArray;

@end

@implementation QGSelectImageView

-(instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        self.frame = frame;
        [self addSubview:self.imageCollectionView];
        
        [self.imageCollectionView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(self).inset(20);
            make.top.bottom.equalTo(self);
        }];
        
        [self.imageCollectionView reloadData];
    }
    return self;
}


-(void)deleteTopicImage:(UIButton *)btn
{
    
    [self.imageArray removeObjectAtIndex:btn.tag];
    
    if (self.callBackBlock) {
        self.callBackBlock(self.imageArray);
    }
    
    [self.imageCollectionView reloadData];
    
}

#pragma mark uicollectionView
//图片大小
-(CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout sizeForItemAtIndexPath:(NSIndexPath *)indexPath{
//    CGFloat collectionFakeW = MAINSCREEN_WIDTH - 40;//判断collection宽度
//    CGFloat cellW =  (collectionFakeW - 10)/3.0;    // 每一个cell的宽度
    return CGSizeMake(floor(74),floor(74));
}

-(UICollectionViewCell*)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath{
    QGImageCollectionViewCell *cell = (QGImageCollectionViewCell *)[collectionView dequeueReusableCellWithReuseIdentifier:NSStringFromClass([QGImageCollectionViewCell class]) forIndexPath:indexPath];
    
    QGImageModel *picModel =  self.imageArray[indexPath.item];
    
    if (indexPath.item == self.imageArray.count-1) {
        cell.deleteBtn.hidden = YES;
    }else{
        cell.deleteBtn.hidden = NO;
        cell.deleteBtn.tag = indexPath.item;
        [cell.deleteBtn addTarget:self action:@selector(deleteTopicImage:) forControlEvents:UIControlEventTouchUpInside];
    }
    cell.iconImageView.image = picModel.image;

    return cell;
}
-(NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section{
    
    if (self.imageArray.count == 1) {
        return 1;
    }else if (self.imageArray.count == 4){
        return 3;
    }else{
        return self.imageArray.count;
    }
    
}
-(void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath{
    
    if (indexPath.item == self.imageArray.count-1) {//添加图片
        [[SystemManager shareInstance].currentViewController.view endEditing:YES];
        QGActionSheetView *actionSheet = [[QGActionSheetView alloc] initWithTitle:nil options:@[@[@"拍照",@"相册"],@[@"取消"]] clickBlock:^(NSInteger index) {
            if (1 == index) {
                // 开始拍照
                [self takePhoto];
            } else if (2 == index) {
                //打开本地相册
                [self localPhoto];
            }
        }];
        
        [actionSheet showInView:[SystemManager shareInstance].currentViewController.view];
        
    }else{
        

        
    }
}


#pragma mark --imagePicker
// 开始拍照
- (void)takePhoto {
    if ([UIImagePickerController isSourceTypeAvailable:UIImagePickerControllerSourceTypeCamera]) {
        UIImagePickerController *picker = [[UIImagePickerController alloc] init];
        picker.sourceType = UIImagePickerControllerSourceTypeCamera;
        picker.delegate = self;
        //设置拍照后的图片可被编辑
        picker.allowsEditing = YES;
        picker.sourceType = UIImagePickerControllerSourceTypeCamera;
        //先检查相机可用是否
        BOOL cameraIsAvailable = [self checkCamera];
        if (YES == cameraIsAvailable) {
            [[SystemManager shareInstance].currentViewController presentViewController:picker animated:YES completion:nil];
        } else {
            UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"请在iPhone的“设置-隐私-相机”选项中，允许本应用程序访问你的相机。" delegate:self cancelButtonTitle:@"好，我知道了" otherButtonTitles:nil];
            [alert show];
        }
    }
}

// 打开本地相册
- (void)localPhoto {
    //本地相册不需要检查，因为UIImagePickerController会自动检查并提醒
    UIImagePickerController *picker = [[UIImagePickerController alloc] init];
    picker.sourceType = UIImagePickerControllerSourceTypePhotoLibrary;
    picker.delegate = self;
    //设置选择后的图片可被编辑
    picker.allowsEditing = YES;
    [[SystemManager shareInstance].currentViewController presentViewController:picker animated:YES completion:nil];
}

//检查相机是否可用
- (BOOL)checkCamera {
    NSString *mediaType = AVMediaTypeVideo;
    AVAuthorizationStatus authStatus = [AVCaptureDevice authorizationStatusForMediaType:mediaType];
    if (AVAuthorizationStatusRestricted == authStatus ||
        AVAuthorizationStatusDenied == authStatus) {
        //相机不可用
        return NO;
    }
    //相机可用
    return YES;
}
//压缩图片质量
- (UIImage *)reduceImage:(UIImage *)image percent:(float)percent {
    NSData *imageData = UIImageJPEGRepresentation(image, percent);
    UIImage *newImage = [UIImage imageWithData:imageData];
    return newImage;
}
//压缩图片尺寸
- (UIImage *)imageWithImageSimple:(UIImage *)image scaledToSize:(CGSize)newSize {
    UIGraphicsBeginImageContext(newSize);
    [image drawInRect:CGRectMake(0, 0, newSize.width, newSize.height)];
    UIImage *newImage = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    return newImage;
}
- (void)avatarUploadImage:(UIImage *)image {
    NSString *url = [QGUserCenterRequestApi urlWithUserCenterRequestServerMethod:QGUserCenterRequestServerMethodPersonalUpload];
    
    [QGHUDManager showHud:nil];
    NSMutableDictionary *params = [[NSMutableDictionary alloc] init];
    [params setValue:@"suggestion" forKey:@"businessFlag"];
    
    [[QGTalosNetwork shareManager] GET:url parameters:params success:^(id  _Nonnull responseObject) {
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary *dic = (NSDictionary *) responseObject;
            NSData *imageData = UIImageJPEGRepresentation(image, 0.2);
            [self qiniuServicePutData:dic[@"data"] imageData:imageData];
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
    }];
    
}
-(void)qiniuServicePutData:(NSDictionary *)data imageData:(NSData *)imageData{
    [[QiniuService shareInstance] putData:imageData
                                    token:[data valueForKey:@"uploadToken"]
                                      key:[data valueForKey:@"key"]
                                   params:nil
                                 complete:^(QNResponseInfo *info, NSString *key, NSDictionary *resp) {
                                     if (resp) {
                                         
                                         NSLog(@"resp______%@",resp);
                                         [QGHUDManager hideHud];


                                         QGImageModel *imageModel = [[QGImageModel alloc]init];
                                         imageModel.image = [UIImage imageWithData:imageData];
                                         imageModel.completeUrl = [data valueForKey:@"fileUrl"];
                                         [self.imageArray insertObject:imageModel atIndex:self.imageArray.count-1];
                                         [self.imageCollectionView reloadData];
                                         
                                         if (self.callBackBlock) {
                                             self.callBackBlock(self.imageArray);
                                         }
                                     }
                                 }
                          progressHandler:^(NSString *key, float percent){
                              
                          }];
    
    
}

#pragma mark UIImagePickerControllerDelegate Call Back Implementation

- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary *)info {
    NSString *type = [info objectForKey:UIImagePickerControllerMediaType];
    
    //当选择的类型是图片
    if ([type isEqualToString:@"public.image"]) {
        NSString *key = nil;
        
        if (picker.allowsEditing) {
            key = UIImagePickerControllerEditedImage;
        } else {
            key = UIImagePickerControllerOriginalImage;
        }
        //获取图片
        UIImage *image = [info objectForKey:key];
        
        if (picker.sourceType == UIImagePickerControllerSourceTypeCamera) {
            //压缩图片质量
            image = [self reduceImage:image percent:0.1];
            CGSize imageSize = image.size;
            imageSize.height = 320;
            imageSize.width = 320;
            //压缩图片尺寸
            image = [self imageWithImageSimple:image scaledToSize:imageSize];
        }
        
        //关闭相册界面
        [picker dismissViewControllerAnimated:YES
                                   completion:^{
                                       [self avatarUploadImage:image];
                                       
                                   }];
    }
}


#pragma mark --getter

-(UICollectionView*)imageCollectionView
{
    if (!_imageCollectionView) {
        UICollectionViewFlowLayout *layout= [[UICollectionViewFlowLayout alloc]init];
        layout.minimumInteritemSpacing = 1;
        layout.minimumLineSpacing = 10;
        _imageCollectionView = [[UICollectionView alloc]initWithFrame:(CGRect){0,0,200,74} collectionViewLayout:layout];
        _imageCollectionView.backgroundColor = [UIColor clearColor];
        _imageCollectionView.delegate = self;
        _imageCollectionView.dataSource = self;
        _imageCollectionView.scrollEnabled = NO;
        [_imageCollectionView registerClass:[QGImageCollectionViewCell class] forCellWithReuseIdentifier:NSStringFromClass([QGImageCollectionViewCell class])];
    }
    return _imageCollectionView;
}

-(NSMutableArray *)imageArray
{
    if (!_imageArray) {
        _imageArray = [[NSMutableArray alloc]init];
        QGImageModel *imageModel = [[QGImageModel alloc]init];
        imageModel.isAdd = YES;
        imageModel.image = [UIImage imageNamed:@"addImage"];
        imageModel.imagePath = nil;
        imageModel.imageName = @"addImage";
        imageModel.bigImage = nil;
        [_imageArray addObject:imageModel];
    }
    return _imageArray;
}

@end
