//
//  QGMineCommonTitleTableViewCell.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/26.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGMineCommonTitleTableViewCell.h"
#import "QGBasicUITool.h"
@implementation QGMineCommonTitleTableViewCell

-(instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        [self.arrowImage setImage:[UIImage imageNamed:@"cell_right_arrow"]];

        self.subcontentLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_lightFontOfSize:16] textColor:[UIColor textColor9999] alignment:NSTextAlignmentRight];
        self.titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_lightFontOfSize:16] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
       
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.contentView).offset(20);
//            make.centerY.equalTo(self.contentView);
            make.top.equalTo(self.contentView).inset(20);
            make.height.mas_equalTo(22);
            make.right.equalTo(self.subcontentLabel).offset(10);
        }];
        

        
        [self.subcontentLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.titleLabel).offset(10);
            make.centerY.equalTo(self.contentView);
            make.height.mas_equalTo(22);
            make.right.equalTo(self.arrowImage).inset(10);
        }];
        self.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    return self;
}

-(void)setModel:(QGMineModel *)model
{
    _model = model;
    self.titleLabel.text = _model.title;
    self.subcontentLabel.text = _model.subtitle;
    self.separateLineHide = _model.hideSeparateLine;
     
}

@end
