//
//  QGHorizontalFlowButtonView.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/28.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGHorizontalFlowButtonView.h"
#import "UIView+Extend.h"
#import "UIColor+QGColor.h"
@interface QGHorizontalFlowButtonView()

@property (nonatomic, strong)UIButton *selectBtn;


@end

@implementation QGHorizontalFlowButtonView

-(instancetype)initWithFrame:(CGRect)frame buttonList:(NSMutableArray *)buttonList itemMargin:(CGFloat)itemMargin topMargin:(CGFloat)topMargin leftMargin:(CGFloat)leftMargin
{
    if (self = [super initWithFrame:frame]) {
        self.frame = frame;
        
        _buttonList = buttonList;
        _topMargin = topMargin;
        _leftMargin = leftMargin;
        _itemMargin = itemMargin;
        
        for (int i = 0; i < _buttonList.count; i++) {
            UIButton *button = _buttonList[i];
            button.tag = i;
            [button addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
            [self addSubview:button];
        }
        
        [self layoutButtons];
    }
    return self;
}



-(void)btnClick:(UIButton *)btn
{
    //点击的不是同一按钮
    if (self.selectBtn != btn) {
        //取消上一次点击按钮的选中状态
        self.selectBtn.selected = NO;
        self.selectBtn.layer.borderColor = [UIColor textColor9999].CGColor;
        //本次点击按钮设为选中状态
        btn.selected = YES;
        btn.layer.borderColor = [UIColor mainThemeColor].CGColor;
        //记录选中状态的按钮
        self.selectBtn = btn;
        //点击了不同的按钮回调按钮index
        if (self.selectBlock) {
            self.selectBlock(btn.tag);
        }
    }
    
}

- (void)layoutButtons {
    
    if (self.buttonList.count<=0) {
        return;
    }
    
    // 对第一个Button进行设置 肯定是在第一行的第一个
    UIButton *button0 = self.buttonList[0];
    button0.x = self.leftMargin;
    button0.y = self.topMargin;
    
    // 对其他Button进行设置（从第二个按钮开始设置）
    for (int i = 1; i < self.buttonList.count; i++) {
       //待约束按钮
        UIButton *button = self.buttonList[i];
        //以约束按钮
        UIButton *lastButton = self.buttonList[i - 1];
        
        //待约束按钮排列在上一个按钮之后的总宽度
        CGFloat sumWidth = lastButton.x + lastButton.width + self.itemMargin + button.width + self.leftMargin;
        
        if (sumWidth > self.width) {
            //如果超出以后换行
            button.x = self.leftMargin;
            button.y = lastButton.y + self.itemMargin + button.height;

        } else {
            //继续向后排列
            button.x = sumWidth - button.width - self.leftMargin;
            button.y = lastButton.y;
        }
    }
    UIButton *lastButton = self.buttonList.lastObject;
    //设置self的高度
    self.height = CGRectGetMaxY(lastButton.frame) + self.topMargin;
}


@end
