//
//  QGHorizontalFlowButtonView.h
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/28.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>

typedef void(^ButtonSelectBlock)(NSUInteger index);

/**
 水平方向流式布局按钮
 */
@interface QGHorizontalFlowButtonView : UIView


@property (nonatomic, copy)ButtonSelectBlock selectBlock;


/**
 *  存放需要显示的button
 */
@property (nonatomic, strong) NSMutableArray *buttonList;

/**
 *  按钮间距
 */
@property (nonatomic, assign) CGFloat itemMargin;
/**
 *  控件上下边距
 */
@property (nonatomic, assign) CGFloat topMargin;
/**
 *  控件左右边距
 */
@property (nonatomic, assign) CGFloat leftMargin;




/**
 流式标签按钮

 @param buttonList 按钮数组
 @param itemMargin 左右间距
 @param topMargin 上下间距
 @param leftMargin 按钮间距
 */

-(instancetype)initWithFrame:(CGRect)frame buttonList:(NSMutableArray *)buttonList itemMargin:(CGFloat)itemMargin topMargin:(CGFloat)topMargin leftMargin:(CGFloat)leftMargin;

//- (instancetype)initWithButtonList:(NSMutableArray *)buttonList itemMargin:(CGFloat)itemMargin topMargin:(CGFloat)topMargin leftMargin:(CGFloat)leftMargin;
@end
