//
//  QGUserInfo.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/21.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGUserInfo.h"
#import <objc/runtime.h>
#import "QGGlobalConst.h"
#import "NSString+CreditWallet.h"
#import "QGAnalyticsService.h"
#import "QGPushService.h"

#import "SDImageCache.h"

///单例归档的位置
#define kUserInfoFilePath [NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES)[0] stringByAppendingPathComponent:@"VCCUserInfo.data"]

@implementation QGUserInfo

//如果同时重写了属性的getter&setter方法，_成员变量就不会自动生成。必须实现@synthesize（或者声明成员变量）
@synthesize uuid = _uuid;
@synthesize avatar = _avatar;
@synthesize realName = _realName , userId = _userId;


#pragma mark - 单例全局访问点
static QGUserInfo *userInfo = nil;

+ (QGUserInfo *)sharedUserInfo{
    static dispatch_once_t predicate;
    dispatch_once(&predicate, ^{
        userInfo = [NSKeyedUnarchiver unarchiveObjectWithData:[self deArchive]];
        if (userInfo == nil) {
            userInfo = [[QGUserInfo alloc] init];
        }
    });
    return userInfo;
}

//重置单例对象
+ (void)resetBaseInfo {
    userInfo = [[QGUserInfo alloc] init];
    //归档数据
    [self archive];
}

#pragma mark - 归档/接档
// 归档
- (void)encodeWithCoder:(NSCoder*)encoder {
    unsigned int count;
    Ivar* ivars = class_copyIvarList([self class], &count);
    for (int i = 0; i < count; i++) {
        Ivar ivar = ivars[i];
        const char* name = ivar_getName(ivar);
        NSString* strName = [NSString stringWithUTF8String:name];
        id value = [self valueForKey:strName];
        if (value) {
            [encoder encodeObject:value forKey:strName];
        }
    }
    free(ivars);
}

// 解档
- (id)initWithCoder:(NSCoder*)decoder {
    if (self = [super init]) {
        unsigned int count;
        Ivar* ivars = class_copyIvarList([self class], &count);
        for (int i = 0; i < count; i++) {
            Ivar ivar = ivars[i];
            const char* name = ivar_getName(ivar);
            NSString* strName = [NSString stringWithUTF8String:name];
            id value = [decoder decodeObjectForKey:strName];
            if (value) {
                [self setValue:value forKey:strName];
            }
        }
        free(ivars);
    }
    return self;
}

+ (void)archive {
    //获取单例UserInfo
    QGUserInfo *userInfo = [QGUserInfo sharedUserInfo];
    NSData *archiverData = [NSKeyedArchiver archivedDataWithRootObject:userInfo];
    [archiverData writeToFile:kUserInfoFilePath atomically:YES];
}

+ (NSData *)deArchive {
    NSData *data = [[NSData alloc] initWithContentsOfFile:kUserInfoFilePath];
    return data;
}

#pragma mark - 设置登录账号并归档
//username的set方法
- (void)setUserName:(NSString *)userName {
    _userName = userName;
    
    [QGUserInfo archive];
    
   
}


-(void)setRealName:(NSString *)realName
{
     _realName = realName;
    [QGUserInfo archive];
}

- (NSString *)realName {

    if ([NSString isEmpty:_realName]) {
        return _userName;
    }else{
       return  _realName;
    }

}



#pragma mark - 设置登录状态并归档
- (void)setLogin:(BOOL)login {
    _login = login;
    
    [QGUserInfo archive];
}

#pragma mark - vccRefreshToken
- (void)setVccRefreshToken:(NSString *)vccRefreshToken
{
    _vccRefreshToken = vccRefreshToken;
    [QGUserInfo archive];
}

#pragma mark- token

- (void)setToken:(NSString *)token
{
    _token = token;
    [QGUserInfo archive];
    
}

- (void)setUserId:(NSString *)userId
{
    _userId = userId;
    [QGUserInfo archive];
}


#pragma mark- uuid
- (void)setUuid:(NSString *)uuid
{
    
    _uuid = uuid;
    [QGUserInfo archive];
    
}


- (NSString *)uuid
{
    if (_uuid && _uuid.length > 0) {
        return _uuid;
    }else{
        NSString *localuuid = [[NSUserDefaults standardUserDefaults] valueForKey:@"uuid"];
        if (localuuid && localuuid.length > 0 ) {
            _uuid = localuuid;
        }else{
            _uuid = @"";
        }
    }
    
    return _uuid;
    
}

- (NSString *)userId
{
    if (!_userId) {
        return @"";
    }
    return _userId;
}

-(void)setAvatar:(NSString *)avatar
{
    _avatar = avatar;
    [QGUserInfo archive];
}

-(NSString *)avatar
{
    //防止头像nil时崩溃
    if ([NSString isEmpty:_avatar]) {
        _avatar = @"";
    }
    return _avatar;
}

-(void)setUnreadNumber:(NSString *)unreadNumber
{
    //容错处理防止NSNumberN
    _unreadNumber = [NSString stringWithFormat:@"%@",unreadNumber];
    [QGUserInfo archive];
}



-(void)setHasPassword:(BOOL)hasPassword
{
    _hasPassword = hasPassword;
    [QGUserInfo archive];
}

- (void)setTaobaoAuth:(BOOL)taobaoAuth
{
    _taobaoAuth = taobaoAuth;
    [QGUserInfo archive];
}

- (void)setAlimamaAuth:(BOOL)alimamaAuth
{
    _alimamaAuth = alimamaAuth;
    [QGUserInfo archive];
}

#pragma mark - isLogin
//是否登录
+(BOOL)isLogin
{
    NSString *vccRefreshToken =[QGUserInfo sharedUserInfo].vccRefreshToken;
    NSString *userName = [QGUserInfo sharedUserInfo].userName;
    NSString *token = [QGUserInfo sharedUserInfo].token;
    
    if (vccRefreshToken.length>2 && userName.length > 0 && token.length > 0) {
        return YES;
    }else{
        return NO;
    }
}


#pragma mark - 退出

+ (void)logOut {
    [QGPushService unsetPushAccount:[QGUserInfo sharedUserInfo].userId];
    [QGAnalyticsService analyticsLogout];
    [self resetBaseInfo];
    [[NSNotificationCenter defaultCenter] postNotificationName:ModelCenterUserLogOutNotification
                                                        object:nil
                                                      userInfo:nil];
}



@end
