//
//  QGUserInfo.h
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/21.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface QGUserInfo : NSObject
///用户登录手机号
@property (nonatomic,strong) NSString *userName;

///用户真实姓名（姓名或者手机号）
@property (nonatomic,strong) NSString *realName;

///用户未读消息数
@property (nonatomic,strong) NSString *unreadNumber;

///用户头像
@property (nonatomic,strong) NSString *avatar;

///vccRefreshToken
@property (nonatomic,strong) NSString *vccRefreshToken;

///token·
@property (nonatomic,strong) NSString *token;

///uuid
@property (nonatomic,strong) NSString *uuid;

@property (nonatomic, copy) NSString *userId;

///用户是否登录
@property (nonatomic,getter=isLogin) BOOL login;


///是否已经设置密码
@property (nonatomic, assign)BOOL hasPassword;

/// 淘宝授权  弃用字段
@property (nonatomic, assign) BOOL taobaoAuth;

/// 淘宝联盟授权字段
@property (nonatomic, assign) BOOL alimamaAuth;

///单例：UserInfo全局访问点
+ (QGUserInfo *)sharedUserInfo;

///重置UserInfo单例对象
+ (void)resetBaseInfo;

//是否登录
+(BOOL)isLogin;
// 是否有token
//+(BOOL)isHasToKen;

///退出
+ (void)logOut;



@end
