//
//  QGQuotaManagerViewController.m
//  VirtualPayment
//
//  Created by 张博 on 2019/9/24.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGQuotaManagerViewController.h"

//Tool
#import "SystemManager.h"
#import "QGQuotaRequestApi.h"
#import "QGActivityPopManager.h"


//Model
#import "QGQuotaManagerModel.h"

//View
#import "QGQuotaManagerHeaderCell.h"
#import "QGQuotaBannerCell.h"
#import "QGQuotaAdvantageCell.h"
#import "QGQuotaIncrementCell.h"
#import "QGNoQuotaIncrementCell.h"
#import "QGIncreaseStrategyCell.h"

@interface QGQuotaManagerViewController ()

/// 额度管理数据
@property (nonatomic, strong) QGQuotaManagerModel * dataModel;

@end

@implementation QGQuotaManagerViewController

- (BOOL)checkParameters:(NSDictionary *)param
{
    return YES;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.title = @"额度管理";
    [self custemLeftDefaultBarButtonItem];
    [self addRefresh];
    
//    [QGActivityPopManager.shareInstance showActivitiesAtPosition:QGActivityPositionManager inController:self];
    
}

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    [self headerRefreshRequest];
    [QGActivityPopManager.shareInstance viewDidAppearAtPosition:QGActivityPositionManager inController:self];
}

///添加下拉刷新
- (void)addRefresh
{
    @weakify(self);
    [self.tableView addRefreshWithHandle:^(BOOL isHeaderRefresh) {
        @strongify(self);
        if (isHeaderRefresh) {
            //下拉就是第一页
            [self headerRefreshRequest];
        }
        else
        {
            [self requestQuotaData];
        }
    }];
    self.tableView.pageCount = 10;
}

///下拉触发的请求
- (void)headerRefreshRequest
{
    self.tableView.pageNum = 1;
    [self requestQuotaData];
}

/// 请求额度管理数据
- (void)requestQuotaData
{

//    NSString * urlString = @"http://yapi.quantgroups.com/mock/305/vcc/mvp/quota/management";
    NSString * urlString = [QGQuotaRequestApi urlWithIndex:QGQuotaRequestServerMethodQuotaManager];
    NSMutableDictionary * infoDic = [NSMutableDictionary dictionaryWithCapacity:0];
    //页码是必传字段
    [infoDic setObject:@(self.tableView.pageNum) forKey:@"currentPageNo"];
    [infoDic setObject:@(self.tableView.pageCount) forKey:@"pageSize"];
    
    @weakify(self);
    
    [[QGTalosNetwork shareManager] GET:urlString parameters:infoDic success:^(id  _Nonnull responseObject) {
        @strongify(self);
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            QGQuotaManagerModel * quotaModel = [QGQuotaManagerModel yy_modelWithDictionary:responseObject[@"data"]];
            //如果是第一页
            if (self.tableView.pageNum == 1) {
                self.dataModel = quotaModel;
            }
            //从第二页开始只要提额信息
            else
            {
                [self.dataModel.incrementPackageList addObjectsFromArray:quotaModel.incrementPackageList];
            }
            [self.tableView endRefreshWithBusinessSuccess:YES count:quotaModel.incrementPackageList.count];
            [self.tableView reloadData];
            
            //如果没有数据，则不显示没有更多数据
            if (self.dataModel.incrementPackageList.count == 0) {
                [self.tableView removeFooterLoadData];
            }
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
            [self.tableView endRefreshWithBusinessSuccess:NO count:0];
        }
        
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        @strongify(self);
        NSString * errorMessage = [QGBaseNetwork getMessageWithFailureError:error];
        [QGHUDManager showHud:errorMessage];
        [self.tableView endRefreshWithBusinessSuccess:NO count:0];
    }];
}


#pragma mark - UITableViewDataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return self.dataModel ? 5 : 0;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    NSInteger numberOfRows = 0;
    switch (section) {
            //顶部额度显示区域
        case 0:
            numberOfRows = self.dataModel.userQuotaInfo.showWaitingActivityQuota.boolValue ? 1 : 2;
            break;
            //未授信的情况下的banner
        case 1:
        {
            if (!self.dataModel.hasReceivedQuota.boolValue && ![NSString isEmpty:self.dataModel.creditMaxAmountImageUrl]) {
                numberOfRows = 1;
            }
        }
            break;
            //三大优势
        case 2:
        {
            numberOfRows = self.dataModel.hasReceivedQuota.boolValue ? 0 : self.dataModel.vccAdvantageInfoList.count;
        }
        break;
            //提额包
        case 3:
        {
            numberOfRows = self.dataModel.hasReceivedQuota.boolValue ? self.dataModel.incrementPackageList.count : 0;
        }
        break;
            //无可用提额包
        case 4:
        {
            //已有额度并且提额包数量为0
            if (self.dataModel.hasReceivedQuota.boolValue && self.dataModel.incrementPackageList.count == 0) {
                numberOfRows = 1;
            }
        }
        break;
            
        default:
            break;
    }
    
    return numberOfRows;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    switch (indexPath.section) {
            //顶部额度显示区域
        case 0:
        {
            //顶部额度显示
            if (indexPath.row == 0) {
                QGQuotaManagerHeaderCell * cell = (QGQuotaManagerHeaderCell *)[self getCellFromClassName:NSStringFromClass([QGQuotaManagerHeaderCell class]) dequeueTableView:tableView];
                cell.dataModel = self.dataModel;
                
                @weakify(self);
                //开通按钮
                [cell.openButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
                    @strongify(self);
                    if ([QGUserInfo isLogin]) {
                        [[SystemManager shareInstance].tabbarController jumpCard];
                    }
                    else
                    {
                        [self showLoginViewController];
                    }
                }];
                
                //提额
                [cell.increaseButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
                    [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGIncreaseAmountController] parameters:nil handlerBlock:nil];
                }];
                
                return cell;
            }
            //提额攻略
            else if (indexPath.row == 1)
            {
                QGIncreaseStrategyCell * cell = (QGIncreaseStrategyCell *)[self getCellFromClassName:NSStringFromClass([QGIncreaseStrategyCell class]) dequeueTableView:tableView];
                @weakify(self);
                //提额攻略点击事件
                [cell.openButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
                    @strongify(self);
                    [self navigationToWeb:DrawStrategyUrl];
                }];
                
                return cell;
            }
        }
            break;
        //未授信的情况下的banner
        case 1:
        {
            QGQuotaBannerCell * cell = (QGQuotaBannerCell *)[self getCellFromClassName:NSStringFromClass([QGQuotaBannerCell class]) dequeueTableView:tableView];
            cell.imageUrl = self.dataModel.creditMaxAmountImageUrl;
            return cell;
        }
            break;
            //三大优势
        case 2:
        {
            QGQuotaAdvantageCell * cell = (QGQuotaAdvantageCell *)[self getCellFromClassName:NSStringFromClass([QGQuotaAdvantageCell class]) dequeueTableView:tableView];
            cell.listModel = self.dataModel.vccAdvantageInfoList[indexPath.row];
            return cell;
        }
            break;
            //提额包
       case 3:
       {
           QGQuotaIncrementCell * cell = (QGQuotaIncrementCell *)[self getCellFromClassName:NSStringFromClass([QGQuotaIncrementCell class]) dequeueTableView:tableView];
           QGIncrementPackageModel * packageModel = self.dataModel.incrementPackageList[indexPath.row];
           cell.packageModel = packageModel;
           @weakify(self);
           //领取
           [cell.receiveButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
               @strongify(self);
               [self receiveButtonClick:packageModel];
           }];
           
           return cell;
       }
           break;
            //无可用提额包
        case 4:
        {
            QGNoQuotaIncrementCell * cell = (QGNoQuotaIncrementCell *)[self getCellFromClassName:NSStringFromClass([QGNoQuotaIncrementCell class]) dequeueTableView:tableView];
            return cell;
        }
            break;
            
            
            
        default:
            break;
    }
    
    return [super tableView:tableView cellForRowAtIndexPath:indexPath];
}





- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CGFloat heightForRow = 0;
    switch (indexPath.section) {
            //顶部额度显示区域
        case 0:
        {
            //顶部额度显示区域
            if (indexPath.row == 0) {
                heightForRow = 229;
            }
            //提额攻略
            else if (indexPath.row == 1)
            {
                heightForRow = 60;
            }
        }
            
            break;
            //未授信的情况下的banner
        case 1:
            heightForRow = [QGQuotaBannerCell cellHeight];
            break;
            //三大优势
        case 2:
            heightForRow = 92;
            break;
            //提额包
        case 3:
            heightForRow = 100;
            break;
            //提额包
        case 4:
            heightForRow = 280;
            break;
            
        default:
            break;
    }
    return heightForRow;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section {
    
    CGFloat heightForHeader = 0;
    switch (section) {
        case 1:
        {
            heightForHeader = 10;
        }
            break;
            //三大优势
        case 2:
        {
            heightForHeader = self.dataModel.hasReceivedQuota.boolValue ? 0 : 45;
        }
            break;
            //提额包
        case 3:
        {
            heightForHeader = self.dataModel.hasReceivedQuota.boolValue ? 60 : 0;
        }
            break;
            
        default:
            break;
    }
    
    return heightForHeader > 0 ? heightForHeader : CGFLOAT_MIN;
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    switch (section) {
        case 1:
        {
            UIView * view = [UIView creatViewWithSuperView:nil backgroundColor:[UIColor moduleSeparatorColorF7F7]];
            return view;
        }
            break;
            //三大优势
        case 2:
        {
            UIView * view = [UIView creatViewWithSuperView:nil backgroundColor:[UIColor whiteColor]];
            view.clipsToBounds = YES;
            UILabel * titleLabel = [UILabel creatLabelWithSuperView:view title:@"三大优势" titleFontSize:[UIFont qg_regularFontOfSize:18] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
            [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
                make.left.top.offset(20);
                make.height.mas_equalTo(25);
            }];
            return view;
        }
            break;
            //提额包小贴士
        case 3:
        {
            UIView * view = [UIView creatViewWithSuperView:nil backgroundColor:[UIColor whiteColor]];
            view.clipsToBounds = YES;
            UILabel * titleLabel = [UILabel creatLabelWithSuperView:view title:@"小贴士：绑卡到微信、支付宝进行消费、支付、发红包等操作，可获得提额包" titleFontSize:[UIFont qg_lightFontOfSize:12] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
            titleLabel.numberOfLines = 2;
            [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
                make.left.right.inset(20);
                make.top.offset(10);
                make.height.mas_equalTo(40);
            }];
            return view;
        }
            break;
            
        default:
            break;
    }
   
    return nil;
}

#pragma mark - Action

/// 领取按钮
- (void)receiveButtonClick:(QGIncrementPackageModel *)packageModel
{
    if ([NSString isEmpty:packageModel.packageId]) {
        return;
    }
//    NSString * urlString = @"http://yapi.quantgroups.com/mock/169/vcc/mvp/quota/incrementQuotaPackage/receive";
    NSString * urlString = [QGQuotaRequestApi urlWithIndex:QGQuotaRequestServerMethodIncrementReceive];
    NSDictionary * infoDic = @{@"increQuotaPackageId":packageModel.packageId};
    [QGHUDManager showHud:nil];
    @weakify(self);
    [[QGTalosNetwork shareManager] POST:urlString parameters:infoDic success:^(id  _Nonnull responseObject) {
        @strongify(self);
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            [QGHUDManager showHud:@"领取成功"];
            [self headerRefreshRequest];
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
        
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        NSString * errorMessage = [QGBaseNetwork getMessageWithFailureError:error];
        [QGHUDManager showHud:errorMessage];
    }];
    
}


@end
