//
//  QGQuotaIncrementCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/9/25.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGQuotaIncrementCell.h"
#import "QGBasicUITool.h"
#import "ZHAttributedLabelTool.h"
#import "QGGradientShadowButton.h"
@interface QGQuotaIncrementCell ()

/// 左侧颜色视图
@property (nonatomic, strong) UIView * leftColorView;

/// 左侧图标
@property (nonatomic, strong) UIImageView * leftImageView;

/// 左侧标题
@property (nonatomic, strong) UILabel * leftTitleLabel;

/// 金额
@property (nonatomic, strong) UILabel * amountLabel;

/// 描述
@property (nonatomic, strong) UILabel * descLabel;

/// 领取按钮
@property (nonatomic, strong, readwrite) QGGradientShadowButton * receiveButton;

/// 已领取按钮
@property (nonatomic, strong) UIButton * usedButton;
@end


@implementation QGQuotaIncrementCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        //底部阴影层
        UIView * shadowView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor clearColor]];
        [shadowView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.top.bottom.inset(5);
        }];
        [shadowView setShadowColor:[[UIColor blackColor] colorWithAlphaComponent:0.16] shadowRadius:2 shadowOffset:CGSizeMake(0, 0.5) cornerRadius:5];
        shadowView.layer.shadowPath = [self shadowPath].CGPath;
        
        //内容展示层
        UIView * subContentView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor whiteColor]];
        [subContentView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.top.bottom.inset(5);
        }];
        CAShapeLayer * layer = [CAShapeLayer layer];
        layer.path = [self shadowPath].CGPath;
        subContentView.layer.mask = layer;
        subContentView.layer.cornerRadius = 5;
        subContentView.clipsToBounds = YES;
        
        /// 左侧颜色视图
        self.leftColorView = [UIView creatViewWithSuperView:subContentView backgroundColor:nil];
        [self.leftColorView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.top.bottom.inset(0);
            make.width.mas_equalTo(90);
        }];

        /// 左侧图标
        self.leftImageView = [UIImageView creatImageViewWithSuperView:subContentView imageName:nil];
        [self.leftImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.bottom.inset(0);
            make.size.mas_equalTo(CGSizeMake(60, 60));
        }];
        
        /// 左侧标题
        self.leftTitleLabel = [UILabel creatLabelWithSuperView:self.leftColorView title:nil titleFontSize:[UIFont qg_regularFontOfSize:12] textColor:[UIColor whiteColor] alignment:NSTextAlignmentLeft];
        [self.leftTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.left.right.offset(8);
            make.height.mas_equalTo(17);
        }];

        /// 金额
        self.amountLabel = [UILabel creatLabelWithSuperView:subContentView title:nil titleFontSize:nil textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [self.amountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.leftColorView.mas_right).offset(14);
            make.top.offset(14);
            make.height.mas_equalTo(36);
        }];

        /// 描述
        self.descLabel = [UILabel creatLabelWithSuperView:subContentView title:nil titleFontSize:[UIFont qg_lightFontOfSize:12] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        self.descLabel.numberOfLines = 2;
        [self.descLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.leftColorView.mas_right).offset(14);
            make.right.inset(14);
            make.top.mas_equalTo(self.amountLabel.mas_bottom).offset(2);
        }];

        /// 领取按钮
        self.receiveButton = [QGGradientShadowButton creatGradientColorButtonWithSuperView:subContentView title:@"" textFont:[UIFont qg_regularFontOfSize:14]];
        [self.receiveButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(20);
            make.top.inset(17);
            make.size.mas_equalTo(CGSizeMake(60, 30));
        }];
        
        ///已领取
        self.usedButton = [UIButton creatButtonWithSuperView:subContentView title:@"已领取" titleFont:[UIFont qg_regularFontOfSize:14] textColor:[UIColor textColor9999]];
        self.usedButton.hidden = YES;
        [self.usedButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.bottom.mas_equalTo(self.receiveButton);
        }];
        [self.usedButton setBorder:[UIColor textColor9999] width:0.5];
        self.usedButton.layer.cornerRadius = 15;
        self.usedButton.clipsToBounds = YES;
        
    }
    return self;
}


- (UIBezierPath *)shadowPath
{
    UIBezierPath * path = [UIBezierPath bezierPath];
    
    CGFloat height = 90;
    CGFloat arcRadius = 10;
    
    //左侧
    [path moveToPoint:CGPointMake(0, 0)];
    [path addLineToPoint:CGPointMake(0, height/2.0 - arcRadius)];
    [path addArcWithCenter:CGPointMake(0, height/2.0) radius:arcRadius startAngle:-M_PI_2 endAngle:M_PI_2 clockwise:YES];
    [path addLineToPoint:CGPointMake(0, height/2.0 + arcRadius)];
    [path addLineToPoint:CGPointMake(0, height)];
    //底部
    [path addLineToPoint:CGPointMake(MAINSCREEN_WIDTH - 20 * 2, height)];
    //右侧
    [path addLineToPoint:CGPointMake(MAINSCREEN_WIDTH - 20 * 2, height/2.0 + arcRadius)];
    [path addArcWithCenter:CGPointMake(MAINSCREEN_WIDTH - 20 * 2, height/2.0) radius:arcRadius startAngle:M_PI_2 endAngle:M_PI_2 * 3 clockwise:YES];
    [path addLineToPoint:CGPointMake(MAINSCREEN_WIDTH - 20 * 2, height/2.0 - arcRadius)];
    [path addLineToPoint:CGPointMake(MAINSCREEN_WIDTH - 20 * 2, 0)];
    //顶部
    [path addLineToPoint:CGPointMake(0, 0)];
    
    return path;
}


- (void)setPackageModel:(QGIncrementPackageModel *)packageModel
{
    if (_packageModel != packageModel) {
        _packageModel = packageModel;
        
        //提额包
        if ([_packageModel.type isEqualToString:@"Increase"]) {
            self.leftTitleLabel.text = @"提额奖励包";
            self.leftColorView.backgroundColor = [UIColor colorWithHexString:@"E97274"];
            self.leftImageView.image = [UIImage imageNamed:@"increase_icon"];
        }
        //激活包
        else if ([_packageModel.type isEqualToString:@"Active"])
        {
            self.leftTitleLabel.text = @"激活额度包";
            self.leftImageView.image = [UIImage imageNamed:@"active_icon"];
            self.leftColorView.backgroundColor = [UIColor colorWithHexString:@"F0C95E"];
        }
        
        ZHAttributedLabelTool * amountTool = [[ZHAttributedLabelTool alloc] initWithText:[NSString stringWithFormat:@"¥%@",_packageModel.amount] font:[UIFont qg_mediumFontOfSize:25] color:[UIColor textColor3333]];
        [amountTool addFont:[UIFont qg_mediumFontOfSize:16] range:NSMakeRange(0, 1)];
        self.amountLabel.attributedText = [amountTool getResultString];
        self.descLabel.text = _packageModel.title;
        
        
        //改变按钮的状态
        //待领取
        if ([_packageModel.status isEqualToString:@"Waiting"]) {
            [self.receiveButton setGradientButtonIsClickEnabled:NO];
            [self.receiveButton setTitle:@"待领取" forState:UIControlStateNormal];
            self.usedButton.hidden = YES;
            self.receiveButton.hidden = NO;
        }
        //领取
        else if ([_packageModel.status isEqualToString:@"Normal"])
        {
            [self.receiveButton setGradientButtonIsClickEnabled:YES];
            [self.receiveButton setTitle:@"领取" forState:UIControlStateNormal];
            self.usedButton.hidden = YES;
            self.receiveButton.hidden = NO;
        }
        //已领取
        else if ([_packageModel.status isEqualToString:@"Used"])
        {
            self.usedButton.hidden = NO;
            self.receiveButton.hidden = YES;
        }
    }
}




- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
