//
//  QGQuotaBannerCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/9/25.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGQuotaBannerCell.h"
#import "QGBasicUITool.h"
#import "UIImageView+QGWebCache.h"
@interface QGQuotaBannerCell ()

@property (nonatomic, strong) UIImageView * bannerImageView;

@end

@implementation QGQuotaBannerCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        //banner
        self.bannerImageView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:nil];
        [self.bannerImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.bottom.inset(13);
            make.left.right.inset(20);
        }];
        
        
    }
    return self;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

- (void)setImageUrl:(NSString *)imageUrl
{
    if (_imageUrl != imageUrl) {
        _imageUrl = imageUrl;
        [self.bannerImageView setImageByNomalPlaceholderWithURLString:_imageUrl];
    }
}

+ (CGFloat)cellHeight
{
    return 13 * 2 + (MAINSCREEN_WIDTH - 20 * 2) * 70/335.0;
}


@end
