//
//  QGQuotaManagerModel.h
//  VirtualPayment
//
//  Created by 张博 on 2019/9/24.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGBaseModel.h"

NS_ASSUME_NONNULL_BEGIN
@class QGIncrementPackageModel,QGPageInfoModel,QGUserQuotaInfoModel,QGAdvantageInfoListModel;

@interface QGQuotaManagerModel : QGBaseModel

/**
* 是否授信成功获得额度
*/
@property (nonatomic, strong) NSString * hasReceivedQuota;

/// 额度管理的按钮 开关
@property (nonatomic, strong) NSString * showIncrementQuotaBtn;

/**
* hasReceivedQuota = true
* 提额包 分页及列表信息
*/
@property (nonatomic, strong) NSMutableArray <QGIncrementPackageModel *>* incrementPackageList;

/**
* hasReceivedQuota = true
* 提额包 分页及列表信息
*/
@property (nonatomic, strong) QGPageInfoModel * incrementPackagePageInfo;

/**
* hasReceivedQuota = true | false
* 用户的额度信息
*/
@property (nonatomic, strong) QGUserQuotaInfoModel * userQuotaInfo;

/**
* hasReceivedQuota = false
* 优势介绍
*/
@property (nonatomic, strong) NSArray <QGAdvantageInfoListModel *>* vccAdvantageInfoList;

/**
* hasReceivedQuota = false
* 授信最高额度
*/
@property (nonatomic, strong) NSString * creditMaxAmount;

/// 授信介绍网页
@property (nonatomic, strong) NSString * creditMaxAmountImageUrl;
@end




@interface QGIncrementPackageModel : QGBaseModel
/**
* 额度包ID
*/
@property (nonatomic, strong) NSString * packageId;

/**
* 可用日期
*/
@property (nonatomic, strong) NSString * activeDate;

/**
* 额度值
*/
@property (nonatomic, strong) NSString * amount;

/**
* 状态： Waiting 未到使用日期    Normal 可以使用   Used 已使用   Pasted 已过期
*/
@property (nonatomic, strong) NSString * status;

/**
* 别名
*/
@property (nonatomic, strong) NSString * title;

/**
* 额度包类型 ： Increase 提额包   Active 激活包
*/
@property (nonatomic, strong) NSString * type;

/**
* 有效期至
*/
@property (nonatomic, strong) NSString * validityDate;
@end





@interface QGPageInfoModel : QGBaseModel

/**
* 当前页数
*/
@property (nonatomic, strong) NSString * currentPage;

/**
* 每页条数
*/
@property (nonatomic, strong) NSString * pageSize;

/**
* 总数量
*/
@property (nonatomic, strong) NSString * totalCount;

/**
* 总页数
*/
@property (nonatomic, strong) NSString * totalPage;
@end



@interface QGUserQuotaInfoModel : QGBaseModel

/// 可用额度
@property (nonatomic, strong) NSString * canUseAmount;

/// 可用额度描述
@property (nonatomic, strong) NSString * canUseAmountDesc;

/// 可用额度标题
@property (nonatomic, strong) NSString * canUseAmountTitle;

/// 授信总额度
@property (nonatomic, strong) NSString * creditTotalAmount;

/// 授信总额度标题
@property (nonatomic, strong) NSString * creditTotalAmountTitle;

/// 零钱额度描述
@property (nonatomic, strong) NSString * pocketAmountDesc;

/// 零钱额度标题
@property (nonatomic, strong) NSString * pocketAmountTitle;

/// 零钱额度
@property (nonatomic, strong) NSString * pocketAmount;

/// 已用额度
@property (nonatomic, strong) NSString * usedAmount;

/// 已用额度标题
@property (nonatomic, strong) NSString * usedAmountTitle;

/// 待激活额度
@property (nonatomic, strong) NSString * waitingActivationAmount;

/// 待激活额度描述
@property (nonatomic, strong) NSString * waitingActivationAmountDesc;

/// 待激活额度标题
@property (nonatomic, strong) NSString * waitingActivationAmountTitle;

/// 是否展示待激活额度 当不展示待激活额度时，要展示提额攻略
@property (nonatomic, strong) NSString * showWaitingActivityQuota;
@end




@interface QGAdvantageInfoListModel : QGBaseModel
/**
* 微信支付
* 支付宝
* 零花钱
*/
@property (nonatomic, strong) NSString * advantageName;

/**
* 优势描述
*/
@property (nonatomic, strong) NSString * advantageDesc;

/**
* 图片
*/
@property (nonatomic, strong) NSString * imageUrl;

/// 背景色
@property (nonatomic, strong) NSString * backgroundColor;
@end

NS_ASSUME_NONNULL_END
