//
//  QGMallSearchTipItemView.m
//  VirtualPayment
//
//  Created by silicn on 2020/2/26.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallSearchTipItemView.h"
#import "QGBasicUITool.h"

@interface QGMallSearchTipItemView()

/// 图标
@property (nonatomic, strong)UIImageView *imageV;
/// 文字
@property (nonatomic, strong)UILabel *textLab;
/// 背景图
@property (nonatomic, strong) UIImageView *backImageV ;

@end

@implementation QGMallSearchTipItemView

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.backgroundColor = UIColor.whiteColor;
        self.backImageV = [UIView creatImageViewWithSuperView:self imageName:nil];
        _backImageV.contentMode = UIViewContentModeScaleToFill;
        [self.backImageV mas_makeConstraints:^(MASConstraintMaker *make) {
            make.edges.equalTo(self);
        }];
        
        self.imageV = [UIView creatImageViewWithSuperView:self imageName:nil];
        [self.imageV mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self).inset(12);
            make.centerY.equalTo(self);
            make.width.height.mas_equalTo(22);
        }];
        
        self.textLab = [UIView creatLabelWithSuperView:self title:nil titleFontSize:[UIFont qg_regularFontOfSize:14.0f] textColor:UIColor.textColor6666 alignment:NSTextAlignmentLeft];
        _textLab.numberOfLines = 2;
        
        [self.textLab mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.imageV.mas_right).offset(7);
            make.centerY.equalTo(self.imageV);
        }];
        
    }
    return self;
}

- (void)setIndex:(NSInteger)index
{
    if (_index != index) {
        _index = index;
        [self setContentWithIndex:index];
    }
}

- (void)setContentWithIndex:(NSInteger)index
{
    if (index == 1) {
        self.imageV.image = [UIImage imageNamed:@"mall_tip_section_logo_1"];
        self.backImageV.image = [UIImage imageNamed:@"mall_tip_section_back_1"];
        self.textLab.text = @"复制\n商品标题";
    }else if (index == 2){
        self.imageV.image = [UIImage imageNamed:@"mall_tip_section_logo_2"];
        self.backImageV.image = [UIImage imageNamed:@"mall_tip_section_back_2"];
        self.textLab.text = @"打开\nApp";
    }else if (index == 3){
        self.imageV.image = [UIImage imageNamed:@"mall_tip_section_logo_3"];
        self.backImageV.image = [UIImage imageNamed:@"mall_tip_section_back_3"];
        self.textLab.text = @"领券\n购买享返现";
    }
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
