//
//  QGMallSearchSectionView.h
//  VirtualPayment
//
//  Created by silicn on 2020/2/25.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "QGBaseModel.h"

NS_ASSUME_NONNULL_BEGIN


#pragma mark - Model

@interface QGMallSearchSectionItem :QGBaseModel

/// 标题
@property (nonatomic, copy)NSString *title;
/// 是否能排序
@property (nonatomic, assign) BOOL sortAble;
/// 排序是先下后上
@property (nonatomic, assign) BOOL downToUp;

@end

#pragma mark - SectionView内部的小组件可点击

typedef NS_ENUM(NSInteger,QGMallSearchSectionSortType)
{
    QGMallSearchSectionSortTypeNone = 0, /// 未选择
    QGMallSearchSectionSortTypeAscending, /// 升序
    QGMallSearchSectionSortTypeDescending /// 降序
};

@class QGMallSearchSectionItemView;

typedef void(^QGMallSearchSectionItemTouchedBlock)(QGMallSearchSectionItemView *item);

@interface QGMallSearchSectionItemView : UIView

- (instancetype)initWithModel:(QGMallSearchSectionItem *)item;

/// 当前视图的排序类型
@property (nonatomic, assign)QGMallSearchSectionSortType sortType;
/// 当前视图是否被选择
@property (nonatomic, assign) BOOL select ;

@property (nonatomic, copy) QGMallSearchSectionItemTouchedBlock touchBlock ;



@end

#pragma mark - SectionView

typedef void(^QGMallSearchSectionTouchedIndexBlock)(NSInteger index,QGMallSearchSectionSortType type);

typedef void (^QGMallSectionCellLayoutBlock)(BOOL isBox);

typedef void(^QGMallSectionSwitchOnBlock)(BOOL open);

@interface QGMallSearchSectionView : UIView

@property (nonatomic, assign)BOOL isBox;

/// 是否可以改变布局
@property (nonatomic, assign)BOOL layoutEnable;

/// 可排序的项目
@property (nonatomic, strong)NSArray <QGMallSearchSectionItem *> *items;

/// 是否有优惠券开关, 默认没有hasCouponSwitch = NO
@property (nonatomic, assign) BOOL hasCouponSwitch ;

/// 初始化头部排序栏目项
/// @param items 栏目项
- (id)initWithItems:(NSArray <QGMallSearchSectionItem *>*)items;

/// 初始化头部排序栏目项
/// @param items 栏目项
/// @param enable 能否改变布局方式,垂直或者网格
- (id)initWithItems:(NSArray <QGMallSearchSectionItem *>*)items layoutEnable:(BOOL)enable;

@property (nonatomic, copy) QGMallSearchSectionTouchedIndexBlock touchItemBlock ;

@property (nonatomic, copy) QGMallSectionCellLayoutBlock cellLayoutBlock;

@property (nonatomic, copy) QGMallSectionSwitchOnBlock switchBlock;

@end

NS_ASSUME_NONNULL_END
