//
//  QGMallSearchHistoryLeftFlowLayout.m
//  VirtualPayment
//
//  Created by silicn on 2020/2/26.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallSearchHistoryLeftFlowLayout.h"

@interface QGMallSearchHistoryLeftFlowLayout ()



@end

@implementation QGMallSearchHistoryLeftFlowLayout

- (void)prepareLayout
{
    [super prepareLayout];
    self.minimumInteritemSpacing = 6;
    self.minimumLineSpacing = 10;
    self.estimatedItemSize = CGSizeMake(100, 30);
    self.sectionInset = UIEdgeInsetsMake(5, 15, 5, 15);
    
}

- (NSArray<UICollectionViewLayoutAttributes *> *)layoutAttributesForElementsInRect:(CGRect)rect{

    NSArray *array = [super layoutAttributesForElementsInRect:rect];
    for (int i = 0; i < array.count; i ++) {
        if (i != array.count - 1){
            UICollectionViewLayoutAttributes *currentAtt = array[i];
            UICollectionViewLayoutAttributes *nextAtt = array[i+1];
            if (CGRectGetMinY(currentAtt.frame) == CGRectGetMinY(nextAtt.frame)) {
                if ((CGRectGetMinX(nextAtt.frame) - CGRectGetMaxX(currentAtt.frame)) > self.minimumInteritemSpacing){
                    CGRect frame = nextAtt.frame;
                    CGFloat x = CGRectGetMaxX(currentAtt.frame) + self.minimumInteritemSpacing;
                    frame = CGRectMake(x, CGRectGetMinY(frame), frame.size.width, frame.size.height);
                    nextAtt.frame = frame;
                }
            }else{
                //下一列自动居左  避免被居中
                CGRect frame = nextAtt.frame;
                frame = CGRectMake(self.sectionInset.left, frame.origin.y, frame.size.width, frame.size.height);
                nextAtt.frame = frame;
            }
            if (i == 0){
                //第一个列 避免被居中
                CGRect frame = currentAtt.frame;
                frame = CGRectMake(self.sectionInset.left, frame.origin.y, frame.size.width, frame.size.height);
                currentAtt.frame = frame;
            }
        }
        else if (i == 0){
            //第一列 避免被居中 如果有分区头视图  可注释该判断  添加判断是否为头视图
           //因为该layoutAttributes数组包含 头视图，如添加头视图，请在前面添加判断
            UICollectionViewLayoutAttributes *currentAtt = array[i];
            CGRect frame = currentAtt.frame;
            frame = CGRectMake(self.sectionInset.left, frame.origin.y, frame.size.width, frame.size.height);
            currentAtt.frame = frame;
        }
    }
    return array;
}

- (CGSize)collectionViewContentSize {
    return CGSizeMake(self.collectionView.frame.size.width, self.collectionView.frame.size.height + 10);
}

@end
