//
//  QGPreferentialMallViewController.m
//  VirtualPayment
//
//  Created by 张博 on 2020/2/24.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGPreferentialMallViewController.h"
#import "QGBestSellersViewController.h"


//View
#import "QGDefaultView.h"
#import "QGMallHomepageBannerCell.h"
#import "QGMallHomepageNavigationCell.h"
#import "QGMallHomepageQuickEntryCell.h"
#import "QGMallVerticalGoodsCell.h"
#import "QGMallSpaceCell.h"
#import "QGMallOperateHeaderCell.h"
#import "QGMallOperateStyleInfoCell.h"
#import "QGMallOperateBannerCell.h"
#import "QGMallOperateStyleImgCell.h"
#import "QGAuthAlertView.h"



//Tool
#import "QGMallRequestApi.h"
#import "QGApplicationOpenURL.h"
#import "QGActivityPopManager.h"
#import "QGUserCenterRequestApi.h"
#import "QGBaiChuanManager.h"


//Model
#import "QGMallHomepageModel.h"
#import "QGAppCoreModelClickEvent.h"

//#import <CoreLocation/CoreLocation.h>
#import <AdSupport/AdSupport.h>

#import "QGLocationManager.h"



@interface QGPreferentialMallViewController ()

/// 数据源
@property (nonatomic, strong) QGMallHomepageModel * dataSourceModel;

/// 商品数组
@property (nonatomic, strong) NSMutableArray * goodsArray;

/// 消息按钮
@property (nonatomic, strong) UIButton * messageButton;

/// 是否是第一次进入,第一次进入先不获取地理位置,第二次才能获取地理位置
@property (nonatomic, assign)BOOL canAppearLocation;

@end

@implementation QGPreferentialMallViewController

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];

    [self requestLocation];
    /// 控制出现时机
    if (!self.canAppearLocation) {
        self.canAppearLocation = YES;
    }
   
}

- (void)requestLocation
{
    if (self.canAppearLocation && QGLocationManager.shareManager.status == QGLocationStatusNotDetermined) {
        [QGLocationManager.shareManager requestLocationAuthorizationStatus:NULL];
    }
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self initNormalUI];
    [self initNormalData];
    [self.tableView beginRefresh];
}


#pragma mark - 初始化基础UI和数据
- (void)initNormalUI
{
    self.isBelowNavBar = YES;
    @weakify(self);
    //添加下拉刷新
    QGRefreshNomalHeader * headerView = [self.tableView addRefreshWithHandle:^(BOOL isHeaderRefresh) {
        @strongify(self);
        [self requestDataWithIsHeaderRefresh:isHeaderRefresh];
    }];
    headerView.themeBgColor = [UIColor yyMainThemeColor];
    headerView.tintColor = [UIColor whiteColor];
}



- (void)initNormalData
{
    self.tableView.pageNum = 1;
    self.tableView.pageCount = 10;
    self.dataSourceModel = [[QGMallHomepageModel alloc] init];
}



#pragma mark - Request

/// 请求数据
/// @param isHeaderRefresh YES：下拉刷新 NO：上拉加载
- (void)requestDataWithIsHeaderRefresh:(BOOL)isHeaderRefresh
{
    //下拉刷新
    if (isHeaderRefresh) {
        self.tableView.pageNum = 1;
    }
    NSString * urlString = [QGMallRequestApi urlWithIndex:QGMallRequestServerMethodHomepage];
//    urlString = @"http://yapi.quantgroups.com/mock/305/vcc/app/mall/index";
    
    //页码信息
    NSMutableDictionary * infoDic = [NSMutableDictionary dictionaryWithCapacity:0];
    [infoDic setObject:@(self.tableView.pageNum) forKey:@"currentPageNo"];
    [infoDic setObject:@(self.tableView.pageCount) forKey:@"pageSize"];
    
    NSMutableDictionary *headers = [NSMutableDictionary dictionaryWithCapacity:3];
    [headers setObject:@"MD5" forKey:@"deviceEncrypt"];
    NSString *idfa = [[ASIdentifierManager sharedManager] advertisingIdentifier].UUIDString;
    if (idfa) {
        [headers setObject:[idfa md5] forKey:@"deviceValue"];
    }
    [headers setObject:@"IDFA" forKey:@"deviceType"];
    
    [[QGTalosNetwork shareManager] GET:urlString headers:headers parameters:infoDic success:^(id  _Nonnull responseObject) {
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSArray * dataArray = responseObject[@"data"][@"contents"];
            BOOL hasNext = [responseObject[@"data"][@"hasNext"] boolValue];
            //请求结果符合类型进入成功处理
            if ([dataArray isKindOfClass:[NSArray class]]) {
                 [self requestSuccessWithDataArray:dataArray pageNum:self.tableView.pageNum];
            }
            //结束刷新
            [self.tableView endRefreshWithBusinessSuccess:YES hasNext:hasNext];
        }
        else
        {
            [self.tableView endRefreshWithBusinessSuccess:NO hasNext:NO];
            //展示错误页面或者提示
            [self networkErrorPageWithPageNum:self.tableView.pageNum responseObject:responseObject error:nil];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [self.tableView endRefreshWithBusinessSuccess:NO hasNext:NO];
        //展示错误页面或者提示
        [self networkErrorPageWithPageNum:self.tableView.pageNum responseObject:nil error:error];
    }];
    
    
}


/// 请求成功回调
/// @param dataArray 请求结果
/// @param pageNum 页码信息
- (void)requestSuccessWithDataArray:(NSArray *)dataArray pageNum:(NSInteger)pageNum
{
    //第一页需要清空历史数据源
    if (pageNum == 1) {
        self.dataSourceModel.tempArray = [NSMutableArray arrayWithCapacity:0];
        self.goodsArray = [NSMutableArray arrayWithCapacity:0];
    }
    
    //根据模板取出数据
    for (NSDictionary * tempDic in dataArray) {
        //1：顶部banner、2：快捷入口、3：引导条、4运营区头、5专区广告、6专区栏目-样式1、7专区栏目-样式2、8边距、99：商品列表
        NSInteger type = [tempDic[@"type"] integerValue];
        switch (type) {
                //banner
            case 1:
            {
                QGMallBannerTempModel * bannerTemp = [QGMallBannerTempModel yy_modelWithDictionary:tempDic];
                if (bannerTemp.topBannerList.count > 0) {
                    [self.dataSourceModel.tempArray addObject:bannerTemp];
                }
            }
                break;
                //快捷入口
            case 2:
            {
                QGMallQuickEntryTempModel * quickEntryModel = [QGMallQuickEntryTempModel yy_modelWithDictionary:tempDic];
                if (quickEntryModel.quickEntryList.count > 0) {
                    [self.dataSourceModel.tempArray addObject:quickEntryModel];
                }
            }
                break;
                //引导条
            case 3:
            {
                QGMallNavigationTempModel * navigationModel = [QGMallNavigationTempModel yy_modelWithDictionary:tempDic];
                if (navigationModel.navigationList.count > 0) {
                    [self.dataSourceModel.tempArray addObject:navigationModel];
                }
            }
                break;
                //运营区头
            case 4:
            {
                QGOperateHeaderModel * headerModel = [QGOperateHeaderModel yy_modelWithDictionary:tempDic];
                if (![NSString isEmpty:headerModel.img]) {
                    [self.dataSourceModel.tempArray addObject:headerModel];
                }
            }
                break;
                //专区广告
            case 5:
            {
                QGOperateBannerListModel * bannerModel = [QGOperateBannerListModel yy_modelWithDictionary:tempDic];
                if (bannerModel.headerBannerList.count > 0) {
                    [self.dataSourceModel.tempArray addObject:bannerModel];
                }
            }
                break;
                //专区栏目 样式1
            case 6:
            {
                QGOperateStyleInfoModel * infoModel = [QGOperateStyleInfoModel yy_modelWithDictionary:tempDic];
                if (infoModel.adBannerList.count > 0) {
                    [self.dataSourceModel.tempArray addObject:infoModel];
                }
            }
                break;
                //专区栏目 样式2
            case 7:
            {
                QGOperateStyleImgListModel * imgModel = [QGOperateStyleImgListModel yy_modelWithDictionary:tempDic];
                if (imgModel.partBannerList.count > 0) {
                    [self.dataSourceModel.tempArray addObject:imgModel];
                }
            }
                break;
                //间隔
            case 8:
            {
                QGSpaceModel * spaceModel = [QGSpaceModel yy_modelWithDictionary:tempDic];
                if (spaceModel.height.floatValue > 0) {
                    [self.dataSourceModel.tempArray addObject:spaceModel];
                }
            }
                break;
                //商品列表
            case 99:
            {
                //商品数据特殊处理
                QGMallGoodsTempModel * goodsModel = [QGMallGoodsTempModel yy_modelWithDictionary:tempDic];
                [self.goodsArray addObject:goodsModel.goodsInfo];
            }
                break;
                
            default:
                break;
        }
        
    }
    
    [self.tableView reloadData];
}

/// 网络错误页展示
/// @param pageNum 根据页码区分展示样式
/// @param responseObject 请求成功业务处理失败回调
/// @param error 请求失败错误信息
- (void)networkErrorPageWithPageNum:(NSInteger)pageNum responseObject:(NSDictionary *)responseObject error:(NSError *)error
{
    //如果是下拉刷新 && 之前没有数据，需要显示网络错误页面
    if (pageNum == 1 && self.dataSourceModel.tempArray.count == 0) {
        @weakify(self);
        QGDefaultView * view = [QGDefaultView defaultViewShowWithSuperView:self.view reloadBlock:^{
            @strongify(self);
            //开始下拉刷新
            [self.tableView beginRefresh];
        }];
        view.viewType = QGDefaultViewTypeBadNetwork;
    }
    //如果是请求成功业务处理失败，则弹出提示
    else if (responseObject)
    {
        [QGHUDManager showHudWithError:responseObject];
    }
    else if (error)
    {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
    }
}

#pragma mark - UITableViewDataSource

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    //运营模板 + 商品列表
    return 2;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    NSInteger numberOfRows = 0;
    switch (section) {
             //运营模板
        case 0:
            numberOfRows = self.dataSourceModel.tempArray.count;
            break;
             //商品列表
        case 1:
            numberOfRows = ceil(self.goodsArray.count/2.0);
        break;
            
        default:
            break;
    }
    return numberOfRows;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    @weakify(self);
    UITableViewCell * cell;
    
    //运营模板
    if (indexPath.section == 0) {
        QGMallTempBaseModel * tempModel = self.dataSourceModel.tempArray[indexPath.row];
        //1：顶部banner、2：快捷入口、3：引导条、4运营区头、5专区广告、6专区栏目-样式1、7专区栏目-样式2、8边距、99：商品列表
        switch (tempModel.type.integerValue) {
            //banner
            case 1:
            {
               QGMallHomepageBannerCell * bannerCell = (QGMallHomepageBannerCell *)[self getCellFromClassName:NSStringFromClass([QGMallHomepageBannerCell class]) dequeueTableView:tableView];
               bannerCell.bannerTempModel = (QGMallBannerTempModel *)tempModel;
               cell = bannerCell;
               
               //点击事件
               bannerCell.bannerClickBlock = ^(NSInteger index, QGMallBannerModel * _Nonnull bannerModel) {
                   @strongify(self);
                   [self bannerClickBlock:index bannerModel:bannerModel];
               };
               
            }
               break;
            //快捷入口
            case 2:
            {
               QGMallHomepageQuickEntryCell * quickEntryCell = (QGMallHomepageQuickEntryCell *)[self getCellFromClassName:NSStringFromClass([QGMallHomepageQuickEntryCell class]) dequeueTableView:tableView];
               quickEntryCell.tempModel = (QGMallQuickEntryTempModel *)tempModel;
               cell = quickEntryCell;
               
               //点击事件
               quickEntryCell.quickEntryClickBlock = ^(NSInteger index, QGQuickEntryModel * _Nonnull quickEntrymodel) {
                   @strongify(self);
                   [self quickEntryClickBlock:index quickEntryModel:quickEntrymodel];
               };
            }
               break;
            //引导条
            case 3:
            {
               QGMallHomepageNavigationCell * navigationCell = (QGMallHomepageNavigationCell *)[self getCellFromClassName:NSStringFromClass([QGMallHomepageNavigationCell class]) dequeueTableView:tableView];
               navigationCell.tempModel = (QGMallNavigationTempModel *)tempModel;
               cell = navigationCell;
               
               //点击事件
               navigationCell.navigationClickBlock = ^(NSInteger index, QGMallNavigationModel * _Nonnull navigationModel) {
                   @strongify(self);
                   [self navigationClickBlock:index navigationModel:navigationModel];
               };
            }
               break;
                //运营区头
            case 4:
            {
                QGMallOperateHeaderCell * headerCell = (QGMallOperateHeaderCell *)[self getCellFromClassName:NSStringFromClass([QGMallOperateHeaderCell class]) dequeueTableView:tableView];
                headerCell.headerModel = (QGOperateHeaderModel *)tempModel;
                cell = headerCell;
                
            }
                break;
                //专区广告banner
            case 5:
            {
                QGMallOperateBannerCell * bannerCell = (QGMallOperateBannerCell *)[self getCellFromClassName:NSStringFromClass([QGMallOperateBannerCell class]) dequeueTableView:tableView];
                bannerCell.bannerListModel = (QGOperateBannerListModel *)tempModel;
                //运营banner广告
                bannerCell.bannerClickBlock = ^(NSInteger index, QGOperateBannerModel * _Nonnull bannerModel) {
                    @strongify(self);
                    [self operateBannerClick:index bannerModel:bannerModel];
                };
                cell = bannerCell;
            }
                break;
                //专区栏目运营位1
            case 6:
            {
                QGMallOperateStyleInfoCell * infoCell = (QGMallOperateStyleInfoCell *)[self getCellFromClassName:NSStringFromClass([QGMallOperateStyleInfoCell class]) dequeueTableView:tableView];
                infoCell.infoListModel = (QGOperateStyleInfoModel *)tempModel;
                cell = infoCell;
                
                //运营位1点击事件
                infoCell.clickBlock = ^(NSInteger index, QGOperateInfoModel * _Nonnull infoModel) {
                    @strongify(self);
                    [self operateInfoClick:index infoModel:infoModel];
                };
            }
                break;
                //专区栏目运营位2
            case 7:
            {
                QGMallOperateStyleImgCell * imgCell = (QGMallOperateStyleImgCell *)[self getCellFromClassName:NSStringFromClass([QGMallOperateStyleImgCell class]) dequeueTableView:tableView];
                imgCell.listModel = (QGOperateStyleImgListModel *)tempModel;
                cell = imgCell;
                
                imgCell.clickBlock = ^(NSInteger index, QGOperateStyleImgModel * _Nonnull infoModel) {
                    @strongify(self);
                    [self operateImgClick:index infoModel:infoModel];
                };
            }
                break;
                //间隔
            case 8:
            {
                QGMallSpaceCell * spaceCell = (QGMallSpaceCell *)[self getCellFromClassName:NSStringFromClass([QGMallSpaceCell class]) dequeueTableView:tableView];
                spaceCell.spaceModel = (QGSpaceModel *)tempModel;
                cell = spaceCell;
            }
                break;
           default:
               break;
        }
    }
    //商品列表
    else if (indexPath.section == 1)
    {
        QGMallVerticalGoodsCell * goodsCell = (QGMallVerticalGoodsCell *)[self getCellFromClassName:NSStringFromClass([QGMallVerticalGoodsCell class]) dequeueTableView:tableView];
        cell = goodsCell;
        
        NSInteger location = indexPath.row * 2;
        NSInteger length = 2;
        //可能会出现最后一行只有一个的情况
        if (location + length > self.goodsArray.count) {
            length = 1;
        }
        goodsCell.goodsList = [self.goodsArray subarrayWithRange:NSMakeRange(location, length)];
        
        @weakify(self);
        goodsCell.clickBlock = ^(QGMallBaseGoodsModel * _Nonnull goodsModel) {
            @strongify(self);
            [self recommendGoodsClick:goodsModel];
        };
    }
    
    return cell ? cell : [UITableViewCell new];
}

#pragma mark - UITableViewDelegate

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CGFloat heightForRow = 0;
    //模块列表
    if (indexPath.section == 0) {
        QGMallTempBaseModel * tempModel = self.dataSourceModel.tempArray[indexPath.row];
        //1：顶部banner、2：快捷入口、3：引导条、4运营区头、5专区广告、6专区栏目-样式1、7专区栏目-样式2、8边距、99：商品列表
        switch (tempModel.type.integerValue) {
                //banner
            case 1:
                heightForRow = [QGMallHomepageBannerCell cellHeight];
                break;
                //快捷入口
            case 2:
            {
                QGMallQuickEntryTempModel * quickEntryModel = (QGMallQuickEntryTempModel *)tempModel;
                heightForRow = quickEntryModel.cellHeight;
            }
                break;
                //引导条
            case 3:
                heightForRow = 17 + 10;
                break;
                //运营区头
            case 4:
            {
                QGOperateHeaderModel * headerModel = (QGOperateHeaderModel *)tempModel;
                heightForRow = headerModel.cellHeight;
            }
                break;
                //专区广告
            case 5:
            {
                QGOperateBannerListModel * bannerModel = (QGOperateBannerListModel *)tempModel;
                heightForRow = bannerModel.cellHeight;
            }
                break;
                //专区栏目-样式1
            case 6:
            {
                QGOperateStyleInfoModel * infoModel = (QGOperateStyleInfoModel *)tempModel;
                heightForRow = infoModel.cellHeight;
            }
                break;
                //专区栏目-样式2
            case 7:
            {
                QGOperateStyleImgListModel * imgModel = (QGOperateStyleImgListModel *)tempModel;
                heightForRow = imgModel.cellHeight;
            }
                break;
                //边距
            case 8:
            {
                QGSpaceModel * spaceModel = (QGSpaceModel *)tempModel;
                heightForRow = spaceModel.height.floatValue;
            }
                break;
            default:
                break;
        }
    }
    //商品列表
    else if (indexPath.section == 1)
    {
        NSInteger location = indexPath.row * 2;
        if (self.goodsArray.count > location) {
            QGMallBaseGoodsModel * goodsModel = self.goodsArray[location];
            heightForRow = goodsModel.verticalCellSize.height;
        }
    }
    return heightForRow;
}




#pragma mark - Action

/// 推荐商品点击事件
- (void)recommendGoodsClick:(QGMallBaseGoodsModel *)goodsModel
{
    //数据埋点
    QGAppCoreModelClickEvent * event = [QGAppCoreModelClickEvent acmcEventWithPage:self.name ? self.name : @"省钱页" path:@"商品列表" name:@"浏览商品列表" detail_name:goodsModel.goodsId acmc_model_other:goodsModel.goodsName];
    [QGAnalyticsService analyticsTrackWithEvent:event];

    [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGMallGoodsDetailViewController) parameters:@{@"goodsId":goodsModel.goodsId} handlerBlock:nil];
}


/// banner点击
/// @param index 点击索引
- (void)bannerClickBlock:(NSInteger)index bannerModel:(QGMallBannerModel *)bannerModel
{
    //数据埋点
    QGAppCoreModelClickEvent * event = [QGAppCoreModelClickEvent acmcEventWithPage:@"省钱页" path:@"banner" name:[NSString stringWithFormat:@"Banner_%ld",index + 1] detail_name:bannerModel.name acmc_model_other:bannerModel.jumpUrl];
    [QGAnalyticsService analyticsTrackWithEvent:event];
    
    [self jumpWithOpenUrlModel:bannerModel];
}


/// 快捷入口点击
/// @param index 点击索引
- (void)quickEntryClickBlock:(NSInteger)index quickEntryModel:(QGQuickEntryModel *)quickEntryModel
{
    
    //数据埋点
    QGAppCoreModelClickEvent * event = [QGAppCoreModelClickEvent acmcEventWithPage:@"省钱页" path:@"快捷入口" name:[NSString stringWithFormat:@"QuickEntry_%ld",index + 1] detail_name:quickEntryModel.name acmc_model_other:quickEntryModel.jumpUrl];
    [QGAnalyticsService analyticsTrackWithEvent:event];
    
    [self jumpWithOpenUrlModel:quickEntryModel];
}

/// 引导条入口点击
/// @param index 点击索引
- (void)navigationClickBlock:(NSInteger)index navigationModel:(QGMallNavigationModel *)navigationModel
{
    [self jumpWithOpenUrlModel:navigationModel];
}


/// 运营位banner点击事件
- (void)operateBannerClick:(NSInteger)index bannerModel:(QGOperateBannerModel *)bannerModel
{
    //埋点
    QGAppCoreModelClickEvent * event = [QGAppCoreModelClickEvent acmcEventWithPage:@"省钱页" path:@"运营专辑模块" name:@"广告位" detail_name:bannerModel.name acmc_model_other:bannerModel.jumpUrl];
    [QGAnalyticsService analyticsTrackWithEvent:event];
    
    [self jumpWithOpenUrlModel:bannerModel];
}


/// 运营位1点击事件
- (void)operateInfoClick:(NSInteger)index infoModel:(QGOperateInfoModel *)infoModel
{
    //埋点
    QGAppCoreModelClickEvent * event = [QGAppCoreModelClickEvent acmcEventWithPage:@"省钱页" path:@"运营专辑模块" name:@"运营位1" detail_name:infoModel.title acmc_model_other:infoModel.jumpUrl];
    [QGAnalyticsService analyticsTrackWithEvent:event];
    
    [self jumpWithOpenUrlModel:infoModel];
}

/// 运营位2点击事件
- (void)operateImgClick:(NSInteger)index infoModel:(QGOperateStyleImgModel *)infoModel
{
    //埋点
    QGAppCoreModelClickEvent * event = [QGAppCoreModelClickEvent acmcEventWithPage:@"省钱页" path:@"运营专辑模块" name:@"运营位2" detail_name:infoModel.name acmc_model_other:infoModel.jumpUrl];
    [QGAnalyticsService analyticsTrackWithEvent:event];
    
    [self jumpWithOpenUrlModel:infoModel];
}




/// 跳转到指定链接
/// @param openUrlModel 基础模型类
- (void)jumpWithOpenUrlModel:(QGMallBaseOpenUrlModel *)openUrlModel
{
    
//    [QGBaiChuanManager.shareInstance openURL:@"https://oauth.taobao.com/authorize?response_type=code&client_id=28360650&redirect_uri=https://talos-vcc.liangkebang.net/ex/vcc/taobao/auth/notify&state=1212&view=wap" taokePid:@"" navigationController:self.navigationController];
//    return;
    
    //没有链接不跳转
    if ([NSString isEmpty:openUrlModel.jumpUrl]) {
        return;
    }
    
    //先检测登录
    if (openUrlModel.needLogin.boolValue && ![QGUserInfo isLogin]) {
        [self showLoginViewControllerCompletion:nil];
        return;
    }
    
    //福禄的单独处理
    if (openUrlModel.authType.integerValue == 6) {
        
        //账号特殊处理
        if ([[QGUserInfo sharedUserInfo].userName isEqualToString:@"17600206736"]) {
            NSString * openUrl = @"vcczxh://mall/search/result?search=话费充值";
            [QGApplicationOpenURL handleAllSupportUrl:openUrl];
        }
        else
        {
            [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGFuLuWebViewController) parameters:@{@"urlString":openUrlModel.jumpUrl} handlerBlock:nil];
        }
        
    }
    //需要用百川打开的
    else if (openUrlModel.openSdk.integerValue == 1)
    {
        //内部检测是否授权过
        [[QGBaiChuanManager shareInstance] openURL:openUrlModel.jumpUrl taokePid:openUrlModel.tbkPid navigationController:self.navigationController];
    }
    //剩余的通过通用协议跳转
    else
    {
        [QGApplicationOpenURL handleAllSupportUrl:openUrlModel.jumpUrl];
    }
    
}






@end
