//
//  QGMallOperateStyleInfoCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/27.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallOperateStyleInfoCell.h"
#import "QGBasicUITool.h"
#import "UIImageView+QGWebCache.h"

@interface QGMallOperateStyleInfoCell () <UICollectionViewDelegate, UICollectionViewDataSource>

/// 展示容器
@property (nonatomic, strong) UICollectionView * collectionView;

@end

@implementation QGMallOperateStyleInfoCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        UICollectionViewFlowLayout * layout = [[UICollectionViewFlowLayout alloc] init];
        layout.minimumLineSpacing = 0;
        layout.minimumInteritemSpacing = 0;
        
        //承载视图
        self.collectionView = [[UICollectionView alloc] initWithFrame:CGRectZero collectionViewLayout:layout];
        self.collectionView.delegate = self;
        self.collectionView.dataSource = self;
        self.collectionView.showsVerticalScrollIndicator = NO;
        self.collectionView.showsHorizontalScrollIndicator = NO;
        self.collectionView.backgroundColor = [UIColor whiteColor];
        [self.contentView addSubview:self.collectionView];
        
        self.collectionView.layer.cornerRadius = 6;
        self.collectionView.clipsToBounds = YES;
        //约束
        [self.collectionView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(15);
            make.top.inset(5);
            make.bottom.inset(0);
        }];
        //注册cell
        [self.collectionView registerClass:[QGMallStyleInfoCollectionCell class] forCellWithReuseIdentifier:NSStringFromClass([QGMallStyleInfoCollectionCell class])];
    }
    return self;
}


- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return MIN(2, self.infoListModel.adBannerList.count);
}

- (__kindof UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    QGMallStyleInfoCollectionCell * cell = (QGMallStyleInfoCollectionCell *)[collectionView dequeueReusableCellWithReuseIdentifier:NSStringFromClass([QGMallStyleInfoCollectionCell class]) forIndexPath:indexPath];
    cell.infoModel = self.infoListModel.adBannerList[indexPath.row];
    return cell;
}

- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout sizeForItemAtIndexPath:(NSIndexPath *)indexPath
{
    QGOperateInfoModel * infoModel = self.infoListModel.adBannerList[indexPath.row];
    return infoModel.cellSize;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    QGOperateInfoModel * infoModel = self.infoListModel.adBannerList[indexPath.row];
    if (self.clickBlock) {
        self.clickBlock(indexPath.row, infoModel);
    }
}


- (void)setInfoListModel:(QGOperateStyleInfoModel *)infoListModel
{
    if (_infoListModel != infoListModel) {
        _infoListModel = infoListModel;
        [self.collectionView reloadData];
        
        self.contentView.backgroundColor = [UIColor colorWithHexString:_infoListModel.backgroundColor];
    }
}

@end



@interface QGMallStyleInfoCollectionCell ()

/// 标题
@property (nonatomic, strong) UILabel * titleLabel;

/// 副标题
@property (nonatomic, strong) UILabel * subTitleLabel;

/// 标签
@property (nonatomic, strong) UILabel * tagLabel;

/// 图片
@property (nonatomic, strong) UIImageView * imgView;

@end

@implementation QGMallStyleInfoCollectionCell

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        //标题
        self.titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_mediumFontOfSize:14] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(10);
            make.top.inset(12);
            make.height.mas_equalTo(20);
        }];
        
        //标签
        self.tagLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_regularFontOfSize:10] textColor:[UIColor whiteColor] alignment:NSTextAlignmentCenter];
        self.tagLabel.backgroundColor = [UIColor yyMainThemeColor];
        self.tagLabel.layer.cornerRadius = 7;
        self.tagLabel.clipsToBounds = YES;
        [self.tagLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.height.mas_equalTo(14);
            make.left.mas_equalTo(self.titleLabel.mas_right).offset(3);
            make.centerY.mas_equalTo(self.titleLabel);
        }];
        
        
        //副标题
        self.subTitleLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_regularFontOfSize:12] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        [self.subTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(10);
            make.top.mas_equalTo(self.titleLabel.mas_bottom);
            make.height.mas_equalTo(17);
        }];
        
        //图片
        self.imgView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:nil];
        [self.imgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(10);
            make.right.inset(0);
            make.bottom.inset(11);
            make.top.mas_equalTo(self.subTitleLabel.mas_bottom).offset(10);
        }];
        
    }
    return self;
}


- (void)setInfoModel:(QGOperateInfoModel *)infoModel
{
    if (_infoModel != infoModel) {
        _infoModel = infoModel;
        self.titleLabel.text = _infoModel.title;
        self.subTitleLabel.text = _infoModel.subTitle;
        self.tagLabel.text = [NSString stringWithFormat:@"%@>   ",_infoModel.tags];
        self.tagLabel.hidden = [NSString isEmpty:_infoModel.tags];
        [self.imgView setMallImageByNomalPlaceholderWithURLString:_infoModel.icon];
        
    }
}

@end
