//
//  QGMallOperateStyleImgCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/30.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallOperateStyleImgCell.h"
#import "QGBasicUITool.h"
#import "UIImageView+QGWebCache.h"

@interface QGMallOperateStyleImgCell ()<UICollectionViewDelegate, UICollectionViewDataSource>
/// 展示容器
@property (nonatomic, strong) UICollectionView * collectionView;
@end

@implementation QGMallOperateStyleImgCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        UICollectionViewFlowLayout * layout = [[UICollectionViewFlowLayout alloc] init];
        layout.minimumLineSpacing = 5;
        layout.minimumInteritemSpacing = 0;
        
        //承载视图
        self.collectionView = [[UICollectionView alloc] initWithFrame:CGRectZero collectionViewLayout:layout];
        self.collectionView.delegate = self;
        self.collectionView.dataSource = self;
        self.collectionView.showsVerticalScrollIndicator = NO;
        self.collectionView.showsHorizontalScrollIndicator = NO;
        self.collectionView.backgroundColor = [UIColor whiteColor];
        [self.contentView addSubview:self.collectionView];
        
        self.collectionView.layer.cornerRadius = 6;
        self.collectionView.clipsToBounds = YES;
        //约束
        [self.collectionView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(15);
            make.top.inset(5);
            make.bottom.inset(0);
        }];
        
        //注册cell
        [self.collectionView registerClass:[QGMallStyleImgCollectionCell class] forCellWithReuseIdentifier:NSStringFromClass([QGMallStyleImgCollectionCell class])];
    }
    return self;
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return MIN(2, self.listModel.partBannerList.count);
}

- (__kindof UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    QGMallStyleImgCollectionCell * cell = (QGMallStyleImgCollectionCell *)[collectionView dequeueReusableCellWithReuseIdentifier:NSStringFromClass([QGMallStyleImgCollectionCell class]) forIndexPath:indexPath];
    QGOperateStyleImgModel * imgModel = self.listModel.partBannerList[indexPath.row];
    [cell.imgView setMallImageByNomalPlaceholderWithURLString:imgModel.icon];
    return cell;
}


- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    QGOperateStyleImgModel * imgModel = self.listModel.partBannerList[indexPath.row];
    if (self.clickBlock) {
        self.clickBlock(indexPath.row, imgModel);
    }
}

- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout sizeForItemAtIndexPath:(NSIndexPath *)indexPath
{
    QGOperateStyleImgModel * imgModel = self.listModel.partBannerList[indexPath.row];
    return imgModel.cellSize;
}


- (void)setListModel:(QGOperateStyleImgListModel *)listModel
{
    if (_listModel != listModel) {
        _listModel = listModel;
        [self.collectionView reloadData];
        self.contentView.backgroundColor = [UIColor colorWithHexString:listModel.backgroundColor];
        self.collectionView.backgroundColor = [UIColor colorWithHexString:listModel.backgroundColor];
    }
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end





@implementation QGMallStyleImgCollectionCell

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        //图片
        self.imgView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:nil];
        [self.imgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.top.right.bottom.inset(0);
        }];
        self.imgView.layer.cornerRadius = 6;
        self.imgView.clipsToBounds = YES;
    }
    return self;
}


@end
