//
//  QGMallOperateHeaderCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/27.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallOperateHeaderCell.h"
#import "QGBasicUITool.h"
#import "UIImageView+QGWebCache.h"
@interface QGMallOperateHeaderCell ()

/// 展示图片
@property (nonatomic, strong) UIImageView * imgView;
@end

@implementation QGMallOperateHeaderCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        self.imgView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:nil];
        [self.imgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.inset(0);
            make.bottom.inset(-0.5);
        }];
        
    }
    return self;
}

- (void)setHeaderModel:(QGOperateHeaderModel *)headerModel
{
    if (_headerModel != headerModel) {
        _headerModel = headerModel;
        
        [self.imgView setMallImageByNomalPlaceholderWithURLString:_headerModel.img];
        self.contentView.backgroundColor = [UIColor colorWithHexString:_headerModel.backgroundColor];
    }
}

@end
