//
//  QGMallHomepageNavigationCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/2/25.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallHomepageNavigationCell.h"

#import "QGBasicUITool.h"
#import "UIImageView+WebCache.h"

@interface QGMallHomepageNavigationCell () <UICollectionViewDelegate, UICollectionViewDataSource>

@property (nonatomic, strong) UICollectionView * collectionView;

@end

@implementation QGMallHomepageNavigationCell


- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        //承载视图
        UICollectionViewFlowLayout * layout = [[UICollectionViewFlowLayout alloc] init];
        layout.scrollDirection = UICollectionViewScrollDirectionHorizontal;
        layout.minimumInteritemSpacing = 0;
        layout.minimumLineSpacing = 0;
        
        self.collectionView = [[UICollectionView alloc] initWithFrame:CGRectZero collectionViewLayout:layout];
        self.collectionView.delegate = self;
        self.collectionView.dataSource = self;
        self.collectionView.backgroundColor = [UIColor whiteColor];
        self.collectionView.scrollEnabled = NO;
        [self.contentView addSubview:self.collectionView];
        
        [self.collectionView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(0);
            make.top.bottom.inset(5);
        }];
        
        //注册cell
        [self.collectionView registerClass:[QGMallNavigationCollectionCell class] forCellWithReuseIdentifier:NSStringFromClass([QGMallNavigationCollectionCell class])];
        
        
    }
    return self;
}

#pragma mark - UICollectionViewDataSource
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    //最多四个
    return MIN(self.tempModel.navigationList.count, 4);;
}

- (__kindof UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    QGMallNavigationCollectionCell * cell = [collectionView dequeueReusableCellWithReuseIdentifier:NSStringFromClass([QGMallNavigationCollectionCell class]) forIndexPath:indexPath];
    
    //引导条
    QGMallNavigationModel * navigationModel = self.tempModel.navigationList[indexPath.row];
    cell.titleLabel.text = navigationModel.name;
    [cell.iconImgView sd_setImageWithURL:[NSURL URLWithString:navigationModel.icon]];
    
    return cell;
}

#pragma mark - UICollectionViewDelegate
- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    if (self.navigationClickBlock) {
        self.navigationClickBlock(indexPath.row, self.tempModel.navigationList[indexPath.row]);
    }
}

- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout sizeForItemAtIndexPath:(NSIndexPath *)indexPath
{
    return CGSizeMake(MAINSCREEN_WIDTH/4, self.height);
}

#pragma mark - Setter

- (void)setTempModel:(QGMallNavigationTempModel *)tempModel
{
    if (_tempModel != tempModel) {
        _tempModel = tempModel;
        
        [self.collectionView reloadData];
        
    }
}




- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end


/// 引导条子视图
@implementation QGMallNavigationCollectionCell

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        //文案
        self.titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_regularFontOfSize:12] textColor:[UIColor yyMainThemeColor] alignment:NSTextAlignmentCenter];
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerY.offset(0);
            make.centerX.offset(7);
        }];
        
        //图标
        self.iconImgView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:nil];
        [self.iconImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(12, 12));
            make.right.mas_equalTo(self.titleLabel.mas_left).offset(-2);
            make.centerY.mas_equalTo(self.titleLabel);
        }];
        
        
    }
    return self;
}

@end


