//
//  QGMallHomepageBannerCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/2/24.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallHomepageBannerCell.h"
#import "QGBasicUITool.h"
#import "QGBannerView.h"
@interface QGMallHomepageBannerCell () <QGBannerViewDelegate>

/// 图片数组视图
@property (nonatomic, strong) QGBannerView * bannerView;

/// 背景色
@property (nonatomic, strong) UIView * bgColorView;
@end

@implementation QGMallHomepageBannerCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
//        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        //渐变色背景
        self.bgColorView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor yyMainThemeColor]];
        [self.bgColorView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.top.right.inset(0);
            make.height.mas_equalTo(80);
        }];
        
        //绘制圆弧区域
        UIBezierPath *bezierPath = [UIBezierPath bezierPath];
        [bezierPath moveToPoint:CGPointMake(0, 0)];
        [bezierPath addLineToPoint:CGPointMake(0, 50)];
        [bezierPath addQuadCurveToPoint:CGPointMake(MAINSCREEN_WIDTH, 50) controlPoint:CGPointMake(MAINSCREEN_WIDTH/2, 106)];
        [bezierPath addLineToPoint:CGPointMake(MAINSCREEN_WIDTH, 0)];
        [bezierPath closePath];
        [bezierPath stroke];
        CAShapeLayer *layer = [CAShapeLayer layer];
        layer.path = bezierPath.CGPath;
        self.bgColorView.layer.mask = layer;
        
        //初始化banner
        self.bannerView = [QGBannerView bannerViewWithFrame:CGRectMake(15, 10, MAINSCREEN_WIDTH - 30, (MAINSCREEN_WIDTH - 30) * (9/22.0)) delegate:self placeholderImage:[UIImage imageNamed:@"mall_common_placeholder"]];
        self.bannerView.layer.cornerRadius = 6;
        self.bannerView.clipsToBounds = YES;
        self.bannerView.autoScrollTimeInterval = 3;
        [self.contentView addSubview:self.bannerView];
        
    }
    return self;
}

#pragma mark - QGBannerViewDelegate
/** 点击图片回调 */
- (void)bannerView:(QGBannerView *)bannerView didSelectItemAtIndex:(NSInteger)index
{
    if (self.bannerClickBlock) {
        if (self.bannerTempModel.topBannerList.count > index) {
            self.bannerClickBlock(index, self.bannerTempModel.topBannerList[index]);
        }
    }
}


- (void)setBannerTempModel:(QGMallBannerTempModel *)bannerTempModel
{
    if (_bannerTempModel != bannerTempModel) {
        _bannerTempModel = bannerTempModel;
        
        //是否展示渐变色背景
        self.bgColorView.hidden = !_bannerTempModel.showBackcolor.boolValue;
        
        //设置图片数组
        NSMutableArray * urlArray = [NSMutableArray arrayWithCapacity:0];
        for (QGMallBannerModel * bannerModel in bannerTempModel.topBannerList) {
            [urlArray addObject:bannerModel.img];
        }
        self.bannerView.imageUrlArray = urlArray;
    }
    
}



/**
 cell高度
 */
+ (CGFloat)cellHeight
{
    CGFloat width = MAINSCREEN_WIDTH - 30;
    CGFloat height = width * (9/22.0);
    return 10 + height + 5;
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
