//
//  QGMallShareViewController.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/10.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallShareViewController.h"

//View
#import "QGMallShareContentCell.h"
#import "QGMallShareImgCell.h"
#import "QGMallShareBottomView.h"
#import "QGShareView.h"
#import "QGAlertView.h"

//Model
#import "QGMallShareModel.h"
#import "QGAppCoreModelClickEvent.h"

//Tool
#import "QGMallRequestApi.h"
#import "SDWebImageManager.h"

#import <Photos/Photos.h>

@interface QGMallShareViewController ()

/// 底部视图
@property (nonatomic, strong) QGMallShareBottomView * bottomView;

/// 商品ID
@property (nonatomic, strong) NSString * goodsId;

/// 分享数据源
@property (nonatomic, strong) QGMallShareModel * shareModel;

/// 选中的图片索引
@property (nonatomic, assign) NSInteger selectImgIndex;

@end

@implementation QGMallShareViewController

- (BOOL)checkParameters:(NSDictionary *)param
{
    NSString * goodsId = param[@"goodsId"];
    if (![NSString isEmpty:goodsId]) {
        return YES;
    }
    return NO;
}

- (void)transferParameters:(NSDictionary *)param
{
    self.goodsId = param[@"goodsId"];
}


- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self initNormalUI];
    [self requestShareData];
}

#pragma mark - 初始化数据
- (void)initNormalUI
{
    [self custemLeftDefaultBarButtonItem];
    [self setNavBarBottomLineHidden:YES];
    self.distanceBottom = [DeviceAdaptation getBottomSafeAreaHeight] + 70;
    self.title = @"创建分享";
    
    self.bottomView = [[QGMallShareBottomView alloc] init];
    [self.view addSubview:self.bottomView];
    [self.bottomView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.inset(0);
        make.height.mas_equalTo(70);
        make.bottom.inset([DeviceAdaptation getBottomSafeAreaHeight]);
    }];
    self.bottomView.hidden = YES;
    
    @weakify(self);
    //复制事件
    self.bottomView.copyButtonClickBlock = ^{
        @strongify(self);
        [self copyButtonClick];
    };
    //分享事件
    self.bottomView.shareButtonClickBlock = ^{
        @strongify(self);
        [self shareButtonClick];
    };
}

#pragma mark - Request
///请求分享数据
- (void)requestShareData
{
    NSString * urlString = [QGMallRequestApi urlWithIndex:QGMallRequestServerMethodShare];
//    urlString = @"http://yapi.quantgroups.com/mock/305/vcc/app/mall/share";
    [QGHUDManager showHud:nil];
    [[QGTalosNetwork shareManager] GET:urlString parameters:@{@"goodsId":self.goodsId} success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        //业务处理成功
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            self.shareModel = [QGMallShareModel yy_modelWithDictionary:responseObject[@"data"]];
            [self.tableView reloadData];
            self.bottomView.hidden = NO;
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
    }];
}

#pragma mark - UITableViewDataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    //分享内容展示区 + 分享图片展示区
    return self.shareModel ? 2 : 0;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    switch (indexPath.row) {
            //分享内容展示区
        case 0:
        {
            QGMallShareContentCell * cell = (QGMallShareContentCell *)[self getCellFromClassName:NSStringFromClass([QGMallShareContentCell class]) dequeueTableView:tableView];
            cell.shareModel = self.shareModel;
            
            @weakify(self);
            //规则展示
            cell.ruleClickBlock = ^{
                @strongify(self);
                [self ruleButtonClick];
            };
            
            //复制口令
            cell.copyPwdBlock = ^{
                @strongify(self);
                [self copyPwdButtonClick];
            };
            //复制链接
            cell.copyLinkBlock = ^{
                @strongify(self);
                [self copyLinkButtonClick];
            };
            
            
            return cell;
        }
            break;
            //分享图片展示区
        case 1:
        {
            QGMallShareImgCell * cell = (QGMallShareImgCell *)[self getCellFromClassName:NSStringFromClass([QGMallShareImgCell class]) dequeueTableView:tableView];
            cell.imageArray = self.shareModel.shareImgs;
            cell.selectImgIndex = self.selectImgIndex;
            @weakify(self);
            cell.selectBlock = ^(NSInteger selectIndex) {
                @strongify(self);
                self.selectImgIndex = selectIndex;
            };
            return cell;
        }
            break;
            
        default:
            break;
    }
    return [super tableView:tableView cellForRowAtIndexPath:indexPath];
}

#pragma mark - UITableViewDelegate
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CGFloat heightForRow = 0;
    switch (indexPath.row) {
            //分享内容展示区
        case 0:
            heightForRow = self.shareModel.shareContentCellHeight;
            break;
            //分享图片展示区
        case 1:
            heightForRow = self.shareModel.shareImgCellHeight;
        break;
            
        default:
            break;
    }
    return heightForRow;
}

#pragma mark - Action

/// 规则展示
- (void)ruleButtonClick
{
    QGAlertView * alertView = [[QGAlertView alloc] initWithTitle:self.shareModel.shareRuleTitle message:self.shareModel.shareRuleDesc cancelButtonTitle:nil sureButtonTitle:@"知道了" clickBlock:nil];
    [alertView showInView:nil];
}

/// 复制按钮点击事件
- (void)copyButtonClick
{
    [self copyToPasteboardWithStr:self.shareModel.shareDesc];
    
    //神策埋点
    QGAppCoreModelClickEvent * clickEvent = [QGAppCoreModelClickEvent acmcEventWithPage:@"商品分享页" path:@"分享文案" name:@"复制分享文案" detail_name:nil acmc_model_other:nil];
    [QGAnalyticsService analyticsTrackWithEvent:clickEvent];
}

///复制口令
- (void)copyPwdButtonClick
{
    [self copyToPasteboardWithStr:self.shareModel.sharePwd];
    
    //神策埋点
    QGAppCoreModelClickEvent * clickEvent = [QGAppCoreModelClickEvent acmcEventWithPage:@"商品分享页" path:@"分享文案" name:@"仅复制淘口令" detail_name:nil acmc_model_other:nil];
    [QGAnalyticsService analyticsTrackWithEvent:clickEvent];
}
///复制链接
- (void)copyLinkButtonClick
{
    [self copyToPasteboardWithStr:self.shareModel.shareUrl];
    
    //神策埋点
    QGAppCoreModelClickEvent * clickEvent = [QGAppCoreModelClickEvent acmcEventWithPage:@"商品分享页" path:@"分享文案" name:@"仅复制链接" detail_name:nil acmc_model_other:nil];
    [QGAnalyticsService analyticsTrackWithEvent:clickEvent];
}

/// 复制文案到粘贴板
- (void)copyToPasteboardWithStr:(NSString *)str
{
    if (![NSString isEmpty:str]) {
        UIPasteboard * paste = [UIPasteboard generalPasteboard];
        paste.string = str;
        paste.strings = @[str];
        [QGHUDManager showHud:@"复制成功"];
    }
    else
    {
        [QGHUDManager showHud:@"复制失败"];
    }
}

///分享按钮点击事件
- (void)shareButtonClick
{
    
    //神策埋点
    QGAppCoreModelClickEvent * clickEvent = [QGAppCoreModelClickEvent acmcEventWithPage:@"商品分享页" path:@"分享图片" name:@"分享图片" detail_name:nil acmc_model_other:nil];
    [QGAnalyticsService analyticsTrackWithEvent:clickEvent];
    
    
    if (self.selectImgIndex < self.shareModel.shareImgs.count) {
        QGShareModel * shareModel = [[QGShareModel alloc] init];
        shareModel.imgUrl = self.shareModel.shareImgs[self.selectImgIndex];
        shareModel.shareObjType = QGShareModelObjTypeImage;
        QGShareView * shareView = [[QGShareView alloc] initWithItems:nil shareModel:shareModel];
        [shareView showInView:nil];
        
        @weakify(self);
        //自己处理分享事件
        shareView.takeOverShareBlock = ^(QGShareItemType shareItemType) {
            @strongify(self);
            [self shareWithItemType:shareItemType shareModel:shareModel];
            
            //模块名称
            NSString * modelName = nil;
            switch (shareItemType) {
                case QGShareItemTypeQQ:
                    modelName = @"QQ好友";
                    break;
                case QGShareItemTypeQQZone:
                    modelName = @"QQ空间";
                break;
                case QGShareItemTypeTimeLine:
                    modelName = @"朋友圈";
                break;
                case QGShareItemTypeWeChat:
                    modelName = @"微信";
                break;
                    
                default:
                    break;
            }
            
            //神策埋点
            QGAppCoreModelClickEvent * clickEvent = [QGAppCoreModelClickEvent acmcEventWithPage:@"商品分享页" path:@"分享控件" name:modelName detail_name:nil acmc_model_other:nil];
            [QGAnalyticsService analyticsTrackWithEvent:clickEvent];
        };
        
    }
}

/// 分发到各个平台
/// @param itemType 分享平台
/// @param shareModel 分享数据
- (void)shareWithItemType:(QGShareItemType)itemType shareModel:(QGShareModel *)shareModel
{
    //朋友圈单独处理
    if (itemType == QGShareItemTypeTimeLine) {
        NSString * imgUrl = shareModel.imgUrl;
        //相册
        PHAuthorizationStatus photoAuthorStatus = [PHPhotoLibrary authorizationStatus];
        //如果未授权过
        if (photoAuthorStatus == PHAuthorizationStatusNotDetermined) {
            //请求首次权限
            [PHPhotoLibrary requestAuthorization:^(PHAuthorizationStatus status) {
                //更新到主线程
                dispatch_async(dispatch_get_main_queue(), ^{
                    [self checkPhotoAuthStatus:status imgUrl:imgUrl];
                });
            }];
        }
        else
        {
            [self checkPhotoAuthStatus:photoAuthorStatus imgUrl:imgUrl];
        }
    }
    else
    {
        //平台分享
        NSDictionary * shareDic = [shareModel convertToShareDic];
        //触发分享
        [[QGThirdPlatformService shareInstance] shareImageWithType:itemType dictionary:shareDic resultBlock:nil];
    }
    
    
}

/// 检查相册权限，并进行后续逻辑处理
/// @param status 相册权限
/// @param imgUrl 图片链接
- (void)checkPhotoAuthStatus:(PHAuthorizationStatus)status imgUrl:(NSString *)imgUrl
{
    //这里已经过滤掉status = PHAuthorizationStatusNotDetermined的情况
    //用户已允许
    if (status == PHAuthorizationStatusAuthorized)
    {
        [QGHUDManager showHud:nil];
        @weakify(self);
        //下载图片
        [[SDWebImageManager sharedManager] loadImageWithURL:[NSURL URLWithString:imgUrl] options:0 progress:nil completed:^(UIImage * _Nullable image, NSData * _Nullable data, NSError * _Nullable error, SDImageCacheType cacheType, BOOL finished, NSURL * _Nullable imageURL) {
            [QGHUDManager hideHud];
            @strongify(self);
            if (image) {
                [self loadImageFinished:image];
            }
            else
            {
                [QGHUDManager showHud:@"图片下载失败"];
            }
            
        }];
    }
    //用户未允许
    else
    {
        QGAlertView * alert = [[QGAlertView alloc] initWithTitle:nil message:@"您未开启照片权限，请前往设置-隐私-照片中打开访问照片权限" cancelButtonTitle:nil sureButtonTitle:@"我知道了" clickBlock:nil];
        [alert showInView:nil];
    }
}

//写入图片到相册
- (void)loadImageFinished:(UIImage *)image
{
    [[PHPhotoLibrary sharedPhotoLibrary] performChanges:^{
         [PHAssetChangeRequest creationRequestForAssetFromImage:image];
     } completionHandler:^(BOOL success, NSError * _Nullable error) {
         //保存成功后，弹窗并跳转到朋友圈
         if (success) {
             //更新到主线程
             dispatch_async(dispatch_get_main_queue(), ^{
                 [self openWeChat];
             });
         }
    }];
}

/// 图片保存成功后，打开微信
- (void)openWeChat
{
    QGAlertView * alert = [[QGAlertView alloc] initWithTitle:@"图片已保存至相册" message:@"由于微信朋友圈限制，请手动发布朋友圈" cancelButtonTitle:nil sureButtonTitle:@"立即打开微信分享" clickBlock:^(NSInteger index) {
        BOOL openResult = [[QGThirdPlatformService shareInstance] openWXApp];
        if (!openResult) {
            [QGHUDManager showHud:@"打开微信失败"];
        }
    }];
    [alert showInView:nil];
}


@end
