//
//  QGMallShareImgSubView.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/10.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallShareImgSubView.h"
#import "QGBasicUITool.h"

@interface QGMallShareImgSubView ()

/// 图片
@property (nonatomic, strong, readwrite) UIImageView * imageView;

/// 选择按钮
@property (nonatomic, strong, readwrite) UIButton * selectButton;

/// 预览按钮
@property (nonatomic, strong, readwrite) UIButton * previewButton;

@end

@implementation QGMallShareImgSubView

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        //图片
        self.imageView = [UIImageView creatImageViewWithSuperView:self imageName:nil];
        [self.imageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.bottom.inset(0);
        }];
        
        //预览按钮
        self.previewButton = [UIButton creatButtonWithSuperView:self title:nil titleFont:nil textColor:nil];
        [self.previewButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.bottom.inset(0);
        }];
        
        //选择按钮
        self.selectButton = [UIButton creatButtonWithSuperView:self title:nil titleFont:nil textColor:nil];
        [self.selectButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.right.inset(0);
            make.size.mas_equalTo(CGSizeMake(35, 35));
        }];
        
        [self.selectButton setImage:[UIImage imageNamed:@"mall_share_img_unselect"] forState:UIControlStateNormal];
        [self.selectButton setImage:[UIImage imageNamed:@"mall_share_img_select"] forState:UIControlStateSelected];
        
    }
    return self;
}

@end
