//
//  QGMallShareImgCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/10.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallShareImgCell.h"
#import "QGBasicUITool.h"
#import "QGMallShareImgSubView.h"
#import "UIImageView+QGWebCache.h"
#import "MagnifyImageView.h"
@interface QGMallShareImgCell ()

/// 左侧图片
@property (nonatomic, strong) QGMallShareImgSubView * leftImgView;

/// 右1图片
@property (nonatomic, strong) QGMallShareImgSubView * right1ImgView;

/// 右2图片
@property (nonatomic, strong) QGMallShareImgSubView * right2ImgView;

/// 右3图片
@property (nonatomic, strong) QGMallShareImgSubView * right3ImgView;
@end


@implementation QGMallShareImgCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        //由于时间关系，就不用collectionView了，未来有时间再改
        //图片展示区域
        UIView * contentView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor moduleSeparatorColorF7F7]];
        [contentView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(15);
            make.top.inset(2);
            make.height.mas_equalTo(convertEqualScaleFrom375(322));
        }];
        contentView.layer.cornerRadius = 6;
        contentView.clipsToBounds = YES;
        
        //左侧大图
        self.leftImgView = [[QGMallShareImgSubView alloc] init];
        self.leftImgView.tag = 1;
        [contentView addSubview:self.leftImgView];
        [self.leftImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(convertEqualScaleFrom375(28));
            make.top.inset(convertEqualScaleFrom375(10));
            make.size.mas_equalTo(CGSizeMake(convertEqualScaleFrom375(183), convertEqualScaleFrom375(302)));
        }];
        
        //右侧1
        self.right1ImgView = [[QGMallShareImgSubView alloc] init];
        self.right1ImgView.tag = 2;
        [contentView addSubview:self.right1ImgView];
        [self.right1ImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(convertEqualScaleFrom375(96), convertEqualScaleFrom375(96)));
            make.top.inset(convertEqualScaleFrom375(10));
            make.left.mas_equalTo(self.leftImgView.mas_right).offset(convertEqualScaleFrom375(10));
        }];
        
        //右侧2
        self.right2ImgView = [[QGMallShareImgSubView alloc] init];
        self.right2ImgView.tag = 3;
        [contentView addSubview:self.right2ImgView];
        [self.right2ImgView mas_makeConstraints:^(MASConstraintMaker *make) {
           make.left.mas_equalTo(self.leftImgView.mas_right).offset(convertEqualScaleFrom375(10));
            make.size.mas_equalTo(CGSizeMake(convertEqualScaleFrom375(96), convertEqualScaleFrom375(96)));
            make.top.mas_equalTo(self.right1ImgView.mas_bottom).offset(convertEqualScaleFrom375(6));
        }];
        
        //右侧3
        self.right3ImgView = [[QGMallShareImgSubView alloc] init];
        self.right3ImgView.tag = 4;
        [contentView addSubview:self.right3ImgView];
        [self.right3ImgView mas_makeConstraints:^(MASConstraintMaker *make) {
           make.left.mas_equalTo(self.leftImgView.mas_right).offset(convertEqualScaleFrom375(10));
            make.size.mas_equalTo(CGSizeMake(convertEqualScaleFrom375(96), convertEqualScaleFrom375(96)));
            make.top.mas_equalTo(self.right2ImgView.mas_bottom).offset(convertEqualScaleFrom375(6));
        }];
        
        @weakify(self);
        //预览点击事件
        [self.leftImgView.previewButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
            @strongify(self);
            [self previewButtonClickWithIndex:0 imgSubView:self.leftImgView];
        }];

        [self.right1ImgView.previewButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
            @strongify(self);
            [self previewButtonClickWithIndex:1 imgSubView:self.right1ImgView];
        }];
        
        [self.right2ImgView.previewButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
            @strongify(self);
            [self previewButtonClickWithIndex:2 imgSubView:self.right2ImgView];
        }];
        
        [self.right3ImgView.previewButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
            @strongify(self);
            [self previewButtonClickWithIndex:3 imgSubView:self.right3ImgView];
        }];
        
        //选中点击事件
        [self.leftImgView.selectButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
            @strongify(self);
            [self selectButtonClickWithIndex:0 imgSubView:self.leftImgView];
        }];
        
        [self.right1ImgView.selectButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
            @strongify(self);
            [self selectButtonClickWithIndex:1 imgSubView:self.right1ImgView];
        }];
        
        [self.right2ImgView.selectButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
            @strongify(self);
            [self selectButtonClickWithIndex:2 imgSubView:self.right2ImgView];
        }];
        
        [self.right3ImgView.selectButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
            @strongify(self);
            [self selectButtonClickWithIndex:3 imgSubView:self.right3ImgView];
        }];
    }
    return self;
}

#pragma mark - action

/// 预览点击事件
- (void)previewButtonClickWithIndex:(NSInteger)index imgSubView:(QGMallShareImgSubView *)subView
{
    if (self.imageArray.count <= index) {
           return;
       }
       MagnifyImageView *imageView = [[MagnifyImageView alloc] initMagnifyImageViewWithDefault:subView index:index allImages:self.imageArray isNeedPageControl:YES];
       [imageView addKeyWindow];
}

- (void)selectButtonClickWithIndex:(NSInteger)index imgSubView:(QGMallShareImgSubView *)subView
{
    self.selectImgIndex = index;
    if (self.selectBlock) {
        self.selectBlock(index);
    }
}

#pragma mark - Setter
- (void)setImageArray:(NSArray<NSString *> *)imageArray
{
    if (_imageArray != imageArray) {
        _imageArray = imageArray;
        
        //隐藏和展示逻辑
        self.leftImgView.hidden = YES;
        self.right1ImgView.hidden = YES;
        self.right2ImgView.hidden = YES;
        self.right3ImgView.hidden = YES;
        

        for (NSInteger index = 0; index < _imageArray.count; index++) {
            NSString * urlString = _imageArray[index];
            if (index == 0) {
                [self.leftImgView.imageView setMallImageByNomalPlaceholderWithURLString:urlString];
                self.leftImgView.hidden = NO;
            }
            else if (index == 1)
            {
                [self.right1ImgView.imageView setMallImageByNomalPlaceholderWithURLString:urlString];
                self.right1ImgView.hidden = NO;
            }
            else if (index == 2)
            {
                [self.right2ImgView.imageView setMallImageByNomalPlaceholderWithURLString:urlString];
                self.right2ImgView.hidden = NO;
            }
            else if (index == 3)
            {
                [self.right3ImgView.imageView setMallImageByNomalPlaceholderWithURLString:urlString];
                self.right3ImgView.hidden = NO;
            }
        } 
    }
}


- (void)setSelectImgIndex:(CGFloat)selectImgIndex
{
    //清除旧的状态
    QGMallShareImgSubView * oldSubView = [self.contentView viewWithTag:_selectImgIndex + 1];
    if ([oldSubView isKindOfClass:[QGMallShareImgSubView class]]) {
        oldSubView.selectButton.selected = NO;
    }
    
    _selectImgIndex = selectImgIndex;
    
    //添加新的选中状态
    QGMallShareImgSubView * newSubView = [self.contentView viewWithTag:_selectImgIndex + 1];
    if ([newSubView isKindOfClass:[QGMallShareImgSubView class]]) {
        newSubView.selectButton.selected = YES;
    }
    
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
