//
//  QGMallShareContentCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/10.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallShareContentCell.h"

#import "QGBasicUITool.h"
#import "QGGradientView.h"
#import "QGPasteboardLabel.h"
@interface QGMallShareContentCell ()

/// 规则标题
@property (nonatomic, strong) UILabel * shareTitleLabel;

/// 分享内容
@property (nonatomic, strong) QGPasteboardLabel * shareContentLabel;


@end


@implementation QGMallShareContentCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        //返现规则
        QGGradientView * ruleView = [[QGGradientView alloc] init];
        ruleView.gradientLayer.colors = @[(id)[UIColor colorWithHexString:@"F2CD8B"].CGColor, (id)[UIColor colorWithHexString:@"E9B176"].CGColor];
        ruleView.layer.cornerRadius = 6;
        ruleView.clipsToBounds = YES;
        [self.contentView addSubview:ruleView];
        [ruleView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.inset(15);
            make.height.mas_equalTo(40);
        }];
        
        //查看规则按钮
        UIButton * openRuleButton = [UIButton creatButtonWithSuperView:ruleView title:@"查看规则>" titleFont:[UIFont qg_mediumFontOfSize:14] textColor:[UIColor whiteColor]];
        [openRuleButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.top.bottom.inset(0);
            make.width.mas_equalTo(83);
        }];
        
        @weakify(self);
        [openRuleButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
            @strongify(self);
            if (self.ruleClickBlock) {
                self.ruleClickBlock();
            }
        }];
        
        //规则标题
        self.shareTitleLabel = [UILabel creatLabelWithSuperView:ruleView title:nil titleFontSize:[UIFont qg_mediumFontOfSize:14] textColor:[UIColor whiteColor] alignment:NSTextAlignmentLeft];
        [self.shareTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.offset(10);
            make.right.mas_equalTo(openRuleButton.mas_left);
            make.centerY.offset(0);
        }];
        
        //分享内容展示区域
        UIView * shareContentView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor moduleSeparatorColorF7F7]];
        [shareContentView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(15);
            make.top.mas_equalTo(ruleView.mas_bottom).offset(10);
        }];
        shareContentView.layer.cornerRadius = 6;
        shareContentView.clipsToBounds = YES;
        
        //分享内容
        self.shareContentLabel = [[QGPasteboardLabel alloc] init];
        [shareContentView addSubview:self.shareContentLabel];
        self.shareContentLabel.font = [UIFont qg_regularFontOfSize:14];
        self.shareContentLabel.textColor = [UIColor textColor6666];        
        self.shareContentLabel.numberOfLines = 0;
        [self.shareContentLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(10);
            make.top.bottom.inset(12);
        }];
        
        //复制口令按钮
        UIButton * copyPwdButton = [UIButton creatButtonWithSuperView:self.contentView title:@" 仅复制口令" titleFont:[UIFont qg_regularFontOfSize:13] textColor:[UIColor yyMainThemeColor]];
        [copyPwdButton setImage:[UIImage imageNamed:@"mall_share_copy"] forState:UIControlStateNormal];
        [copyPwdButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(109, 25));
            make.top.mas_equalTo(shareContentView.mas_bottom).offset(15);
            make.right.mas_equalTo(self.contentView.mas_centerX).offset(-24);
        }];
        [copyPwdButton setBorder:[UIColor yyMainThemeColor] width:1];
        copyPwdButton.layer.cornerRadius = 12.5;
        copyPwdButton.clipsToBounds = YES;
        
        
        //复制口令链接
        UIButton * copyLinkButton = [UIButton creatButtonWithSuperView:self.contentView title:@" 仅复制链接" titleFont:[UIFont qg_regularFontOfSize:13] textColor:[UIColor yyMainThemeColor]];
        [copyLinkButton setImage:[UIImage imageNamed:@"mall_share_copy"] forState:UIControlStateNormal];
        [copyLinkButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(109, 25));
            make.top.mas_equalTo(shareContentView.mas_bottom).offset(15);
            make.left.mas_equalTo(self.contentView.mas_centerX).offset(24);
        }];
        [copyLinkButton setBorder:[UIColor yyMainThemeColor] width:1];
        copyLinkButton.layer.cornerRadius = 12.5;
        copyLinkButton.clipsToBounds = YES;
        
        
        
        [copyPwdButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
            @strongify(self);
            if (self.copyPwdBlock) {
                self.copyPwdBlock();
            }
        }];
        
        [copyLinkButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
            @strongify(self);
            if (self.copyLinkBlock) {
                self.copyLinkBlock();
            }
        }];
        
    }
    return self;
}


- (void)setShareModel:(QGMallShareModel *)shareModel
{
    if (_shareModel != shareModel) {
        _shareModel = shareModel;
        self.shareTitleLabel.text = shareModel.shareTitle;
        self.shareContentLabel.text = shareModel.shareDesc;
    }
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
