//
//  QGMallShareBottomView.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/11.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallShareBottomView.h"

#import "QGBasicUITool.h"
#import "QGGradientShadowButton.h"
@implementation QGMallShareBottomView

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        //顶部线条
        UIView * topLineView = [UIView creatViewWithSuperView:self backgroundColor:[UIColor lineSeparatorColorDCDC]];
        [topLineView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.inset(0);
            make.height.mas_equalTo(0.5);
        }];
        
        //复制按钮
        UIButton * copyButton = [UIButton creatButtonWithSuperView:self title:@"复制文案" titleFont:[UIFont qg_regularFontOfSize:16] textColor:[UIColor yyMainThemeColor]];
        [copyButton setBorder:[UIColor yyMainThemeColor] width:1];
        copyButton.layer.cornerRadius = 20;
        copyButton.clipsToBounds = YES;
        [copyButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(15);
            make.height.mas_equalTo(40);
            make.centerY.offset(0);
        }];
        [copyButton addTarget:self action:@selector(copyButtonClick) forControlEvents:UIControlEventTouchUpInside];
        
        
        //分享按钮
        QGGradientShadowButton * shareButton = [QGGradientShadowButton creatGradientColorButtonWithSuperView:self title:@"分享图片" textFont:[UIFont qg_regularFontOfSize:16]];
        [shareButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(copyButton.mas_right).offset(10);
            make.right.inset(15);
            make.height.width.centerY.mas_equalTo(copyButton);
        }];
        [shareButton addTarget:self action:@selector(shareButtonClick) forControlEvents:UIControlEventTouchUpInside];
    }
    return self;
}

#pragma mark - Action
/// 复制事件
- (void)copyButtonClick
{
    if (self.copyButtonClickBlock) {
        self.copyButtonClickBlock();
    }
}

/// 分享事件
- (void)shareButtonClick
{
    if (self.shareButtonClickBlock) {
        self.shareButtonClickBlock();
    }
}
@end
