//
//  QGMallContainerViewController.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/6.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallContainerViewController.h"
#import "QGPreferentialMallViewController.h"
#import "QGSearchMallViewController.h"
#import "QGMallGuessLikeViewController.h"
#import "QGMallHomeGoodsListViewController.h"


//Tool
#import "QGActivityPopManager.h"
#import "QGUserCenterRequestApi.h"
#import "QGMallRequestApi.h"

//View

//Model
#import "QGMallMenuDataSourceModel.h"

#import "SystemManager.h"

#import "QGAlertView.h"

@interface QGMallContainerViewController ()

/// 消息按钮
@property (nonatomic, strong) UIButton * messageButton;

/// 更多菜单按钮
@property (nonatomic, strong) UIButton * moreMenuButton;

/// 菜单数据源
@property (nonatomic, strong) QGMallMenuDataSourceModel * menuDataSource;
@end

@implementation QGMallContainerViewController

- (UIStatusBarStyle)preferredStatusBarStyle
{
    return UIStatusBarStyleLightContent;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self initNormalUI];
    [self requestMenuData];
    //弹窗
//    [QGActivityPopManager.shareInstance showActivitiesAtPosition:QGActivityPositionMall inController:self];
    
   
}

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    [QGActivityPopManager.shareInstance viewDidAppearAtPosition:QGActivityPositionMall inController:self];
    
    [self requestMessageCount];
}


#pragma mark - 初始化基础UI和数据
- (void)initNormalUI
{
    //设置导航栏为渐变色
    [self setNavBarBackgroundColor:[UIColor yyMainThemeColor]];
    [self setNavBarBottomLineHidden:YES];
    
    //添加右侧按钮，客服 & 消息
    self.messageButton = [self creatRightButtonWithImageName:@"mall_homepage_message_normal"];
    [self.messageButton addTarget:self action:@selector(messageButtonClick) forControlEvents:UIControlEventTouchUpInside];
    UIBarButtonItem * messageBtnItem = [[UIBarButtonItem alloc]initWithCustomView:self.messageButton];
//    UIButton * orderButton = [self creatRightButtonWithImageName:@"mall_homepage_order"];
//    [orderButton addTarget:self action:@selector(orderButtonClick) forControlEvents:UIControlEventTouchUpInside];
//    UIBarButtonItem * orderButtonItem = [[UIBarButtonItem alloc]initWithCustomView:orderButton];
    self.navigationItem.rightBarButtonItems = @[messageBtnItem];
    
    [self initSearchBar];
}

- (void)initSearchBar
{
    //导航栏搜索视图
    UIView * searchView = [UIView creatViewWithSuperView:nil backgroundColor:[UIColor whiteColor]];
    [self addNavBarSubView:searchView];
    [searchView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.offset(15);
        make.bottom.inset(8);
        make.height.mas_equalTo(30);
        make.right.inset(54);
    }];
    searchView.layer.cornerRadius = 15;
    searchView.clipsToBounds = YES;
    
    //搜索图标
    UIImageView * searchImg = [UIImageView creatImageViewWithSuperView:searchView imageName:@"mall_homepage_search"];
    [searchImg mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.inset(10);
        make.size.mas_equalTo(CGSizeMake(12, 13));
        make.centerY.offset(0);
    }];
    
    //搜索文案
    UILabel * searchTitleLabel = [UILabel creatLabelWithSuperView:searchView title:@"搜索品牌/商品名称/粘贴宝贝标题" titleFontSize:[UIFont qg_regularFontOfSize:12] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
    [searchTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(searchImg.mas_right).offset(5);
        make.centerY.offset(0);
    }];
    
    //搜索入口触发按钮
    UIButton * titleSearchButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [titleSearchButton addTarget:self action:@selector(searchButtonClick) forControlEvents:UIControlEventTouchUpInside];
    titleSearchButton.bounds = CGRectMake(0, 0, MAINSCREEN_WIDTH - 15 - 60, 30);
    self.navigationItem.titleView = titleSearchButton;
    
    //更多菜单入口
    self.moreMenuButton = [UIButton creatButtonWithSuperView:self.view title:nil titleFont:nil textColor:nil];
    [self.moreMenuButton setImage:[UIImage imageNamed:@"mall_homepage_menu_more"] forState:UIControlStateNormal];
    self.moreMenuButton.backgroundColor = [UIColor yyMainThemeColor];
    [self.moreMenuButton addTarget:self action:@selector(moreMenuButtonClick) forControlEvents:UIControlEventTouchUpInside];
    [self.moreMenuButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.inset(0);
        make.top.mas_offset([DeviceAdaptation getNavBarAndStatusBarHeight]);
        make.size.mas_equalTo(CGSizeMake(40, 40));
    }];
    self.moreMenuButton.hidden = YES;
    
    
}

///根据menu个数判断样式
- (void)resetMenuView {
    
    self.moreMenuButton.hidden = NO;
    
    //文字|宽度|间距
    NSMutableArray * titleArray = [NSMutableArray arrayWithCapacity:0];
    NSMutableArray *titleWidthArray = [NSMutableArray arrayWithCapacity:0];
    NSMutableArray *itemsMargins = [NSMutableArray arrayWithCapacity:0];
    [itemsMargins addObject:@(20)];
    for (int i = 0; i < self.menuDataSource.menuList.count; i++) {
        QGMallMenuModel * menuModel = self.menuDataSource.menuList[i];
        NSString *titleStr = menuModel.name;
        CGFloat titleWidth = [NSString getWidthWithContent:titleStr height:15 UIFont:[UIFont qg_regularFontOfSize:14]];
        [titleWidthArray addObject:@(titleWidth + 1)];
        if (i != self.menuDataSource.menuList.count - 1) {
           [itemsMargins addObject:@(30)];
        } else {
           [itemsMargins addObject:@(20)];
        }
        [titleArray addObject:titleStr];
    }
    self.titles = titleArray;
    self.itemsWidths = titleWidthArray;
    self.itemsMargins = itemsMargins;
    
    
    self.menuViewStyle = WMMenuViewStyleLine;
    self.menuBGColor = [UIColor yyMainThemeColor];
    self.menuViewLayoutMode = WMMenuViewLayoutModeLeft;
    
    self.
    
    //进度条
    self.progressViewBottomSpace = 3;
    self.progressColor = [UIColor whiteColor];
    self.progressWidth = 27;
    self.progressHeight = 2;
    
    //字体
    self.titleFontName = [UIFont qg_regularFontOfSize:14].fontName;
    self.titleSizeNormal = 14;
    self.titleSizeSelected = 14;
    self.titleColorNormal = [UIColor whiteColor];
    self.titleColorSelected = [UIColor whiteColor];
    [self reloadData];
}


#pragma mark - Request
- (void)requestMessageCount
{
    //登录状态下才请求
    if ([QGUserInfo sharedUserInfo].isLogin) {
        //请求未读消息数
        NSString *unreadUrl = [QGUserCenterRequestApi urlWithUserCenterRequestServerMethod:QGUserCenterRequestServerMethodUnread];
        NSMutableDictionary *noticesParame = [[NSMutableDictionary alloc] initWithCapacity:1];
        [noticesParame setObject:@"all" forKey:@"msgType"];
        [[QGTalosNetwork shareManager] GET:unreadUrl parameters:noticesParame success:^(id  _Nonnull responseObject) {
            //业务成功逻辑
            if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
                [QGUserInfo sharedUserInfo].unreadNumber = [responseObject valueForKeyPath:@"data.notifyMsgCount"];
                if ([QGUserInfo sharedUserInfo].unreadNumber.integerValue > 0) {
                    [self.messageButton setImage:[UIImage imageNamed:@"mall_homepage_message_hint"] forState:UIControlStateNormal];
                }else{
                    [self.messageButton setImage:[UIImage imageNamed:@"mall_homepage_message_normal"] forState:UIControlStateNormal];
                }
            }
            
        } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
            
        }];
    }
    //未登录状态下清理消息状态
    else
    {
        [self.messageButton setImage:[UIImage imageNamed:@"mall_homepage_message_normal"] forState:UIControlStateNormal];
    }
}

///请求菜单数据
- (void)requestMenuData
{
    NSString * urlString = [QGMallRequestApi urlWithIndex:QGMallRequestServerMethodMallMenu];
//    urlString = @"http://yapi.quantgroups.com/mock/305/vcc/app/mall/menu";
    [QGHUDManager showHud:nil];
    [[QGTalosNetwork shareManager] GET:urlString parameters:nil success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            self.menuDataSource = [QGMallMenuDataSourceModel yy_modelWithDictionary:responseObject[@"data"]];
            [self resetMenuView];
        }
        else
        {
            //展示出来错误信息
            [QGHUDManager showHudWithError:responseObject];
            [self requestMenuFail];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager hideHud];
        [self requestMenuFail];
    }];
}

/// 请求失败刷新页面
- (void)requestMenuFail
{
    @weakify(self);
    [self showErrorPageReloadBlock:^{
        @strongify(self);
        [self requestMenuData];
    }];
}

#pragma mark - WMPageControllerDataSource
- (CGRect)pageController:(WMPageController *)pageController preferredFrameForContentView:(WMScrollView *)contentView
{
    //导航+菜单
    CGFloat Y = [DeviceAdaptation getNavBarAndStatusBarHeight] + 40;
    //移除tabbar的高度
    CGFloat height = MAINSCREEN_HEIGHT - Y - [DeviceAdaptation getTabBarHeight];
    return CGRectMake(0, Y, MAINSCREEN_WIDTH, height);
}

/**
 Implement this datasource method, in order to customize your own menuView's frame
 
 @param pageController The container controller
 @param menuView The menuView
 @return The frame of the menuView
 */
- (CGRect)pageController:(WMPageController *)pageController preferredFrameForMenuView:(WMMenuView *)menuView
{
    //导航+菜单
    CGFloat Y = [DeviceAdaptation getNavBarAndStatusBarHeight];
    return CGRectMake(0, Y, MAINSCREEN_WIDTH - 40, 40);
}

- (NSInteger)numbersOfChildControllersInPageController:(WMPageController *)pageController {
    return self.titles.count;
}

- (UIViewController *)pageController:(WMPageController *)pageController viewControllerAtIndex:(NSInteger)index {
    UIViewController *vc = nil;
    QGMallMenuModel * menuModel = self.menuDataSource.menuList[index];
    //1精选，2猜你喜欢，99专栏
    switch (menuModel.type.integerValue) {
            //精选推荐
        case 1:
        {
            QGPreferentialMallViewController *recommendVC = [[QGPreferentialMallViewController alloc] init];
            recommendVC.name = menuModel.name;
            vc = recommendVC;
        }
            break;
        case 2:
        {
            /// 猜你喜欢
            QGMallGuessLikeViewController *likeVC = [[QGMallGuessLikeViewController alloc]init];
            likeVC.searchTerm = menuModel.searchTerms;
            likeVC.materialId = menuModel.materialId;
            likeVC.navTitle = menuModel.name;
            likeVC.isBox = YES;
            likeVC.isChildren = YES;
            vc = likeVC;
        }
            break;
            //专栏 一级品类页
        case 99:
        {
            QGMallHomeGoodsListViewController * listVC = [[QGMallHomeGoodsListViewController alloc] init];
            listVC.materialId = menuModel.materialId;
            listVC.searchTerm = menuModel.searchTerms;
            listVC.navTitle = menuModel.name;
            listVC.isBox = YES;
            listVC.categoryLevelTwoItmes = menuModel.menuItemList;
            listVC.isChildren = YES;
            vc = listVC;
        }
            break;
        default:
            break;
    }

    if (!vc) {
        vc = [[UIViewController alloc] init];
    }

    return vc;
}


- (void)menuView:(WMMenuView *)menu didSelectedIndex:(NSInteger)index currentIndex:(NSInteger)currentIndex
{
    [super menuView:menu didSelectedIndex:index currentIndex:currentIndex];
    
    QGMallMenuModel * menuModel = self.menuDataSource.menuList[index];
    NSString * modelName = menuModel.name;
    //数据埋点
    QGAppCoreModelClickEvent * event = [QGAppCoreModelClickEvent acmcEventWithPage:@"省钱页" path:@"专栏" name:modelName detail_name:nil acmc_model_other:nil];
    [QGAnalyticsService analyticsTrackWithEvent:event];
}

#pragma mark - Action

/// 搜索入口
- (void)searchButtonClick
{
    //数据埋点
    QGAppCoreModelClickEvent * event = [QGAppCoreModelClickEvent acmcEventWithPage:@"省钱页" path:@"顶部导航" name:@"搜索栏" detail_name:nil acmc_model_other:nil];
    [QGAnalyticsService analyticsTrackWithEvent:event];
    
    QGSearchMallViewController *searchVC = [[QGSearchMallViewController alloc]init];
    [self presentViewController:searchVC animated:NO completion:NULL];
}

/// 消息点击事件
- (void)messageButtonClick
{
    //数据埋点
    QGAppCoreModelClickEvent * event = [QGAppCoreModelClickEvent acmcEventWithPage:@"省钱页" path:@"顶部导航" name:@"消息" detail_name:nil acmc_model_other:nil];
    [QGAnalyticsService analyticsTrackWithEvent:event];
    
    if ([QGUserInfo sharedUserInfo].login) {//去到消息中心
        [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGMessageCenterVC] parameters:nil handlerBlock:nil];
    }else{
        [self showLoginViewController];
    }
}

///订单按钮点击事件
- (void)orderButtonClick
{
    
    //数据埋点
    QGAppCoreModelClickEvent * event = [QGAppCoreModelClickEvent acmcEventWithPage:@"省钱页" path:@"顶部导航" name:@"订单" detail_name:nil acmc_model_other:nil];
    [QGAnalyticsService analyticsTrackWithEvent:event];
    
    //跳转订单页
    if ([QGUserInfo sharedUserInfo].login) {
        if (![NSString isEmpty:self.menuDataSource.orderUrl]) {
            [self navigationToWeb:self.menuDataSource.orderUrl];
        }
    }else{
        
         [self showLoginViewController];
    }
    
}

/// 更多菜单
- (void)moreMenuButtonClick
{
    //数据埋点
    QGAppCoreModelClickEvent * event = [QGAppCoreModelClickEvent acmcEventWithPage:@"省钱页" path:@"专栏" name:@"更多分类" detail_name:nil acmc_model_other:nil];
    [QGAnalyticsService analyticsTrackWithEvent:event];

    if (![NSString isEmpty:self.menuDataSource.moreUrl]) {
        [self navigationToWeb:self.menuDataSource.moreUrl];
    }
}

#pragma mark - Creat
/// 创建右上角按钮 此处仅适用于有多个的情况
- (UIButton *)creatRightButtonWithImageName:(NSString *)imageName
{
    UIButton * rightButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [rightButton setImage:[UIImage imageNamed:imageName] forState:UIControlStateNormal];
    rightButton.bounds = CGRectMake(0, 0, 22, 32);
    return rightButton;
}

@end
