//
//  QGMallGoodsDetailViewController.m
//  VirtualPayment
//
//  Created by 张博 on 2020/2/26.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallGoodsDetailViewController.h"

//View
#import "QGGoodsDetailBannerCell.h"
#import "QGMallGoodsDetailInfoCell.h"
#import "QGMallGoodsDetailCouponCell.h"
#import "QGMallGoodsDetailShopCell.h"
#import "QGMallVerticalGoodsCell.h"
#import "QGMallGoodsDetailPromoterCell.h"
#import "QGGradientShadowButton.h"
#import "MagnifyImageView.h"
#import "QGMallGoodsDetailBottomView.h"

//Tool
#import "QGMallRequestApi.h"
#import "QGBaiChuanManager.h"


//Model
#import "QGMallGoodsDetailInfoModel.h"

@interface QGMallGoodsDetailViewController ()

/// 商品ID
@property (nonatomic, strong) NSString * goodsId;

/// 请求的商品详情信息
@property (nonatomic, strong) QGMallGoodsDetailInfoModel * detailInfoModel;

/// 返回顶部按钮
@property (nonatomic, strong) UIButton * topButton;

/// 底部视图
@property (nonatomic, strong) QGMallGoodsDetailBottomView * bottomView;
@end

@implementation QGMallGoodsDetailViewController

- (BOOL)checkParameters:(NSDictionary *)param
{
    NSString * goodsId = param[@"goodsId"];
    if (![NSString isEmpty:goodsId]) {
        return YES;
    }
    return NO;
}

- (void)transferParameters:(NSDictionary *)param
{
    self.goodsId = param[@"goodsId"];
}

- (void)dealloc
{
    [self removeNotofication];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    [self initNormalUI];
    [self initNormalData];
    [self requestGoodsData];
    [self addNotification];
}

- (void)initNormalUI
{
    //自定义左侧按钮
    [self customLeftBarButtonItemWithImgName:@"mall_goodsdetail_goback" action:nil];
    [self setNavBarBackgroundAlpha:0];
    self.isBelowNavBar = YES;
    self.distanceBottom = [DeviceAdaptation getBottomSafeAreaHeight] + 70;
    self.tableView.backgroundColor = [UIColor moduleSeparatorColorF7F7];
    self.bottomView = [self creatBottomView];
    self.bottomView.hidden = YES;
    
    //返回顶部
    self.topButton = [UIButton creatButtonWithSuperView:self.view title:nil titleFont:nil textColor:nil];
    [self.topButton addTarget:self action:@selector(backToTopClick) forControlEvents:UIControlEventTouchUpInside];
    [self.topButton setImage:[UIImage imageNamed:@"mall_goodsdetail_top"] forState:UIControlStateNormal];
    [self.topButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.inset(15);
        make.size.mas_equalTo(CGSizeMake(42, 42));
        make.bottom.mas_equalTo(self.bottomView.mas_top).offset(-20);
    }];
    
    self.topButton.hidden = YES;
}

/// 初始化底部视图
- (QGMallGoodsDetailBottomView *)creatBottomView
{
    QGMallGoodsDetailBottomView * bottomView = [[QGMallGoodsDetailBottomView alloc] init];
    [self.view addSubview:bottomView];
    [bottomView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.inset(0);
        make.height.mas_equalTo(70);
        make.bottom.inset([DeviceAdaptation getBottomSafeAreaHeight]);
    }];
    [bottomView.goHomeButton addTarget:self action:@selector(goBackClick) forControlEvents:UIControlEventTouchUpInside];
    [bottomView.shareButton addTarget:self action:@selector(shareButtonClick) forControlEvents:UIControlEventTouchUpInside];
    [bottomView.orderButton addTarget:self action:@selector(orderButtonClick) forControlEvents:UIControlEventTouchUpInside];
    
    return bottomView;
}

- (void)initNormalData
{
    
}

#pragma mark - Request

/// 请求商品跳转链接
/// @param successBlock 成功回调
- (void)requestGoodsUrlWithSuccess:(void(^)(NSString * goodsUrl))successBlock
{
    NSString * urlString = [QGMallRequestApi urlWithIndex:QGMallRequestServerMethodMallShopUrl];
//    urlString = @"http://yapi.quantgroups.com/mock/305/app/mall/shopUrl";
    NSDictionary * infoDic = @{@"goodsId":self.goodsId};
    [QGHUDManager showHud:nil];
    [[QGTalosNetwork shareManager] GET:urlString parameters:infoDic success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary * dataDic = responseObject[@"data"];
            if (successBlock) {
                successBlock(dataDic[@"jumpUrl"]);
            }
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
    }];
}

/// 请求商品数据
- (void)requestGoodsData
{
    NSString * urlString = [QGMallRequestApi urlWithIndex:QGMallRequestServerMethodGoodsDetail];
//    urlString = @"http://yapi.quantgroups.com/mock/305/vcc/app/mall/goods";
    NSDictionary * infoDic = @{@"goodsId":self.goodsId};
    [QGHUDManager showHud:nil];
    [[QGTalosNetwork shareManager] GET:urlString parameters:infoDic success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            self.detailInfoModel = [QGMallGoodsDetailInfoModel yy_modelWithDictionary:responseObject[@"data"]];
            [self.tableView reloadData];
            self.bottomView.hidden = NO;
            [self.bottomView setShareAmount:self.detailInfoModel.goodsInfo.shareEarnAmountDesc orderAmount:self.detailInfoModel.goodsInfo.earnAmountDesc];
            
            //数据埋点 每次打开只记录一次
            QGAppCoreModelClickEvent * event = [QGAppCoreModelClickEvent acmcEventWithPage:@"商品详情页" path:@"商品详情" name:@"商品详情打开" detail_name:self.detailInfoModel.goodsInfo.goodsId acmc_model_other:self.detailInfoModel.goodsInfo.goodsName];
            [QGAnalyticsService analyticsTrackWithEvent:event];
            
        }
        else
        {
            NSString * businessCode = responseObject[@"businessCode"];
            //商品缺省页，此时找不到商品了
            if ([businessCode isEqualToString:@"2101"]) {
                [self goodsNotFound];
            }
            else
            {
                [self requestFailure];
            }
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager hideHud];
        [self requestFailure];
    }];
}

- (void)requestFailure
{
    self.bottomView.hidden = YES;
    @weakify(self);
    QGDefaultView * view = [QGDefaultView defaultViewShowWithSuperView:self.view reloadBlock:^{
        @strongify(self);
        [self requestGoodsData];
    }];
    view.viewType = QGDefaultViewTypeBadNetwork;
}

- (void)goodsNotFound
{
//    mall_goods_notfound
    QGDefaultView * view = [QGDefaultView defaultViewShowWithSuperView:self.view reloadBlock:nil];
    view.viewType = QGDefaultViewTypeNormal;
    view.reloadButton.hidden = YES;
    [view setIconImageWithImageName:@"mall_goods_notfound" messageTitle:@"抱歉，你查找的商品不存在啦~" buttonTitle:nil];
}


#pragma mark - UITableViewDataSource

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    //商品模块 + 店铺模块 + 猜你喜欢
    return self.detailInfoModel ? 3 : 0;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    NSInteger numberOfRows = 0;
    switch (section) {
            //商品模块
        case 0:
            //没有优惠券就只展示前三个
            numberOfRows = self.detailInfoModel.goodsInfo.couponAmount ? 4 : 3;
            break;
            //店铺模块
        case 1:
            numberOfRows = self.detailInfoModel.shopInfo ? 1 : 0;
        break;
            //推荐模块
        case 2:
            numberOfRows = ceil(self.detailInfoModel.recommendGoodsList.count/2.0);
            break;
        default:
            break;
    }
    
    return numberOfRows;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    
    switch (indexPath.section) {
            //商品模块
        case 0:
        {
            return [self getFirstSectionCellWithTableView:tableView cellForRowAtIndexPath:indexPath];
        }
            break;
            //商铺信息
        case 1:
        {
            QGMallGoodsDetailShopCell * cell = (QGMallGoodsDetailShopCell *)[self getCellFromClassName:NSStringFromClass([QGMallGoodsDetailShopCell class]) dequeueTableView:tableView];
            cell.shopModel = self.detailInfoModel.shopInfo;
            
            return cell;
        }
            break;
            
            //推荐模块
        case 2:
        {
            QGMallVerticalGoodsCell * cell = (QGMallVerticalGoodsCell *)[self getCellFromClassName:NSStringFromClass([QGMallVerticalGoodsCell class]) dequeueTableView:tableView];
            
            NSInteger location = indexPath.row * 2;
            NSInteger length = 2;
            //可能会出现最后一行只有一个的情况
            if (location + length > self.detailInfoModel.recommendGoodsList.count) {
                length = 1;
            }
            cell.goodsList = [self.detailInfoModel.recommendGoodsList subarrayWithRange:NSMakeRange(location, length)];
            
            @weakify(self);
            cell.clickBlock = ^(QGMallBaseGoodsModel * _Nonnull goodsModel) {
                @strongify(self);
                [self recommendGoodsClick:goodsModel];
            };
            
            return cell;
        }
            break;
            
        default:
            break;
    }

    return [UITableViewCell new];
}

- (UITableViewCell *)getFirstSectionCellWithTableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    switch (indexPath.row) {
            //商品图片区域
        case 0:
        {
            QGGoodsDetailBannerCell * cell = (QGGoodsDetailBannerCell *)[self getCellFromClassName:NSStringFromClass([QGGoodsDetailBannerCell class]) dequeueTableView:tableView];
            cell.goodsImgArray = self.detailInfoModel.goodsInfo.goodsSmallImgs;
            
            __block UIView * fromView = cell;
            @weakify(self);
            cell.clickBlock = ^(NSInteger index) {
                @strongify(self);
                [self bannerImgClick:index fromView:fromView];
            };
            return cell;
        }
            break;
            //推广官
        case 1:
        {
            QGMallGoodsDetailPromoterCell * cell = (QGMallGoodsDetailPromoterCell *)[self getCellFromClassName:NSStringFromClass([QGMallGoodsDetailPromoterCell class]) dequeueTableView:tableView];
            //设置参数
            [cell setPromoterEarnDesc:self.detailInfoModel.goodsInfo.promoterEarnDesc promoterLevel:self.detailInfoModel.goodsInfo.promoterLevel];
            //分享按钮点击事件
            [cell.openButton addTarget:self action:@selector(shareButtonClick) forControlEvents:UIControlEventTouchUpInside];
            return cell;
        }
            break;
            //商品信息
        case 2:
        {
            QGMallGoodsDetailInfoCell * cell = (QGMallGoodsDetailInfoCell *)[self getCellFromClassName:NSStringFromClass([QGMallGoodsDetailInfoCell class]) dequeueTableView:tableView];
            cell.detailInfoModel = self.detailInfoModel.goodsInfo;
            return cell;
        }
            break;
            //优惠券信息
        case 3:
        {
            QGMallGoodsDetailCouponCell * cell = (QGMallGoodsDetailCouponCell *)[self getCellFromClassName:NSStringFromClass([QGMallGoodsDetailCouponCell class]) dequeueTableView:tableView];
            cell.detailInfoModel = self.detailInfoModel.goodsInfo;
            return cell;
        }
            break;

        default:
            break;
    }
    return [UITableViewCell new];
}



#pragma mark - UITableViewDelegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    //优惠券点击事件
    if (indexPath.section == 0 && indexPath.row == 3) {
        [self couponButtonClick];
    }
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    //cell高度
    CGFloat heightForRow = 0;
    if (indexPath.section == 0) {
        
        switch (indexPath.row) {
            //商品图片区域
           case 0:
           {
               heightForRow = MAINSCREEN_WIDTH;
           }
               break;
                //推广官
            case 1:
                heightForRow = [NSString isEmpty:self.detailInfoModel.goodsInfo.promoterEarnDesc] ? 0: 55;
                break;
               //商品信息
           case 2:
           {
               heightForRow = self.detailInfoModel.goodsInfo.cellHeight;
           }
               break;
               //优惠券信息
           case 3:
           {
               heightForRow = 105;
           }
               break;
            default:
                break;
        }
        
    }
    //店铺信息
    else if (indexPath.section == 1)
    {
        heightForRow = 90;
    }
    //猜你喜欢
    else if (indexPath.section == 2)
    {
        heightForRow = self.detailInfoModel.recommendCellHeight;
    }
    return heightForRow;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    //猜你喜欢
    if (section == 2 && self.detailInfoModel.recommendGoodsList.count > 0) {
        return 66;
    }
    return [super tableView:tableView heightForHeaderInSection:section];
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    //猜你喜欢
    if (section == 2 && self.detailInfoModel.recommendGoodsList.count > 0) {
        UIView * bgView = [UIView creatViewWithSuperView:nil backgroundColor:[UIColor moduleSeparatorColorF7F7]];
        
        //线
        UIView * lineView = [UIView creatViewWithSuperView:bgView backgroundColor:[UIColor textColor9999]];
        [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(180, .5));
            make.center.offset(0);
        }];
        
        //标题
        UILabel * titleLabel = [UILabel creatLabelWithSuperView:bgView title:@"猜你喜欢" titleFontSize:[UIFont qg_mediumFontOfSize:18] textColor:[UIColor textColor3333] alignment:NSTextAlignmentCenter];
        titleLabel.backgroundColor = bgView.backgroundColor;
        [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.center.offset(0);
            make.width.mas_equalTo(80);
        }];
        
        return bgView;
    }
    return nil;
}


#pragma mark - UIScrollViewDelegate
- (void)scrollViewDidScroll:(UIScrollView *)scrollView
{
    CGFloat scrollHeight = 44 + [DeviceAdaptation getNavBarAndStatusBarHeight];
    CGFloat offsetY = scrollView.contentOffset.y;
    CGFloat alpha = MAX(MIN(offsetY/scrollHeight, 1), 0);
    [self setNavBarBackgroundAlpha:alpha];
    self.title = alpha > 0.8 ? @"商品详情" : nil;
    //滚到顶部
//    self.topButton.hidden = offsetY > MAINSCREEN_HEIGHT ? NO : YES;
}

#pragma mark - Action

/// 推荐点击事件
- (void)recommendGoodsClick:(QGMallBaseGoodsModel *)goodsModel
{
    [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGMallGoodsDetailViewController) parameters:@{@"goodsId":goodsModel.goodsId} handlerBlock:nil];
}


/// 分享按钮点击
- (void)shareButtonClick
{
    //检测登录
    if (![QGUserInfo sharedUserInfo].isLogin) {
        [self showLoginViewController];
        return;
    }

    //普通用户要先成为推广官
    if (self.detailInfoModel.goodsInfo.promoterLevel.integerValue == 1) {
        //神策埋点
        QGAppCoreModelClickEvent * clickEvent = [QGAppCoreModelClickEvent acmcEventWithPage:@"商品详情页" path:@"分享" name:@"去升级" detail_name:self.goodsId acmc_model_other:self.detailInfoModel.goodsInfo.goodsName];
        [QGAnalyticsService analyticsTrackWithEvent:clickEvent];
    }
    else
    {
        //神策埋点
        QGAppCoreModelClickEvent * clickEvent = [QGAppCoreModelClickEvent acmcEventWithPage:@"商品详情页" path:@"分享" name:@"分享赚收益" detail_name:self.goodsId acmc_model_other:self.detailInfoModel.goodsInfo.goodsName];
        [QGAnalyticsService analyticsTrackWithEvent:clickEvent];
    }
    
    //检测授权
    if ([QGBaiChuanManager isAliMamaAuthed]) {
        //普通用户要先成为推广官
        if (self.detailInfoModel.goodsInfo.promoterLevel.integerValue == 1) {
            [self navigationToWeb:self.detailInfoModel.goodsInfo.promoterUrl];
        }
        else
        {
            [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGMallShareViewController) parameters:@{@"goodsId":self.goodsId} handlerBlock:nil];
        }
    }
    else
    {
        [[QGBaiChuanManager shareInstance] authAllAuthoritiesWithController:self.navigationController];
    }
}


/// 回家吧
- (void)goBackClick
{
    [self.navigationController popToRootViewControllerAnimated:YES];
}

- (void)backToTopClick
{
    [self.tableView scrollRectToVisible:CGRectMake(0, 0, 1, 1) animated:YES];
}

///优惠券点击事件
- (void)couponButtonClick
{
    //数据埋点 每次打开只记录一次
    QGAppCoreModelClickEvent * event = [QGAppCoreModelClickEvent acmcEventWithPage:@"商品详情页" path:@"商品详情" name:@"商品详情领券" detail_name:self.detailInfoModel.goodsInfo.goodsId acmc_model_other:self.detailInfoModel.goodsInfo.goodsName];
    [QGAnalyticsService analyticsTrackWithEvent:event];
    
    [self openGoodsUrl];
}

///购买按钮点击事件
- (void)orderButtonClick
{
    //数据埋点 每次打开只记录一次
    QGAppCoreModelClickEvent * event = [QGAppCoreModelClickEvent acmcEventWithPage:@"商品详情页" path:@"商品详情" name:@"商品详情购买" detail_name:self.detailInfoModel.goodsInfo.goodsId acmc_model_other:self.detailInfoModel.goodsInfo.goodsName];
    [QGAnalyticsService analyticsTrackWithEvent:event];
    
    [self openGoodsUrl];
}

/// 打开商品链接
- (void)openGoodsUrl
{
    //检测登录
    if (![QGUserInfo sharedUserInfo].isLogin) {
        [self showLoginViewController];
        return;
    }
    
    if (![QGBaiChuanManager isAliMamaAuthed]) {
        [[QGBaiChuanManager shareInstance] authAllAuthoritiesWithController:self.navigationController];
        return;
    }
    
    @weakify(self);
    [self requestGoodsUrlWithSuccess:^(NSString *goodsUrl) {
        @strongify(self);
        //打开链接，内部检测是否授权过
        [[QGBaiChuanManager shareInstance] openURL:goodsUrl taokePid:self.detailInfoModel.goodsInfo.tbkPid navigationController:self.navigationController];
    }];
}


/// 商品图片点击事件
- (void)bannerImgClick:(NSInteger)index fromView:(UIView *)fromView
{
    if (self.detailInfoModel.goodsInfo.goodsSmallImgs.count <= index) {
        return;
    }
    MagnifyImageView *imageView = [[MagnifyImageView alloc] initMagnifyImageViewWithDefault:fromView index:index allImages:self.detailInfoModel.goodsInfo.goodsSmallImgs isNeedPageControl:YES];
    [imageView addKeyWindow];
}


#pragma mark - Notification

- (void)addNotification
{
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(requestGoodsData) name:ModelCenterUserLoginNotification object:nil];
}

- (void)removeNotofication
{
    [[NSNotificationCenter defaultCenter] removeObserver:self name:ModelCenterUserLoginNotification object:nil];
}



@end
