//
//  QGMallGoodsDetailShopCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/2/26.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallGoodsDetailShopCell.h"

#import "QGBasicUITool.h"
#import "UIImageView+QGWebCache.h"

@interface QGMallGoodsDetailShopCell () <UICollectionViewDelegate, UICollectionViewDataSource>

/// 店铺图标
@property (nonatomic, strong) UIImageView * shopImgView;

/// 店铺名称
@property (nonatomic, strong) UILabel * shopNameLabel;

///渠道图片
@property (nonatomic, strong) UIImageView * channleImgView;

/// 买家服务评分
@property (nonatomic, strong) UILabel * serviceScoreLabel;

/// 店铺标签
@property (nonatomic, strong) UICollectionView * tagCollectionView;

@end

@implementation QGMallGoodsDetailShopCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        //分割层
        UIView * segmentView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor moduleSeparatorColorF7F7]];
        [segmentView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.inset(0);
            make.height.mas_equalTo(10);
        }];
        
        //店铺图标
        self.shopImgView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:nil];
        self.shopImgView.backgroundColor = [UIColor moduleSeparatorColorF7F7];
        self.shopImgView.layer.cornerRadius = 3;
        self.shopImgView.clipsToBounds = YES;
        [self.shopImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(44, 44));
            make.left.inset(15);
            make.top.mas_equalTo(segmentView.mas_bottom).offset(15);
        }];
        
        //店铺名称
        self.shopNameLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_regularFontOfSize:16] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [self.shopNameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.shopImgView.mas_right).offset(7);
            make.right.inset(15);
            make.top.mas_equalTo(self.shopImgView.mas_top).offset(3);
        }];
        
        //渠道图标
        self.channleImgView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:nil];
        [self.channleImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.shopNameLabel);
            make.bottom.mas_equalTo(self.shopImgView.mas_bottom).offset(0);
            make.size.mas_equalTo(CGSizeMake(27, 14));
        }];
        
       
        
        //卖家服务
        self.serviceScoreLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_regularFontOfSize:12] textColor:[UIColor textColor9999] alignment:NSTextAlignmentCenter];
        [self.serviceScoreLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.bottom.mas_equalTo(self.channleImgView.mas_bottom).offset(2);
            make.left.mas_equalTo(self.channleImgView.mas_right).offset(10);
        }];
        
        

        
        /*
        //tag模块
        UICollectionViewFlowLayout *layout = [[UICollectionViewFlowLayout alloc] init];
        layout.scrollDirection = UICollectionViewScrollDirectionHorizontal;
        layout.minimumLineSpacing = 0;
        layout.minimumInteritemSpacing = 15;
        self.tagCollectionView = [[UICollectionView alloc] initWithFrame:CGRectZero collectionViewLayout:layout];
        self.tagCollectionView.backgroundColor = [UIColor whiteColor];
        self.tagCollectionView.scrollEnabled = NO;
        self.tagCollectionView.showsVerticalScrollIndicator = NO;
        self.tagCollectionView.showsHorizontalScrollIndicator = NO;
        self.tagCollectionView.dataSource = self;
        self.tagCollectionView.delegate = self;
        [self.contentView addSubview:self.tagCollectionView];
        
        [self.tagCollectionView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(15);
            make.height.mas_equalTo(18);
            make.top.mas_equalTo(lineView.mas_bottom).offset(12);
        }];
        
        [self.tagCollectionView registerClass:[QGGoodsDetailShopTagCell class] forCellWithReuseIdentifier:NSStringFromClass([QGGoodsDetailShopTagCell class])];
         */
    }
    return self;
}

- (void)setShopModel:(QGShopInfoModel *)shopModel
{
    if (_shopModel != shopModel) {
        _shopModel = shopModel;
        
        [self.shopImgView setMallImageByNomalPlaceholderWithURLString:shopModel.shopImg];
        [self.channleImgView setMallImageByNomalPlaceholderWithURLString:shopModel.shopTypeImg];
        self.shopNameLabel.text = shopModel.shopName;
        self.serviceScoreLabel.text = [NSString stringWithFormat:@"卖家服务:%@",shopModel.serviceScore];
        self.serviceScoreLabel.hidden = [NSString isEmpty:shopModel.serviceScore];
        
//        [self.tagCollectionView reloadData];
    }
}

#pragma mark - UICollectionViewDataSource
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return MIN(self.shopModel.shopTags.count, 4);
}

- (__kindof UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    QGGoodsDetailShopTagCell * cell = (QGGoodsDetailShopTagCell *)[collectionView dequeueReusableCellWithReuseIdentifier:NSStringFromClass([QGGoodsDetailShopTagCell class]) forIndexPath:indexPath];
    cell.tagLabel.text = self.shopModel.shopTags[indexPath.row];
    return cell;
}


- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout sizeForItemAtIndexPath:(NSIndexPath *)indexPath
{
    NSString * tagStr = self.shopModel.shopTags[indexPath.row];
    CGFloat width = [NSString getWidthWithContent:tagStr height:18 UIFont:[UIFont qg_regularFontOfSize:11]];
    return CGSizeMake(width + 14 + 2, 18);
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end


@implementation QGGoodsDetailShopTagCell

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
       
        
        //图标
        UIImageView * smallIconImg = [UIImageView creatImageViewWithSuperView:self.contentView imageName:@"mall_goodsdetail_tag_icon"];
        [smallIconImg mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.offset(0);
            make.size.mas_equalTo(CGSizeMake(14, 14));
            make.centerY.offset(0);
        }];
        
        
        //标签
       self.tagLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_regularFontOfSize:11] textColor:[UIColor textColor9999] alignment:NSTextAlignmentCenter];
       [self.tagLabel mas_makeConstraints:^(MASConstraintMaker *make) {
           make.centerY.offset(0);
           make.left.mas_equalTo(smallIconImg.mas_right).offset(2);
       }];
    }
    return self;
}

@end



