//
//  QGMallGoodsDetailCouponCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/2/26.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallGoodsDetailCouponCell.h"
#import "QGGradientView.h"
#import "QGBasicUITool.h"
#import "QGDashPatternView.h"
#import "QGGradientShadowButton.h"
@interface QGMallGoodsDetailCouponCell ()

/// 优惠券金额
@property (nonatomic, strong) UILabel * couponAmountLabel;

/// 优惠券有效期
@property (nonatomic, strong) UILabel * couponValidDateLabel;

@end

@implementation QGMallGoodsDetailCouponCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        UIView * topLineView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor lineSeparatorColorDCDC]];
        [topLineView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(15);
            make.height.mas_equalTo(.5);
            make.top.inset(0);
        }];
        
        //渐变色
        QGGradientView * gradientView = [[QGGradientView alloc] init];
        gradientView.gradientLayer.colors = [UIColor gradientColorsAlpha:0.1];
        gradientView.layer.cornerRadius = 6;
        gradientView.clipsToBounds = YES;
        [self.contentView addSubview:gradientView];
        [gradientView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(15);
            make.top.bottom.inset(20);
        }];
        
        //渐变色背景
        UIImageView * bgImgView = [UIImageView creatImageViewWithSuperView:gradientView imageName:@"mall_goodsdetail_coupon"];
        [bgImgView mas_makeConstraints:^(MASConstraintMaker *make) {
//            make.width.mas_equalTo(223);
            make.right.inset(121);
            make.left.top.bottom.inset(0);
        }];
        
        //立即领取
        QGGradientShadowButton * receiveButton = [QGGradientShadowButton creatGradientColorButtonWithSuperView:gradientView title:@"立即领取" textFont:[UIFont qg_mediumFontOfSize:12]];
        receiveButton.userInteractionEnabled = NO;
        [receiveButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(convertEqualScaleFrom375(15));
            make.size.mas_equalTo(CGSizeMake(88, 24));
            make.centerY.offset(0);
        }];
        
        
        //优惠券金额
        self.couponAmountLabel = [UILabel creatLabelWithSuperView:gradientView title:nil titleFontSize:nil textColor:nil alignment:NSTextAlignmentCenter];
        [self.couponAmountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(18);
            make.centerY.offset(0);
        }];
        
        //优惠券
        UILabel * titleLabel = [UILabel creatLabelWithSuperView:gradientView title:@"优惠券" titleFontSize:[UIFont qg_mediumFontOfSize:12] textColor:[UIColor whiteColor] alignment:NSTextAlignmentLeft];
        [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.couponAmountLabel.mas_right).offset(5);
            make.top.inset(16);
            make.height.mas_equalTo(17);
        }];
        
        //优惠券有效期
        self.couponValidDateLabel = [UILabel creatLabelWithSuperView:gradientView title:nil titleFontSize:[UIFont qg_regularFontOfSize:12] textColor:[UIColor whiteColor] alignment:NSTextAlignmentCenter];
        [self.couponValidDateLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.height.mas_equalTo(17);
            make.left.mas_equalTo(titleLabel);
            make.bottom.inset(16);
        }];
    }
    return self;
}


- (void)setDetailInfoModel:(QGGoodsDetailModel *)detailInfoModel
{
    if (_detailInfoModel != detailInfoModel) {
        _detailInfoModel = detailInfoModel;
        
        self.couponAmountLabel.attributedText = detailInfoModel.showCouponAmountStr;
        self.couponValidDateLabel.text = [NSString stringWithFormat:@"有效期:%@",detailInfoModel.couponValidDate];
    }
}



- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
