//
//  QGMallGoodsDetailBottomView.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/9.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallGoodsDetailBottomView.h"
#import "QGBasicUITool.h"
#import "QGGradientView.h"

@interface QGMallGoodsDetailBottomView ()

/// 分享标题
@property (nonatomic, strong) UILabel * shareTitleLabel;

/// 分享金额
@property (nonatomic, strong) UILabel * shareAmountLabel;

/// 购买文案
@property (nonatomic, strong) UILabel * orderTitleLabel;

/// 下单节约金额
@property (nonatomic, strong) UILabel * orderAmountLabel;


/// 首页按钮
@property (nonatomic, strong, readwrite) UIButton * goHomeButton;

/// 分享按钮
@property (nonatomic, strong, readwrite) UIButton * shareButton;

/// 立即购买按钮
@property (nonatomic, strong, readwrite) UIButton * orderButton;

@end

@implementation QGMallGoodsDetailBottomView

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        [self initNormakUI];
    }
    return self;
}

- (void)initNormakUI
{
    //回首页图标
    UIImageView * goBackImg = [UIImageView creatImageViewWithSuperView:self imageName:@"mall_goodsdetail_gohome"];
    [goBackImg mas_makeConstraints:^(MASConstraintMaker *make) {
       make.top.inset(9);
       make.left.inset(17);
       make.size.mas_equalTo(CGSizeMake(36, 36));
    }];

    //回首页文案
    UILabel * goBackLabel = [UILabel creatLabelWithSuperView:self title:@"首页" titleFontSize:[UIFont qg_regularFontOfSize:12] textColor:[UIColor textColor9999] alignment:NSTextAlignmentCenter];
    [goBackLabel mas_makeConstraints:^(MASConstraintMaker *make) {
       make.centerX.mas_equalTo(goBackImg);
       make.top.mas_equalTo(goBackImg.mas_bottom).offset(0);
    }];

    //回到首页按钮
    self.goHomeButton = [UIButton creatButtonWithSuperView:self title:nil titleFont:nil textColor:nil];
    //扩大热区
    [self.goHomeButton mas_makeConstraints:^(MASConstraintMaker *make) {
       make.left.top.bottom.inset(0);
       make.width.mas_equalTo(70);
    }];

    //渐变色底层
    UIView * gradientBGView = [UIView creatViewWithSuperView:self backgroundColor:nil];
    gradientBGView.layer.cornerRadius = 20;
    gradientBGView.clipsToBounds = YES;
    [gradientBGView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(self.goHomeButton.mas_right);
        make.right.inset(15);
        make.height.mas_equalTo(40);
        make.centerY.offset(0);
    }];
    
    //分享区域
    QGGradientView * leftGradientView = [[QGGradientView alloc] init];
    leftGradientView.gradientLayer.colors = @[(id)[UIColor colorWithHexString:@"F2CD8B"].CGColor, (id)[UIColor colorWithHexString:@"E9B176"].CGColor];
    [gradientBGView addSubview:leftGradientView];
    [leftGradientView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.top.bottom.mas_equalTo(0);
        make.width.mas_equalTo(gradientBGView.mas_width).multipliedBy(0.5);
    }];
    
    //分享文案
    self.shareTitleLabel = [UILabel creatLabelWithSuperView:leftGradientView title:@"分享" titleFontSize:[UIFont qg_mediumFontOfSize:14] textColor:[UIColor whiteColor] alignment:NSTextAlignmentCenter];
    [self.shareTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.offset(0);
        make.top.inset(2);
        make.height.mas_equalTo(20);
    }];
    
    //分享返现金额
    self.shareAmountLabel = [UILabel creatLabelWithSuperView:leftGradientView title:nil titleFontSize:[UIFont qg_regularFontOfSize:11] textColor:[UIColor whiteColor] alignment:NSTextAlignmentCenter];
    [self.shareAmountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.inset(3);
        make.left.right.inset(5);
        make.height.mas_equalTo(16);
    }];
    
    //分享按钮
    self.shareButton = [UIButton creatButtonWithSuperView:leftGradientView title:nil titleFont:nil textColor:nil];
    [self.shareButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.top.bottom.inset(0);
    }];
    
    
    //立即购买区域
    QGGradientView * rightGradientView = [[QGGradientView alloc] init];
    [gradientBGView addSubview:rightGradientView];
    [rightGradientView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.top.bottom.inset(0);
        make.width.mas_equalTo(gradientBGView.mas_width).multipliedBy(0.5);
    }];
    
    //购买文案
    self.orderTitleLabel = [UILabel creatLabelWithSuperView:rightGradientView title:@"立即购买" titleFontSize:self.shareTitleLabel.font textColor:self.shareTitleLabel.textColor alignment:self.shareTitleLabel.textAlignment];
    [self.orderTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.offset(0);
        make.top.inset(2);
        make.height.mas_equalTo(20);
    }];
    
    //购买节约金额
    self.orderAmountLabel = [UILabel creatLabelWithSuperView:rightGradientView title:nil titleFontSize:self.shareAmountLabel.font textColor:self.shareAmountLabel.textColor alignment:self.shareAmountLabel.textAlignment];
    [self.orderAmountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.inset(3);
        make.left.right.inset(5);
        make.height.mas_equalTo(16);
    }];
    
    //下单按钮
    self.orderButton = [UIButton creatButtonWithSuperView:rightGradientView title:nil titleFont:nil textColor:nil];
    [self.orderButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.top.bottom.inset(0);
    }];
    
}


/// 设置返现金额和节约金额
/// @param shareAmount 返现金额
/// @param orderAmount 节约金额
- (void)setShareAmount:(NSString *)shareAmount orderAmount:(NSString *)orderAmount
{
    if (![NSString isEmpty:shareAmount]) {
        self.shareAmountLabel.text = shareAmount;
        self.shareAmountLabel.hidden = NO;
        
        [self.shareTitleLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.centerX.offset(0);
            make.top.inset(2);
            make.height.mas_equalTo(20);
        }];
    }
    //否则分享居中
    else
    {
        self.shareAmountLabel.hidden = YES;
        
        [self.shareTitleLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.centerX.centerY.offset(0);
        }];
    }
    
    if (![NSString isEmpty:orderAmount]) {
        self.orderAmountLabel.text = orderAmount;
        self.orderAmountLabel.hidden = NO;
        
        [self.orderTitleLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.centerX.offset(0);
            make.top.inset(2);
            make.height.mas_equalTo(20);
        }];
    }
    //否则购买居中
    else
    {
        self.orderAmountLabel.hidden = YES;
        
        [self.orderTitleLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.centerX.centerY.offset(0);
        }];
    }
}


@end
