//
//  QGMallGoodsDetailInfoModel.m
//  VirtualPayment
//
//  Created by 张博 on 2020/2/26.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallGoodsDetailInfoModel.h"
#import "QGBasicUITool.h"
#import "NSString+QGURLParam.h"
@implementation QGMallGoodsDetailInfoModel

+ (NSDictionary *)modelContainerPropertyGenericClass {
    return @{@"recommendGoodsList" : [QGGoodsListModel class]};
}

+ (NSArray *)modelPropertyBlacklist {
    return @[@"recommendCellHeight"];
}


- (CGFloat)recommendCellHeight
{
    if (_recommendCellHeight == 0 && self.recommendGoodsList.count > 0) {
        //从数组里面随便取出一个已计算好的高度
        QGGoodsListModel * goodsModel = self.recommendGoodsList.firstObject;
        _recommendCellHeight = goodsModel.verticalCellSize.height;
    }
    return _recommendCellHeight;
}



@end


@implementation QGGoodsDetailModel

+ (NSArray *)modelPropertyBlacklist {
    return @[@"goodsNameTool",@"cellHeight",@"showCouponAmountStr",@"showDetailSalePriceStr"];
}




- (NSAttributedString *)showDetailSalePriceStr
{
    if (_showDetailSalePriceStr.length == 0 && self.goodsSalePrice.length > 0) {
        NSString * salePriceBegan = @"¥";
        NSString * salePriceEnd = self.goodsSalePrice;
        //拼接之后的所有价格
        NSString * allPriceStr = [NSString stringWithFormat:@"%@%@",salePriceBegan,salePriceEnd];
        
        //开始初始化富文本
        ZHAttributedLabelTool * priceTool = [[ZHAttributedLabelTool alloc] initWithText:allPriceStr font:[UIFont qg_mediumFontOfSize:30] color:[UIColor yyMainThemeColor]];
        [priceTool addFont:[UIFont qg_mediumFontOfSize:14] range:[allPriceStr rangeOfString:salePriceBegan]];
        _showDetailSalePriceStr = priceTool.getResultString;
    }
    return _showDetailSalePriceStr;
}



- (ZHAttributedLabelTool *)goodsNameTool
{
    if (!_goodsNameTool && self.goodsName.length > 0) {
        ZHAttributedLabelTool * nameTool = [[ZHAttributedLabelTool alloc] initWithText:self.goodsName font:[UIFont qg_regularFontOfSize:16] color:[UIColor textColor3333]];
        //图片宽度24 + 3的距离
        [nameTool setFirstLineHeadIndent:24 + 3];
        _goodsNameTool = nameTool;
    }
    return _goodsNameTool;
}

- (NSAttributedString *)showCouponAmountStr
{
    if (_showCouponAmountStr.length == 0 && self.couponAmount.length > 0) {
        NSString * allPriceStr = [NSString stringWithFormat:@"¥%@",self.couponAmount];
        ZHAttributedLabelTool * priceTool = [[ZHAttributedLabelTool alloc] initWithText:allPriceStr font:[UIFont qg_mediumFontOfSize:20] color:[UIColor whiteColor]];
        [priceTool addFont:[UIFont qg_mediumFontOfSize:18] range:NSMakeRange(0, 1)];
//        [priceTool addBaselineOffset:-2 range:[allPriceStr rangeOfString:self.couponAmount]];
        _showCouponAmountStr = priceTool.getResultString;
    }
    return _showCouponAmountStr;
}

- (CGFloat)cellHeight
{
    if (_cellHeight == 0 && self.goodsName.length > 0) {
         CGFloat nameHeigh = [self.goodsNameTool getSizeWithMaxWidth:MAINSCREEN_WIDTH - 15 * 2].height;
        _cellHeight = 45 + nameHeigh + 36;
        
        if (self.promoterTips) {
            _cellHeight = 108 + nameHeigh + 36;
        }
    }
    return _cellHeight;
}


@end


@implementation QGGoodsPromoterTipsModel

+ (NSArray *)modelPropertyBlacklist {
    return @[@"showPromoterAmountTitleStr"];
}


- (NSAttributedString *)showPromoterAmountTitleStr
{
    if (_showPromoterAmountTitleStr.length == 0 && self.promoterExpression.length > 0 && self.returnEarnAmount.length > 0 && self.promoterEarnAmount.length > 0) {
        
        NSString * amountTitleStr = self.promoterExpression;
        //替换文案
        amountTitleStr = [amountTitleStr filterURLParam:@"returnEarnAmount" value:self.returnEarnAmount];
        amountTitleStr = [amountTitleStr filterURLParam:@"promoterEarnAmount" value:self.promoterEarnAmount];
        ZHAttributedLabelTool * amountTool = [[ZHAttributedLabelTool alloc] initWithText:amountTitleStr font:[UIFont qg_regularFontOfSize:12] color:[UIColor textColor3333]];
        //设置颜色和字体
        [amountTool addColor:[UIColor yyMainThemeColor] range:[amountTitleStr rangeOfString:self.returnEarnAmount]];
        [amountTool addFont:[UIFont qg_mediumFontOfSize:12] range:[amountTitleStr rangeOfString:self.returnEarnAmount]];
        
        [amountTool addColor:[UIColor yyMainThemeColor] range:[amountTitleStr rangeOfString:self.promoterEarnAmount]];
        [amountTool addFont:[UIFont qg_mediumFontOfSize:12] range:[amountTitleStr rangeOfString:self.promoterEarnAmount]];
        
        _showPromoterAmountTitleStr = [amountTool getResultString];
    }
    return _showPromoterAmountTitleStr;
}


@end


@implementation QGShopInfoModel



@end

@implementation QGGoodsListModel


@end

