//
//  QGMallGoodsDetailInfoModel.h
//  VirtualPayment
//
//  Created by 张博 on 2020/2/26.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGBaseModel.h"
#import "QGMallBaseGoodsModel.h"
#import "ZHAttributedLabelTool.h"

@class QGGoodsDetailModel, QGShopInfoModel, QGGoodsListModel, QGGoodsPromoterTipsModel;
NS_ASSUME_NONNULL_BEGIN

@interface QGMallGoodsDetailInfoModel : QGBaseModel

/// 商品详情
@property (nonatomic, strong) QGGoodsDetailModel * goodsInfo;

/// 商品列表数据
@property (nonatomic, strong) NSArray <QGGoodsListModel *>* recommendGoodsList;

/// 商铺信息
@property (nonatomic, strong) QGShopInfoModel * shopInfo;


/// 推荐cell高度
@property (nonatomic, assign) CGFloat recommendCellHeight;

@end



/// 商品详情
@interface QGGoodsDetailModel : QGMallBaseGoodsModel

/// 图片数组
@property (nonatomic, strong) NSArray * goodsSmallImgs;

/// 百川需要的淘宝客pid
@property (nonatomic, strong) NSString * tbkPid;

/// 分享返现
@property (nonatomic, strong) NSString * shareEarnAmount;

/// 分享返现后台拼接字段
@property (nonatomic, strong) NSString * shareEarnAmountDesc;

/// 节省金额
@property (nonatomic, strong) NSString * earnAmount;

/// 节省金额后台拼接字段
@property (nonatomic, strong) NSString * earnAmountDesc;

/// 推广提升模型
@property (nonatomic, strong) QGGoodsPromoterTipsModel * promoterTips;

/// 推广描述
@property (nonatomic, strong) NSString * promoterEarnDesc;

/// 推广链接，普通用户
@property (nonatomic, strong) NSString * promoterUrl;

/// 用户级别，1普通用户，2推广新人，3推广达人，4推广专家
@property (nonatomic, strong) NSString * promoterLevel;

/// 展示优惠券金额
@property (nonatomic, strong) NSAttributedString * showCouponAmountStr;

///详情页商品价格
@property (nonatomic, strong) NSAttributedString * showDetailSalePriceStr;



/// 商品名称工具
@property (nonatomic, strong) ZHAttributedLabelTool * goodsNameTool;

/// cell高度
@property (nonatomic, assign) CGFloat cellHeight;

@end


/// 返现提升模型
@interface QGGoodsPromoterTipsModel : QGBaseModel

/// 平台补贴金额
@property (nonatomic, strong) NSString * promoterEarnAmount;

/// 返现金额
@property (nonatomic, strong) NSString * returnEarnAmount;

/// 推广文案
@property (nonatomic, strong) NSString * promoterDesc;

/// 推广返现计算公式文案
@property (nonatomic, strong) NSString * promoterExpression;

/// 推广图片
@property (nonatomic, strong) NSString * promoterImg;


/// 推广预估返现的金额拼接
@property (nonatomic, strong) NSAttributedString * showPromoterAmountTitleStr;

@end



/// 店铺信息
@interface QGShopInfoModel : QGBaseModel

/// 物流评分
@property (nonatomic, strong) NSString * logisticsScore;

/// 服务评分
@property (nonatomic, strong) NSString * serviceScore;

/// 店铺评分
@property (nonatomic, strong) NSString * shopScore;

/// 店铺id
@property (nonatomic, strong) NSString * shopId;

/// 店铺图片
@property (nonatomic, strong) NSString * shopImg;

/// 店铺名称
@property (nonatomic, strong) NSString * shopName;

/// 店铺标签
@property (nonatomic, strong) NSArray * shopTags;

/// 渠道图片
@property (nonatomic, strong) NSString * shopTypeImg;

/// 渠道类型，1淘宝， 2天猫，3京东，4饿了么，5苏宁
@property (nonatomic, strong) NSString * shopType;

@end

/// 商品列表
@interface QGGoodsListModel : QGMallBaseGoodsModel


@end

NS_ASSUME_NONNULL_END
