//
//  QGMallHeaderItemView.m
//  VirtualPayment
//
//  Created by silicn on 2020/3/11.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallMaterialView.h"

#import "QGBasicUITool.h"

#import "UIImageView+WebCache.h"

@implementation QGMallMaterialItem

@end

@implementation QGMallMaterialItemCell

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.imageView = [UIView creatImageViewWithSuperView:self imageName:nil];
        [self.imageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(self).inset(10);
            make.width.height.mas_equalTo(48);
            make.centerX.equalTo(self);
        }];
        
        self.textLab = [UIView creatLabelWithSuperView:self title:nil titleFontSize:[UIFont qg_regularFontOfSize:12.0f] textColor:UIColor.textColor3333 alignment:NSTextAlignmentCenter];
        [self.textLab mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(self.imageView.mas_bottom).offset(8);
            make.centerX.equalTo(self.imageView);
            make.left.right.lessThanOrEqualTo(self).inset(8);
        }];
    }
    return self;
}

- (void)setItem:(QGMallMaterialItem *)item
{
    if (_item != item) {
        _item = item;
        self.textLab.text = item.name;
        [self.imageView sd_setImageWithURL:[NSURL URLWithString:item.img]];
    }
}

@end


@interface QGMallMaterialView ()<UICollectionViewDelegate,UICollectionViewDataSource>

@property (nonatomic, strong)UICollectionView *collectionView;

@end

@implementation QGMallMaterialView

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        UICollectionViewFlowLayout *layout = [[UICollectionViewFlowLayout alloc]init];
        CGFloat kScreenWidth =[UIScreen mainScreen].bounds.size.width;
        layout.itemSize = CGSizeMake(kScreenWidth/4, kMaterialItemHeight);
        layout.sectionInset = UIEdgeInsetsMake(0, 0, 0, 0);
        layout.minimumLineSpacing = 0;
        layout.minimumInteritemSpacing = 0;
        
        self.collectionView = [[UICollectionView alloc]initWithFrame:CGRectZero collectionViewLayout:layout];
        _collectionView.backgroundColor = [UIColor whiteColor];
        _collectionView.delegate = self;
        _collectionView.dataSource = self;
        _collectionView.scrollEnabled = NO;
        [self addSubview:_collectionView];
        
        [self.collectionView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.edges.equalTo(self);
        }];
        
        [self.collectionView registerClass:[QGMallMaterialItemCell class] forCellWithReuseIdentifier:@"QGMallMaterialItemCell"];
    }
    return self;
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return self.items.count > 8 ? 8:self.items.count;
}

// The cell that is returned must be retrieved from a call to -dequeueReusableCellWithReuseIdentifier:forIndexPath:
- (__kindof UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    QGMallMaterialItemCell *cell  =[collectionView dequeueReusableCellWithReuseIdentifier:@"QGMallMaterialItemCell" forIndexPath:indexPath];
    cell.item = self.items[indexPath.row];
    return cell;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    [collectionView deselectItemAtIndexPath:indexPath animated:YES];
    if (self.touchBlock) {
        self.touchBlock(self.items[indexPath.row]);
    }
}

- (void)setItems:(NSArray<QGMallMaterialItem *> *)items
{
    _items = items;
    [self.collectionView reloadData];
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
